/*
 * Decompiled with CFR 0.152.
 */
package com.rackspacecloud.client.cloudfiles.wrapper;

import com.rackspacecloud.client.cloudfiles.IFilesTransferCallback;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamWrapper
extends OutputStream {
    private OutputStream stream;
    private IFilesTransferCallback callback = null;
    private static final int callbackInterval = 8192;
    private long lastCallback = 0L;
    private long bytesTransfered = 0L;

    public OutputStreamWrapper(OutputStream os, IFilesTransferCallback callback) {
        this.stream = os;
        this.callback = callback;
    }

    public void write(int b) throws IOException {
        this.stream.write(b);
        ++this.bytesTransfered;
        this.checkCallback(false);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.callback == null) {
            this.stream.write(b, off, len);
            return;
        }
        while (len > 0) {
            int toWrite = Math.min(len, 8192);
            this.stream.write(b, off, toWrite);
            this.bytesTransfered += (long)toWrite;
            off += toWrite;
            len -= toWrite;
            this.checkCallback(false);
        }
        this.checkCallback(true);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void close() throws IOException {
        this.stream.close();
        this.checkCallback(true);
    }

    public void flush() throws IOException {
        this.stream.flush();
        this.checkCallback(true);
    }

    private void checkCallback(boolean force) {
        if (this.callback != null && (this.bytesTransfered - this.lastCallback >= 8192L || force && this.bytesTransfered != this.lastCallback)) {
            this.callback.progress(this.bytesTransfered);
            this.lastCallback = this.bytesTransfered;
        }
    }
}

