/*
 * Decompiled with CFR 0.152.
 */
package com.rackspacecloud.client.cloudfiles.sample;

import com.rackspacecloud.client.cloudfiles.FilesAuthorizationException;
import com.rackspacecloud.client.cloudfiles.FilesClient;
import com.rackspacecloud.client.cloudfiles.FilesConstants;
import com.rackspacecloud.client.cloudfiles.FilesException;
import com.rackspacecloud.client.cloudfiles.FilesObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.http.HttpException;
import org.apache.log4j.Logger;

public class FilesCopy {
    private static final Logger logger = Logger.getLogger(FilesCopy.class);
    private static final String ZIPEXTENSION = ".zip";
    private static File SYSTEM_TMP = SystemUtils.getJavaIoTmpDir();

    public static void main(String[] args) throws NoSuchAlgorithmException, FilesException {
        Options options = FilesCopy.addCommandLineOptions();
        if (args.length <= 0) {
            FilesCopy.printHelp(options);
        }
        GnuParser parser = new GnuParser();
        try {
            String mimeType;
            String containerName;
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help")) {
                FilesCopy.printHelp(options);
            }
            if (line.hasOption("file") && line.hasOption("folder")) {
                System.err.println("Can not use both -file and -folder on the command line at the same time.");
                System.exit(-1);
            }
            if (line.hasOption("download")) {
                if (line.hasOption("folder")) {
                    String localFolder = FilenameUtils.normalize((String)line.getOptionValue("folder"));
                    String containerName2 = null;
                    if (StringUtils.isNotBlank((String)localFolder)) {
                        File localFolderObj = new File(localFolder);
                        if (localFolderObj.exists() && localFolderObj.isDirectory()) {
                            if (line.hasOption("container")) {
                                containerName2 = line.getOptionValue("container");
                                if (!StringUtils.isNotBlank((String)containerName2)) {
                                    System.err.println("You must provide a valid value for the  Container to upload to !");
                                    System.exit(-1);
                                }
                            } else {
                                System.err.println("You must provide the -container for a copy operation to work as expected.");
                                System.exit(-1);
                            }
                            System.out.println("Downloading all objects from: " + containerName2 + " to local folder: " + localFolder);
                            FilesCopy.getContainerObjects(localFolderObj, containerName2);
                        } else {
                            if (!localFolderObj.exists()) {
                                System.err.println("The local folder: " + localFolder + " does not exist.  Create it first and then run this command.");
                            }
                            if (!localFolderObj.isDirectory()) {
                                System.err.println("The local folder name supplied : " + localFolder + " is not a folder !");
                            }
                            System.exit(-1);
                        }
                    }
                }
                System.exit(0);
            }
            if (line.hasOption("folder")) {
                containerName = null;
                String folderPath = null;
                if (line.hasOption("container")) {
                    containerName = line.getOptionValue("container");
                    if (!StringUtils.isNotBlank((String)containerName)) {
                        System.err.println("You must provide a valid value for the  Container to upload to !");
                        System.exit(-1);
                    }
                } else {
                    System.err.println("You must provide the -container for a copy operation to work as expected.");
                    System.exit(-1);
                }
                if (StringUtils.isNotBlank((String)(folderPath = line.getOptionValue("folder")))) {
                    File folder = new File(FilenameUtils.normalize((String)folderPath));
                    if (folder.isDirectory()) {
                        if (line.hasOption("z")) {
                            System.out.println("Zipping: " + folderPath);
                            System.out.println("Nested folders are ignored !");
                            File zipedFolder = FilesCopy.zipFolder(folder);
                            mimeType = FilesConstants.getMimetype(ZIPEXTENSION);
                            FilesCopy.copyToCreateContainerIfNeeded(zipedFolder, mimeType, containerName);
                        } else {
                            File[] files;
                            for (File f : files = folder.listFiles()) {
                                String mimeType2 = FilesConstants.getMimetype(FilenameUtils.getExtension((String)f.getName()));
                                System.out.println("Uploading :" + f.getName() + " to " + folder.getName());
                                FilesCopy.copyToCreateContainerIfNeeded(f, mimeType2, containerName);
                                System.out.println("Upload :" + f.getName() + " to " + folder.getName() + " completed.");
                            }
                        }
                    } else {
                        System.err.println("You must provide a valid folder value for the -folder option !");
                        System.err.println("The value provided is: " + FilenameUtils.normalize((String)folderPath));
                        System.exit(-1);
                    }
                }
            }
            if (line.hasOption("file")) {
                containerName = null;
                String fileNamePath = null;
                if (line.hasOption("container")) {
                    containerName = line.getOptionValue("container");
                    if (!StringUtils.isNotBlank((String)containerName) || containerName.indexOf(47) != -1) {
                        System.err.println("You must provide a valid value for the  Container to upload to !");
                        System.exit(-1);
                    }
                } else {
                    System.err.println("You must provide the -container for a copy operation to work as expected.");
                    System.exit(-1);
                }
                if (StringUtils.isNotBlank((String)(fileNamePath = line.getOptionValue("file")))) {
                    String fileName = FilenameUtils.normalize((String)fileNamePath);
                    String fileExt = FilenameUtils.getExtension((String)fileNamePath);
                    mimeType = FilesConstants.getMimetype(fileExt);
                    File file = new File(fileName);
                    if (line.hasOption("z")) {
                        logger.info((Object)("Zipping " + fileName));
                        if (!file.isDirectory()) {
                            File zippedFile = FilesCopy.zipFile(file);
                            mimeType = FilesConstants.getMimetype(ZIPEXTENSION);
                            FilesCopy.copyTo(zippedFile, mimeType, containerName);
                            zippedFile.delete();
                        }
                    } else {
                        logger.info((Object)("Uploading " + fileName + "."));
                        if (!file.isDirectory()) {
                            FilesCopy.copyTo(file, mimeType, containerName);
                        } else {
                            System.err.println("The path you provided is a folder.  For uploading folders use the -folder option.");
                            System.exit(-1);
                        }
                    }
                } else {
                    System.err.println("You must provide a valid value for the file to upload !");
                    System.exit(-1);
                }
            }
        }
        catch (ParseException err) {
            System.err.println("Please see the logs for more details. Error Message: " + err.getMessage());
            err.printStackTrace(System.err);
        }
        catch (FilesAuthorizationException err) {
            logger.fatal((Object)("FilesAuthorizationException : Failed to login to your  account !" + (Object)((Object)err)));
            System.err.println("Please see the logs for more details. Error Message: " + err.getMessage());
        }
        catch (Exception err) {
            logger.fatal((Object)("IOException : " + err));
            System.err.println("Please see the logs for more details. Error Message: " + err.getMessage());
        }
    }

    public static void getContainerObjects(File localFolder, String containerName) throws IOException, HttpException, FilesAuthorizationException, NoSuchAlgorithmException, FilesException {
        FilesClient client = new FilesClient();
        if (client.login()) {
            if (client.containerExists(containerName)) {
                List<FilesObject> objects = client.listObjects(containerName);
                for (FilesObject obj : objects) {
                    System.out.println("\t" + StringUtils.rightPad((String)obj.getName(), (int)35) + obj.getSizeString());
                    File localFile = new File(FilenameUtils.concat((String)localFolder.getAbsolutePath(), (String)obj.getName()));
                    obj.writeObjectToFile(localFile);
                }
            } else {
                logger.fatal((Object)("The  container: " + containerName + " does not exist."));
                System.out.println("The  container: " + containerName + " does not exist!");
                System.exit(0);
            }
        }
    }

    private static void copyToCreateContainerIfNeeded(File file, String mimeType, String containerName) throws IOException, HttpException, NoSuchAlgorithmException, FilesException {
        FilesClient client = new FilesClient();
        if (client.login()) {
            if (client.containerExists(containerName)) {
                logger.info((Object)("Copying files to " + containerName));
                FilesCopy.copyTo(file, mimeType, containerName);
            } else {
                logger.warn((Object)("The  container: " + containerName + " does not exist.  Creating it first before placing objects into it."));
                System.out.println("The  container: " + containerName + " does not exist.  Creating it first before placing objects into it.");
                client.createContainer(containerName);
                FilesCopy.copyTo(file, mimeType, containerName);
            }
        }
    }

    private static void copyTo(File file, String mimeType, String containerName) throws IOException, HttpException, NoSuchAlgorithmException, FilesException {
        FilesClient client = new FilesClient();
        if (client.login()) {
            if (client.containerExists(containerName)) {
                client.storeObject(containerName, file, mimeType);
            } else {
                logger.info((Object)("The  container: " + containerName + " does not exist.  Create it first before placing objects into it."));
                System.out.println("The  container: " + containerName + " does not exist.  Create it first before placing objects into it.");
                System.exit(0);
            }
        }
    }

    public static File zipFolder(File folder) throws IOException {
        byte[] buf = new byte[1024];
        String filenameWithZipExt = folder.getName() + ZIPEXTENSION;
        File zippedFile = new File(FilenameUtils.concat((String)SYSTEM_TMP.getAbsolutePath(), (String)filenameWithZipExt));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zippedFile));
        if (folder.isDirectory()) {
            File[] files;
            for (File f : files = folder.listFiles()) {
                if (!f.isDirectory()) {
                    int len;
                    FileInputStream in = new FileInputStream(f);
                    out.putNextEntry(new ZipEntry(f.getName()));
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                    in.close();
                    continue;
                }
                logger.warn((Object)("Skipping nested folder: " + f.getAbsoluteFile()));
            }
        } else {
            logger.warn((Object)"The folder name supplied is not a folder!");
            System.err.println("The folder name supplied is not a folder!");
            return null;
        }
        out.flush();
        out.close();
        return zippedFile;
    }

    public static File zipFile(File f) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        String filenameWithZipExt = f.getName() + ZIPEXTENSION;
        File zippedFile = new File(FilenameUtils.concat((String)SYSTEM_TMP.getAbsolutePath(), (String)filenameWithZipExt));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zippedFile));
        FileInputStream in = new FileInputStream(f);
        out.putNextEntry(new ZipEntry(f.getName()));
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.closeEntry();
        out.flush();
        in.close();
        out.close();
        return zippedFile;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("List -file filename -container ContainerName [-z]", options);
    }

    private static Options addCommandLineOptions() {
        Option help = new Option("help", "print this message");
        OptionBuilder.withArgName((String)"folder");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"Name of folder to upload.  Only top level objects that are not folders will be uploaded.");
        Option folder = OptionBuilder.create((String)"folder");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"Name of file to upload to .");
        Option file = OptionBuilder.create((String)"file");
        OptionBuilder.withArgName((String)"container");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"Name of container to place objects into.");
        Option container = OptionBuilder.create((String)"container");
        Option zip = new Option("z", "zip", false, "Compress the object being placed into . This option can be used with other options e.g. -tar");
        Option download = new Option("d", "download", false, "Copy files from  to the local system.  Must be used in conjunction to -folder -file -container");
        Options options = new Options();
        options.addOption(folder);
        options.addOption(file);
        options.addOption(zip);
        options.addOption(help);
        options.addOption(container);
        options.addOption(download);
        return options;
    }
}

