/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.action;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.cloud.CloudPath;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.action.Worker;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WriteMetadataWorker
extends Worker<Map<String, String>> {
    private static Logger log = Logger.getLogger(WriteMetadataWorker.class);
    private List<Path> files;
    private Map<String, String> metadata;

    protected WriteMetadataWorker(List<Path> files, Map<String, String> metadata) {
        this.files = files;
        this.metadata = metadata;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(Locale.localizedString((String)"Writing metadata of {0}", (String)"Status"), this.toString(this.files));
    }

    @Override
    public Map<String, String> run() {
        for (Path next : this.files) {
            HashMap<String, String> updated = new HashMap<String, String>(this.metadata);
            for (String key : updated.keySet()) {
                if (!StringUtils.isBlank((String)((String)updated.get(key)))) continue;
                updated.put(key, (String)next.attributes().getMetadata().get(key));
            }
            if (((Object)updated).equals(next.attributes().getMetadata())) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Skip writing equal metadata for " + next));
                }
                return this.metadata;
            }
            ((CloudPath)next).writeMetadata(updated);
        }
        return this.metadata;
    }
}

