/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.action;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.action.Worker;
import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WriteAclWorker
extends Worker<Acl> {
    private static Logger log = Logger.getLogger(WriteAclWorker.class);
    private List<Path> files;
    private Acl acl;
    private boolean recursive;

    public WriteAclWorker(List<Path> files, Acl acl, boolean recursive) {
        this.files = files;
        this.acl = acl;
        this.recursive = recursive;
    }

    @Override
    public Acl run() {
        for (Path next : this.files) {
            if (!next.getSession().isConnected()) break;
            if (this.acl.isModified()) {
                next.writeAcl(this.acl, this.recursive);
                continue;
            }
            if (this.acl.equals((Object)next.attributes().getAcl())) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Skip writing equal ACL for " + next));
                }
                return this.acl;
            }
            next.writeAcl(this.acl, this.recursive);
        }
        return this.acl;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(Locale.localizedString((String)"Changing permission of {0} to {1}", (String)"Status"), this.toString(this.files), this.acl);
    }
}

