/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.action;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.cloud.CloudPath;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.action.Worker;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReadMetadataWorker
extends Worker<Map<String, String>> {
    private static Logger log = Logger.getLogger(ReadMetadataWorker.class);
    private Map<String, Integer> count = new HashMap<String, Integer>();
    private Map<String, String> updated = new HashMap<String, String>(){

        @Override
        public String put(String key, String value) {
            int n = 0;
            if (ReadMetadataWorker.this.count.containsKey(key)) {
                n = (Integer)ReadMetadataWorker.this.count.get(key);
            }
            ReadMetadataWorker.this.count.put(key, ++n);
            return super.put(key, value);
        }
    };
    private List<Path> files;

    public ReadMetadataWorker(List<Path> files) {
        this.files = files;
    }

    @Override
    public Map<String, String> run() {
        for (Path next : this.files) {
            if (next.attributes().getMetadata().isEmpty()) {
                ((CloudPath)next).readMetadata();
            }
            Map metadata = next.attributes().getMetadata();
            for (String key : metadata.keySet()) {
                if (this.updated.containsKey(key) && !((String)metadata.get(key)).equals(this.updated.get(key))) {
                    log.info((Object)("Nullify " + key + " from metadata because value is not equal for selected files."));
                    this.updated.put(key, null);
                    continue;
                }
                this.updated.put(key, (String)metadata.get(key));
            }
        }
        for (String key : this.count.keySet()) {
            if (this.files.size() == this.count.get(key).intValue()) continue;
            log.info((Object)("Remove " + key + " from metadata not available for all selected files."));
            this.updated.remove(key);
        }
        return this.updated;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(Locale.localizedString((String)"Reading metadata of {0}", (String)"Status"), this.toString(this.files));
    }
}

