/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.action;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.ui.action.Worker;
import java.text.MessageFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CalculateSizeWorker
extends Worker<Long> {
    private List<Path> files;
    private long total;

    public CalculateSizeWorker(List<Path> files) {
        this.files = files;
    }

    @Override
    public Long run() {
        for (Path next : this.files) {
            next.attributes().setSize(this.calculateSize((AbstractPath)next));
            if (next.getSession().isConnected()) continue;
            break;
        }
        return this.total;
    }

    private long calculateSize(AbstractPath p) {
        long size = 0L;
        if (p.attributes().isDirectory()) {
            for (AbstractPath next : p.children()) {
                size += this.calculateSize(next);
            }
        } else if (p.attributes().isFile()) {
            this.total += (size += p.attributes().getSize());
            this.update(this.total);
        }
        return size;
    }

    protected abstract void update(long var1);

    @Override
    public String getActivity() {
        return MessageFormat.format(Locale.localizedString((String)"Getting size of {0}", (String)"Status"), this.toString(this.files));
    }
}

