/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.util.xml;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.soyatec.windows.azure.authenticate.Base64;
import org.soyatec.windows.azure.authenticate.ISignedIdentifier;
import org.soyatec.windows.azure.blob.IContainerAccessControl;
import org.soyatec.windows.azure.blob.SharedAccessPermissions;
import org.soyatec.windows.azure.table.ETableColumnType;
import org.soyatec.windows.azure.table.Guid;
import org.soyatec.windows.azure.table.ICloudTableColumn;
import org.soyatec.windows.azure.table.ITableStorageEntity;
import org.soyatec.windows.azure.util.Logger;
import org.soyatec.windows.azure.util.Utilities;

public abstract class AtomUtil {
    public static String createTableXml(String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format("<entry xmlns:d=\"{0}\" xmlns:m=\"{1}\" xmlns=\"{2}\">", "http://schemas.microsoft.com/ado/2007/08/dataservices", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "http://www.w3.org/2005/Atom"));
        sb.append("<title />");
        sb.append(MessageFormat.format("<updated>{0}</updated>", Utilities.getTimestamp()));
        sb.append("<author><name /></author><id />");
        sb.append(MessageFormat.format("<content type=\"{0}\">", "application/xml"));
        sb.append("<m:properties>");
        sb.append(MessageFormat.format("<d:TableName>{0}</d:TableName>", tableName));
        sb.append("</m:properties>");
        sb.append("</content>");
        sb.append("</entry>");
        return sb.toString();
    }

    public static String tableEntityXml(String tableName, ITableStorageEntity entity) {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format("<entry xmlns:d=\"{0}\" xmlns:m=\"{1}\" xmlns=\"{2}\">", "http://schemas.microsoft.com/ado/2007/08/dataservices", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "http://www.w3.org/2005/Atom"));
        sb.append("<title />");
        sb.append(MessageFormat.format("<updated>{0}</updated>", Utilities.getTimestamp()));
        sb.append("<author><name /></author><id />");
        sb.append(AtomUtil.convertToXml(tableName, entity));
        sb.append("</entry>");
        return sb.toString();
    }

    private static String convertToXml(String tableName, ITableStorageEntity entity) {
        Field[] fields;
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format("<content type=\"{0}\">", "application/xml"));
        sb.append("<m:properties>");
        sb.append(MessageFormat.format("<d:PartitionKey>{0}</d:PartitionKey>", AtomUtil.escapeXml(entity.getPartitionKey())));
        sb.append(MessageFormat.format("<d:RowKey>{0}</d:RowKey>", AtomUtil.escapeXml(entity.getRowKey())));
        List<String> ignoreFields = Arrays.asList("rowKey", "partitionKey", "timestamp");
        Class<?> clazz = entity.getClass();
        for (Field f : fields = clazz.getDeclaredFields()) {
            String name = f.getName();
            if (ignoreFields.contains(name) || Modifier.isTransient(f.getModifiers()) || f.isSynthetic()) continue;
            sb.append(AtomUtil.convertToXml(f, entity));
        }
        List<ICloudTableColumn> properties = entity.getValues();
        if (properties != null) {
            for (ICloudTableColumn key : properties) {
                sb.append(MessageFormat.format("<d:{0}>{1}</d:{0}>", key.getName(), AtomUtil.escapeXml(key.getValue())));
            }
        }
        sb.append("<d:Timestamp m:type=\"Edm.DateTime\">" + Utilities.formatTimeStamp(entity.getTimestamp()) + "</d:Timestamp>");
        sb.append("</m:properties></content>");
        return sb.toString();
    }

    public static String escapeXml(String text) {
        String escapeXml = StringEscapeUtils.escapeXml((String)text);
        return escapeXml;
    }

    public static String unescapeXml(String text) {
        String unescapeXml = StringEscapeUtils.unescapeXml((String)text);
        return unescapeXml;
    }

    private static String convertToXml(Field f, ITableStorageEntity entity) {
        StringBuilder sb = new StringBuilder();
        try {
            f.setAccessible(true);
            Object value = f.get(entity);
            f.setAccessible(false);
            ETableColumnType type = AtomUtil.getFieldType(f);
            String name = f.getName();
            sb.append("<d:").append(name);
            if (!type.equals((Object)ETableColumnType.TYPE_STRING)) {
                sb.append(" m:type=\"").append(type.getLiteral()).append("\"");
            }
            if (value == null) {
                sb.append(" m:null=\"true\"");
            }
            sb.append(">");
            if (value != null) {
                if (type.equals((Object)ETableColumnType.TYPE_DATE_TIME)) {
                    sb.append(Utilities.formatTimeStamp((Timestamp)value));
                } else if (type.equals((Object)ETableColumnType.TYPE_BINARY)) {
                    sb.append(Base64.encode((byte[])value));
                } else if (type.equals((Object)ETableColumnType.TYPE_STRING) && !(value instanceof String) && value instanceof Serializable) {
                    try {
                        sb.append(AtomUtil.escapeXml(Utilities.convertObjectToString(value)));
                    }
                    catch (Exception e) {
                        sb.append(AtomUtil.escapeXml(String.valueOf(value)));
                    }
                } else {
                    sb.append(AtomUtil.escapeXml(String.valueOf(value)));
                }
            }
            sb.append("</d:").append(name).append(">");
        }
        catch (Exception e) {
            Logger.error("", e);
        }
        return sb.toString();
    }

    public static ETableColumnType getFieldType(Field f) {
        Class<?> c = f.getType();
        if (c == Integer.TYPE || c == Integer.class || c == Byte.TYPE || c == Byte.class) {
            return ETableColumnType.TYPE_INT;
        }
        if (c == Long.TYPE || c == Long.class) {
            return ETableColumnType.TYPE_LONG;
        }
        if (c == Float.TYPE || c == Float.class || c == Double.TYPE || c == Double.class) {
            return ETableColumnType.TYPE_DOUBLE;
        }
        if (c == Timestamp.class) {
            return ETableColumnType.TYPE_DATE_TIME;
        }
        if (c == byte[].class) {
            return ETableColumnType.TYPE_BINARY;
        }
        if (c == Boolean.TYPE || c == Boolean.class) {
            return ETableColumnType.TYPE_BOOL;
        }
        if (c == Guid.class) {
            return ETableColumnType.TYPE_GUID;
        }
        return ETableColumnType.TYPE_STRING;
    }

    public static String convertACLToXml(IContainerAccessControl control) {
        StringBuffer polocies = new StringBuffer();
        polocies.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>").append("\n");
        polocies.append("<SignedIdentifiers>");
        if (control.getSize() > 0) {
            for (int i = 0; i < control.getSize(); ++i) {
                ISignedIdentifier signedIdentifier = control.getSignedIdentifier(i);
                polocies.append("<SignedIdentifier>");
                polocies.append("<Id>").append(signedIdentifier.getId()).append("</Id>");
                if (signedIdentifier.getPolicy() != null) {
                    polocies.append("<AccessPolicy>");
                    if (signedIdentifier.getPolicy().getStart() != null && !signedIdentifier.getPolicy().getStart().equals("")) {
                        polocies.append("<Start>").append(signedIdentifier.getPolicy().getStart()).append("</Start>");
                    }
                    if (signedIdentifier.getPolicy().getExpiry() != null && !signedIdentifier.getPolicy().getExpiry().equals("")) {
                        polocies.append("<Expiry>").append(signedIdentifier.getPolicy().getExpiry()).append("</Expiry>");
                    }
                    if (signedIdentifier.getPolicy().getPermission() != 0) {
                        polocies.append("<Permission>").append(SharedAccessPermissions.toString(signedIdentifier.getPolicy().getPermission())).append("</Permission>");
                    }
                    polocies.append("</AccessPolicy>");
                }
                polocies.append("</SignedIdentifier>");
            }
        }
        polocies.append("</SignedIdentifiers>");
        return polocies.toString();
    }
}

