/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.util.ssl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.soyatec.windows.azure.util.ssl.HttpsX509KeyManager;
import org.soyatec.windows.azure.util.ssl.HttpsX509TrustManager;

public class SslUtil {
    public static final String CERT_ALIAS = "soyatec";
    public static final String KEYSTORE_PASS = "soyatec";
    public static final String KEYSTORE = ".keystore";

    public static String importCertificate(String x509Cert) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        File x509 = new File(x509Cert);
        FileInputStream fis = new FileInputStream(x509);
        BufferedInputStream bis = new BufferedInputStream(fis);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(bis);
        ks.setCertificateEntry("soyatec", cert);
        File storeFile = new File(x509.getParentFile().getAbsolutePath(), KEYSTORE);
        ks.store(new FileOutputStream(storeFile), "soyatec".toCharArray());
        return storeFile.getAbsolutePath();
    }

    public static X509Certificate getAbsolutePath(String cert) throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        FileInputStream in = new FileInputStream(cert);
        X509Certificate c = (X509Certificate)cf.generateCertificate(in);
        return c;
    }

    public static X509Certificate getCertificateFromStore(String store, String alias, String password) throws Exception {
        KeyStore ks = SslUtil.getKeyStore(new File(store).toURL(), password);
        X509Certificate c = (X509Certificate)ks.getCertificate(alias);
        return c;
    }

    public static PrivateKey getPrivateKey(String storePath, String password, String alias) throws Exception {
        KeyStore store = SslUtil.getKeyStore(new File(storePath).toURL(), password);
        return (PrivateKey)store.getKey(password, password.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyStore getKeyStore(URL url, String password) throws Exception {
        if (url == null) {
            throw new IllegalArgumentException("Keystore url may not be null");
        }
        KeyStore keystore = KeyStore.getInstance("jks");
        InputStream is = null;
        try {
            is = url.openStream();
            keystore.load(is, password != null ? password.toCharArray() : null);
            Object var5_4 = null;
            if (is == null) return keystore;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (is == null) throw throwable;
            is.close();
            throw throwable;
        }
        is.close();
        return keystore;
    }

    private static KeyManager[] createKeyManagers(KeyStore keystore, String password) throws Exception {
        if (keystore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, password != null ? password.toCharArray() : null);
        return kmfactory.getKeyManagers();
    }

    private static TrustManager[] createTrustManagers(KeyStore keystore) throws KeyStoreException, NoSuchAlgorithmException {
        if (keystore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmfactory.init(keystore);
        TrustManager[] trustmanagers = tmfactory.getTrustManagers();
        return trustmanagers;
    }

    public static SSLContext createSSLContext(String keyStoreUrl, String keyStorePassword, String trustStoreUrl, String trustStorePassword, String certAlias) throws Exception {
        KeyManager[] keymanagers = null;
        TrustManager[] trustmanagers = null;
        KeyStore keystore = SslUtil.getKeyStore(new File(keyStoreUrl).toURL(), keyStorePassword);
        PrivateKey privateKey = (PrivateKey)keystore.getKey(certAlias, keyStorePassword.toCharArray());
        X509Certificate cert = (X509Certificate)keystore.getCertificate(certAlias);
        keymanagers = SslUtil.createKeyManagers(keystore, keyStorePassword);
        for (int i = 0; i < keymanagers.length; ++i) {
            if (!(keymanagers[i] instanceof X509ExtendedKeyManager)) continue;
            keymanagers[i] = new HttpsX509KeyManager((X509ExtendedKeyManager)keymanagers[i], certAlias, privateKey, cert);
        }
        SSLContext sslcontext = SSLContext.getInstance("TLS");
        KeyStore trustStore = SslUtil.getKeyStore(new File(trustStoreUrl).toURL(), trustStorePassword);
        trustmanagers = SslUtil.createTrustManagers(trustStore);
        for (int i = 0; i < trustmanagers.length; ++i) {
            if (!(trustmanagers[i] instanceof X509TrustManager)) continue;
            trustmanagers[i] = new HttpsX509TrustManager((X509TrustManager)trustmanagers[i]);
        }
        sslcontext.init(keymanagers, trustmanagers, null);
        return sslcontext;
    }

    private static void loadWindowsCert() throws Exception {
        KeyStore ks = KeyStore.getInstance("Windows-MY");
        ks.load(null, null);
        Enumeration<String> en = ks.aliases();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            Certificate[] certs = ks.getCertificateChain(key);
            X509Certificate cert = (X509Certificate)certs[0];
            System.out.println(key + ":" + cert.getType());
        }
    }

    public static SSLSocketFactory getSSLSocketFactory(SSLContext context) {
        SSLSocketFactory factory = new SSLSocketFactory(context);
        factory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        return factory;
    }

    public static SSLSocketFactory createSSLSocketFactory(String keyStoreUrl, String keyStorePassword, String trustStoreUrl, String trustStorePassword, String certAlias) throws Exception {
        SSLContext context = SslUtil.createSSLContext(keyStoreUrl, keyStorePassword, trustStoreUrl, trustStorePassword, certAlias);
        return SslUtil.getSSLSocketFactory(context);
    }
}

