/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.soyatec.windows.azure.authenticate.Base64;
import org.soyatec.windows.azure.blob.io.BlobStream;
import org.soyatec.windows.azure.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static final String ERROR_MESSAGE = "<message (.*)>(.*)<\\/message>";
    private static final Pattern PATTERN = Pattern.compile("<message (.*)>(.*)<\\/message>");
    private static final String YYYY_MM_DD_T_HH_MM_SS_SSS_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String YYYY_MM_DD_T_HH_MM_SS_SSS_DETAIL_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS";
    private static final String EEE_DD_MMM_YYYY_HH_MM_SS_Z_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final String TIME_ZONE_GMT = "GMT";
    private static final String MIN_TIME = "0000-00-00 00:00:00.000000000";

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String emptyString() {
        return "";
    }

    public static String encode(String input) {
        try {
            input = URLEncoder.encode(input, "UTF-8");
            input = input.replaceAll("%3D", "=");
            input = input.replaceAll("%2C", ",");
            input = input.replaceAll("%2F", "/");
            input = input.replaceAll("%28", "(");
            input = input.replaceAll("%27", "'");
            input = input.replaceAll("%29", ")");
            input = input.replaceAll("%24", "\\$");
            input = input.replaceAll("\\+", "\\%20");
        }
        catch (UnsupportedEncodingException e) {
            Logger.error(e.getMessage(), e);
        }
        return input;
    }

    public static Timestamp minTime() {
        return Timestamp.valueOf(MIN_TIME);
    }

    public static boolean isValidTableName(String name) {
        if (Utilities.isNullOrEmpty(name)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^([a-z]|[A-Z]){1}([a-z]|[A-Z]|\\d){2,62}$");
        return pattern.matcher(name).matches();
    }

    public static String fixRootContainer(String url) {
        if (url.indexOf("$root") > -1) {
            int len = url.length();
            if ((url = url.replaceAll("\\$root/", "")).length() == len) {
                url = url.replaceAll("\\$root", "");
            }
        }
        return url;
    }

    public static boolean isValidContainerOrQueueName(String name) {
        if (Utilities.isNullOrEmpty(name)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^([a-z]|\\d){1}([a-z]|-|\\d){1,61}([a-z]|\\d){1}$");
        return pattern.matcher(name).matches();
    }

    public static Timestamp convertTime(String time) {
        SimpleDateFormat formatter = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 1, Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone(TIME_ZONE_GMT));
        Date date = null;
        try {
            date = formatter.parse(time);
        }
        catch (ParseException e) {
            date = new Date();
        }
        return new Timestamp(date.getTime());
    }

    public static String getUTCTime() {
        SimpleDateFormat formatter = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 1, Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone(TIME_ZONE_GMT));
        formatter.applyPattern(EEE_DD_MMM_YYYY_HH_MM_SS_Z_FORMAT);
        return formatter.format(new Date());
    }

    public static long copyStream(InputStream sourceStream, BlobStream destinationStream) throws IOException {
        int bufferSize = 65536;
        byte[] buffer = new byte[65536];
        int n = 0;
        long totalRead = 0L;
        do {
            try {
                n = sourceStream.read(buffer, 0, 65536);
            }
            catch (IOException e) {
                Logger.error(e.getMessage(), e);
                break;
            }
            if (n <= 0) continue;
            totalRead += (long)n;
            destinationStream.write(buffer, 0, n);
        } while (n > 0);
        return totalRead;
    }

    public static void copyStream(BlobStream sourceStream, BlobStream destinationStream, int length) throws IOException {
        int bufferSize = 65536;
        byte[] buffer = new byte[65536];
        int n = 0;
        int amountLeft = length;
        do {
            try {
                n = sourceStream.read(buffer, 0, Math.min(65536, amountLeft -= n));
                if (n <= 0) continue;
                destinationStream.write(buffer, 0, n);
            }
            catch (IOException e) {
                Logger.error(e.getMessage(), e);
                break;
            }
        } while (n > 0);
        Arrays.fill(buffer, (byte)0);
        while (amountLeft > 0) {
            if ((n = Math.min(65536, amountLeft -= n)) <= 0) continue;
            destinationStream.write(buffer, 0, n);
        }
    }

    public static Timestamp tryGetDateTimeFromHttpString(String stringValue) throws ParseException {
        SimpleDateFormat formatter = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 1, Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone(TIME_ZONE_GMT));
        formatter.applyPattern(EEE_DD_MMM_YYYY_HH_MM_SS_Z_FORMAT);
        Date date = formatter.parse(stringValue);
        return new Timestamp(date.getTime());
    }

    public static Timestamp tryGetDateTimeFromTableEntry(String stringValue) throws ParseException {
        SimpleDateFormat formatter = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 1, Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone(TIME_ZONE_GMT));
        Date date = null;
        try {
            formatter.applyPattern(YYYY_MM_DD_T_HH_MM_SS_SSS_FORMAT);
            date = formatter.parse(stringValue);
        }
        catch (Exception e) {
            formatter.setLenient(true);
            formatter.applyPattern(YYYY_MM_DD_T_HH_MM_SS_SSS_DETAIL_FORMAT);
            date = formatter.parse(stringValue);
        }
        return new Timestamp(date.getTime());
    }

    public static void checkStringParameter(String s, boolean canBeNullOrEmpty, String name) {
        if (Utilities.isNullOrEmpty(s) && !canBeNullOrEmpty) {
            throw new IllegalArgumentException(MessageFormat.format("The parameter {0} cannot be null or empty.", name));
        }
        if (s.length() > 32768) {
            throw new IllegalArgumentException(MessageFormat.format("The parameter {0} cannot be longer than {1} characters.", name, 32768));
        }
    }

    public static String getTimestamp() {
        return Utilities.formatTimeStamp(new Timestamp(new Date().getTime()));
    }

    public static String formatTimeStamp(Timestamp t) {
        SimpleDateFormat formatter = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 1, Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone(TIME_ZONE_GMT));
        formatter.applyPattern("yyyy-MM-dd");
        String timestamp = formatter.format(t);
        formatter.applyPattern("hh:mm:ss");
        return timestamp + "T" + formatter.format(t) + "Z";
    }

    public static Timestamp formatStringToTimeStamp(String s) {
        return Timestamp.valueOf(s.replace("T", " ").replace("Z", ""));
    }

    public static String convertObjectToString(Object object) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteStream);
        out.writeObject(object);
        out.flush();
        out.close();
        String string = Base64.encode(byteStream.toByteArray());
        byteStream.close();
        return string;
    }

    public static Object convertStringToObject(String string) throws IOException, ClassNotFoundException {
        if (string == null) {
            throw new IllegalArgumentException("Null String");
        }
        byte[] decode = Base64.decode(string);
        if (decode == null) {
            throw new IOException(MessageFormat.format("Base64 decode for {0} running error.", string));
        }
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decode));
        Object readObject = ois.readObject();
        ois.close();
        return readObject;
    }

    public static String computeMD5(String str) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(str.getBytes());
            byte[] array = m.digest();
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < array.length; ++j) {
                int b = array[j] & 0xFF;
                if (b < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String retrieveErrorMessages(String content) {
        if (Utilities.isNullOrEmpty(content)) {
            return null;
        }
        Matcher matcher = PATTERN.matcher(content);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            buf.append(matcher.group(2));
        }
        if (buf.length() == 0) {
            return null;
        }
        return buf.toString();
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String convertStreamToString(InputStream is) {
        StringBuilder sb;
        block9: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            Object var6_4 = null;
            try {
                is.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            break block9;
            {
                catch (IOException e) {
                    e.printStackTrace();
                    Object var6_5 = null;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    is.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
        return sb.toString();
    }

    public static <T> List<T> convertToList(Iterator<T> itor) {
        if (itor == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<T> list = new ArrayList<T>();
        while (itor.hasNext()) {
            list.add(itor.next());
        }
        return list;
    }
}

