/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.table.internal;

import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.dom4j.Document;
import org.dom4j.Element;
import org.soyatec.windows.azure.authenticate.Base64;
import org.soyatec.windows.azure.authenticate.SharedKeyCredentials;
import org.soyatec.windows.azure.internal.OutParameter;
import org.soyatec.windows.azure.internal.ResourceUriComponents;
import org.soyatec.windows.azure.internal.constants.HttpWebResponse;
import org.soyatec.windows.azure.table.ICloudTable;
import org.soyatec.windows.azure.table.TableStorage;
import org.soyatec.windows.azure.table.internal.CloudTableRest;
import org.soyatec.windows.azure.table.internal.ListTableResult;
import org.soyatec.windows.azure.util.HttpUtilities;
import org.soyatec.windows.azure.util.NameValueCollection;
import org.soyatec.windows.azure.util.Utilities;
import org.soyatec.windows.azure.util.xml.XPathQueryHelper;
import org.soyatec.windows.azure.util.xml.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableStorageRest
extends TableStorage {
    public TableStorageRest(URI baseUri, boolean usePathStyleUris, String accountName, String base64Key) {
        super(baseUri, usePathStyleUris, accountName, base64Key);
        byte[] key = null;
        this.setBase64Key(base64Key);
        if (base64Key != null) {
            key = Base64.decode(this.getBase64Key());
        }
        this.setCredentials(new SharedKeyCredentials(accountName, key));
    }

    @Override
    public List<String> listTables() {
        ListTableResult all = new ListTableResult(new ArrayList<String>(), Utilities.emptyString());
        String marker = Utilities.emptyString();
        do {
            ListTableResult partResult = this.listTablesImpl(marker);
            marker = partResult.getNextTableName();
            all.getNames().addAll(partResult.getNames());
            all.setNextTableName(marker);
        } while (marker != null);
        return all.getNames();
    }

    private ListTableResult listTablesImpl(final String nextTableName) {
        final OutParameter result = new OutParameter();
        this.getRetryPolicy().execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                NameValueCollection queryParams = new NameValueCollection();
                if (!Utilities.isNullOrEmpty(nextTableName)) {
                    queryParams.put("NextTableName", nextTableName);
                }
                ResourceUriComponents uriComponents = new ResourceUriComponents(TableStorageRest.this.getAccountName(), "/Tables", null);
                URI uri = HttpUtilities.createRequestUri(TableStorageRest.this.getBaseUri(), TableStorageRest.this.isUsePathStyleUris(), TableStorageRest.this.getAccountName(), "/Tables", null, TableStorageRest.this.getTimeout(), queryParams, uriComponents);
                HttpUriRequest request = HttpUtilities.createHttpRequest(uri, "GET");
                TableStorageRest.this.getCredentials().signRequestForSharedKeyLite((HttpRequest)request, uriComponents);
                HttpWebResponse response = HttpUtilities.getResponse((HttpRequest)request);
                if (response.getStatusCode() == 200) {
                    ListTableResult tablesResult = TableStorageRest.this.getTableResultFromResponse(response.getStream());
                    result.setValue(tablesResult);
                    String nextTableNameHeader = response.getHeader("x-ms-continuation-NextTableName");
                    if (!Utilities.isNullOrEmpty(nextTableNameHeader)) {
                        tablesResult.setNextTableName(nextTableNameHeader);
                    }
                } else {
                    HttpUtilities.processUnexpectedStatusCode(response);
                }
                return null;
            }
        });
        return (ListTableResult)result.getValue();
    }

    private ListTableResult getTableResultFromResponse(InputStream stream) {
        ArrayList<String> names = new ArrayList<String>();
        String nextMarker = null;
        Document document = XmlUtil.load(stream, "The result of a ListTable operation could not be parsed");
        List xmlNodes = XPathQueryHelper.parseEntryFromFeed(document);
        for (Element tableEntryNode : xmlNodes) {
            String queueName = XPathQueryHelper.loadTableNameFromTableEntry(tableEntryNode);
            names.add(queueName);
        }
        Element nextMarkerNode = (Element)document.selectSingleNode(XPathQueryHelper.NextMarkerQuery);
        if (nextMarkerNode != null && nextMarkerNode.hasContent()) {
            nextMarker = nextMarkerNode.getStringValue();
        }
        return new ListTableResult(names, nextMarker);
    }

    @Override
    public ICloudTable getWindowsAzureTable(String tableName) {
        Utilities.checkStringParameter(tableName, false, "tableName");
        if (!Utilities.isValidTableName(tableName)) {
            throw new IllegalArgumentException(MessageFormat.format("The specified table name \"{0}\" is not valid!\nPlease choose a name that conforms to the naming conventions for tables!\nSee <a>http://msdn.microsoft.com/en-us/library/dd179338.aspx</a> for more information.", tableName));
        }
        return new CloudTableRest(this.getBaseUri(), this.isUsePathStyleUris(), this.getAccountName(), tableName, this.getBase64Key(), this.getTimeout(), this.getRetryPolicy());
    }
}

