/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.table.internal;

import java.util.ArrayList;
import java.util.List;

public class CloudTableQuery {
    private static final String AND = "and";
    private static final String OR = "or";
    private static final String NOT = "not";
    private int top = -1;
    private List<String> orderFields = new ArrayList<String>();
    private List<String> conditions = new ArrayList<String>();
    private List<CloudTableQuery> subQueries = new ArrayList<CloudTableQuery>();
    private String connector = "and";

    public static CloudTableQuery select() {
        return new CloudTableQuery();
    }

    public static CloudTableQuery $() {
        return new CloudTableQuery();
    }

    public CloudTableQuery orderAsc(String field) {
        this.orderFields.add(field + " asc");
        return this;
    }

    public CloudTableQuery orderDesc(String field) {
        this.orderFields.add(field + " desc");
        return this;
    }

    public CloudTableQuery partitionKeyEq(String value) {
        this.conditions.add("PartitionKey eq " + this.quote(value));
        return this;
    }

    public CloudTableQuery where(String condition) {
        this.conditions.add(condition);
        return this;
    }

    public CloudTableQuery rowKeyEq(String value) {
        this.conditions.add("RowKey eq " + this.quote(value));
        return this;
    }

    public CloudTableQuery eq(String name, Object value) {
        this.conditions.add(name + " eq " + this.quote(value));
        return this;
    }

    public CloudTableQuery gt(String name, Object value) {
        this.conditions.add(name + " gt " + this.quote(value));
        return this;
    }

    public CloudTableQuery lt(String name, Object value) {
        this.conditions.add(name + " lt " + this.quote(value));
        return this;
    }

    public CloudTableQuery ge(String name, Object value) {
        this.conditions.add(name + " ge " + this.quote(value));
        return this;
    }

    public CloudTableQuery le(String name, Object value) {
        this.conditions.add(name + " le " + this.quote(value));
        return this;
    }

    public CloudTableQuery ne(String name, Object value) {
        this.conditions.add(name + " ne " + this.quote(value));
        return this;
    }

    public CloudTableQuery top(int t) {
        this.top = t;
        return this;
    }

    private String quote(Object value) {
        if (value instanceof String) {
            return "'" + this.escapeQueryValue((String)value) + "'";
        }
        return value.toString();
    }

    private String escapeQueryValue(String value) {
        return value.replaceAll("'", "''");
    }

    public static CloudTableQuery and(CloudTableQuery q, CloudTableQuery query) {
        CloudTableQuery parent = CloudTableQuery.select();
        parent.connector = AND;
        parent.addQuery(q);
        parent.addQuery(query);
        return parent;
    }

    public static CloudTableQuery or(CloudTableQuery q, CloudTableQuery query) {
        CloudTableQuery parent = CloudTableQuery.select();
        parent.connector = OR;
        parent.addQuery(q);
        parent.addQuery(query);
        return parent;
    }

    public static CloudTableQuery not(CloudTableQuery query) {
        CloudTableQuery parent = CloudTableQuery.select();
        parent.connector = NOT;
        parent.addQuery(query);
        return parent;
    }

    public String toAzureQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFilter());
        String orderBy = this.getOrderBy();
        if (sb.length() > 0 && orderBy.length() > 0) {
            sb.append("&");
        }
        sb.append(orderBy);
        if (this.top != -1) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("$top=" + this.top);
        }
        return sb.toString();
    }

    private String getFilter() {
        int i;
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.subQueries.size(); ++i) {
            String query;
            if (!first) {
                sb.append(" " + this.connector + " ");
            }
            if ((query = this.subQueries.get(i).toAzureQuery()).startsWith("$filter")) {
                query = query.substring("$filter".length() + 1);
            }
            sb.append("(").append(query).append(")");
            first = false;
        }
        for (i = 0; i < this.conditions.size(); ++i) {
            if (!first) {
                sb.append(" " + this.connector + " ");
            }
            sb.append("(").append(this.conditions.get(i)).append(")");
            first = false;
        }
        String filter = sb.toString();
        if (filter.length() > 0) {
            filter = "$filter=" + filter;
        }
        return filter;
    }

    private String getOrderBy() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.orderFields.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.orderFields.get(i));
        }
        String orderBy = sb.toString();
        if (orderBy.length() > 0) {
            orderBy = "$orderby=" + orderBy;
        }
        return orderBy;
    }

    private void addQuery(CloudTableQuery query) {
        this.subQueries.add(query);
        this.orderFields.addAll(query.orderFields);
        query.orderFields.clear();
        if (this.top == -1) {
            this.top = query.top;
        }
        query.top = -1;
    }
}

