/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.table;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.soyatec.windows.azure.table.ICloudTableColumn;
import org.soyatec.windows.azure.table.ITableStorageEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableStorageEntity
implements ITableStorageEntity {
    protected Timestamp timestamp = new Timestamp(new Date().getTime());
    protected String partitionKey;
    protected String rowKey;
    protected String eTag;
    protected transient List<ICloudTableColumn> values;

    public AbstractTableStorageEntity(String partitionKey, String rowKey) {
        this.partitionKey = partitionKey;
        this.rowKey = rowKey;
    }

    @Override
    public List<ICloudTableColumn> getValues() {
        return this.values;
    }

    @Override
    public void setValues(List<ICloudTableColumn> values) {
        this.values = values;
    }

    @Override
    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getPartitionKey() {
        return this.partitionKey;
    }

    @Override
    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    @Override
    public String getRowKey() {
        return this.rowKey;
    }

    @Override
    public void setRowKey(String rowKey) {
        this.rowKey = rowKey;
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    public void setETag(String tag) {
        this.eTag = tag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eTag == null ? 0 : this.eTag.hashCode());
        result = 31 * result + (this.partitionKey == null ? 0 : this.partitionKey.hashCode());
        result = 31 * result + (this.rowKey == null ? 0 : this.rowKey.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ITableStorageEntity)) {
            return false;
        }
        ITableStorageEntity other = (ITableStorageEntity)obj;
        if (this.eTag == null ? other.getETag() != null : !this.eTag.equals(other.getETag())) {
            return false;
        }
        if (this.partitionKey == null ? other.getPartitionKey() != null : !this.partitionKey.equals(other.getPartitionKey())) {
            return false;
        }
        if (this.rowKey == null ? other.getRowKey() != null : !this.rowKey.equals(other.getRowKey())) {
            return false;
        }
        return !(this.timestamp == null ? other.getTimestamp() != null : !this.timestamp.equals(other.getTimestamp()));
    }

    @Override
    public boolean isSameEntity(ITableStorageEntity entity) {
        if (entity == null) {
            return false;
        }
        if (this.equals(entity)) {
            return true;
        }
        if (this.getPartitionKey() == null || this.getRowKey() == null) {
            return false;
        }
        if (entity.getPartitionKey() == null || entity.getRowKey() == null) {
            return false;
        }
        return this.getPartitionKey().equals(entity.getPartitionKey()) && this.getRowKey().equals(entity.getRowKey());
    }
}

