/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.queue.internal;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.http.HttpRequest;
import org.dom4j.Document;
import org.dom4j.Element;
import org.soyatec.windows.azure.authenticate.Base64;
import org.soyatec.windows.azure.authenticate.SharedKeyCredentials;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.internal.OutParameter;
import org.soyatec.windows.azure.internal.ResourceUriComponents;
import org.soyatec.windows.azure.internal.constants.HttpWebResponse;
import org.soyatec.windows.azure.queue.QueueStorage;
import org.soyatec.windows.azure.queue.internal.CloudQueue;
import org.soyatec.windows.azure.queue.internal.CloudQueueRest;
import org.soyatec.windows.azure.queue.internal.ListQueueResult;
import org.soyatec.windows.azure.util.HttpUtilities;
import org.soyatec.windows.azure.util.NameValueCollection;
import org.soyatec.windows.azure.util.Utilities;
import org.soyatec.windows.azure.util.xml.XPathQueryHelper;
import org.soyatec.windows.azure.util.xml.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueStorageRest
extends QueueStorage {
    public QueueStorageRest(URI baseUri, boolean usePathStyleUris, String accountName, String base64Key) {
        super(baseUri, usePathStyleUris, accountName, base64Key);
        byte[] key = null;
        this.base64Key = base64Key;
        if (base64Key != null) {
            key = Base64.decode(this.getBase64Key());
        }
        this.setCredentials(new SharedKeyCredentials(accountName, key));
    }

    @Override
    public List<String> listQueues(String prefix) {
        ListQueueResult all = new ListQueueResult(new ArrayList<String>(), new ArrayList<String>(), Utilities.emptyString());
        String marker = Utilities.emptyString();
        int maxResults = 50;
        do {
            ListQueueResult partResult = this.listQueueImpl(prefix, marker, 50);
            marker = partResult.getNextMarker();
            all.getQueueNames().addAll(partResult.getQueueNames());
            all.getUrls().addAll(partResult.getUrls());
            all.setNextMarker(marker);
        } while (marker != null);
        return all.getQueueNames();
    }

    private ListQueueResult listQueueImpl(final String prefix, final String marker, int maxResults) throws StorageException {
        final OutParameter result = new OutParameter();
        this.getRetryPolicy().execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                NameValueCollection col = new NameValueCollection();
                col.put("comp", "list");
                if (!Utilities.isNullOrEmpty(prefix)) {
                    col.put("prefix", prefix);
                }
                if (!Utilities.isNullOrEmpty(marker)) {
                    col.put("marker", marker);
                }
                ResourceUriComponents uriComponents = new ResourceUriComponents(QueueStorageRest.this.getAccountName(), null, null);
                URI uri = HttpUtilities.createRequestUri(QueueStorageRest.this.getBaseUri(), QueueStorageRest.this.isUsePathStyleUris(), QueueStorageRest.this.getAccountName(), null, null, QueueStorageRest.this.getTimeout(), col, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "GET", QueueStorageRest.this.getTimeout());
                QueueStorageRest.this.getCredentials().signRequest(request, uriComponents);
                HttpWebResponse response = HttpUtilities.getResponse(request);
                if (response.getStatusCode() == 200) {
                    result.setValue(QueueStorageRest.this.getQueuesResultFromResponse(response.getStream()));
                } else {
                    HttpUtilities.processUnexpectedStatusCode(response);
                }
                return null;
            }
        });
        return (ListQueueResult)result.getValue();
    }

    private ListQueueResult getQueuesResultFromResponse(InputStream stream) throws StorageException {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> urls = new ArrayList<String>();
        String nextMarker = null;
        Document document = XmlUtil.load(stream, "The result of a ListQueue operation could not be parsed");
        List xmlNodes = document.selectNodes(XPathQueryHelper.QueueListQuery);
        for (Element queueNameNode : xmlNodes) {
            String queueName = XPathQueryHelper.loadSingleChildStringValue(queueNameNode, "QueueName", true);
            names.add(queueName);
            String url = XPathQueryHelper.loadSingleChildStringValue(queueNameNode, "Url", true);
            urls.add(url);
        }
        Element nextMarkerNode = (Element)document.selectSingleNode(XPathQueryHelper.NextMarkerQuery);
        if (nextMarkerNode != null && nextMarkerNode.hasContent()) {
            nextMarker = nextMarkerNode.getStringValue();
        }
        assert (names.size() == urls.size());
        return new ListQueueResult(names, urls, nextMarker);
    }

    @Override
    public CloudQueue getQueue(String queueName) throws StorageException {
        if (Utilities.isNullOrEmpty(queueName)) {
            throw new IllegalArgumentException("Queue name cannot be null or empty!");
        }
        return new CloudQueueRest(queueName, this.getAccountInfo(), this.getTimeout(), this.getRetryPolicy());
    }
}

