/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.queue.internal;

import java.util.ArrayList;
import java.util.List;
import org.soyatec.windows.azure.queue.IMessageReceivedListener;
import org.soyatec.windows.azure.queue.MessageReceivedEvent;

public class MessageReceivedListenerSupport {
    private List<IMessageReceivedListener> handlerList = new ArrayList<IMessageReceivedListener>();
    private Object source;

    public MessageReceivedListenerSupport() {
    }

    public MessageReceivedListenerSupport(Object source) {
        this.source = source;
    }

    public synchronized void addListener(IMessageReceivedListener handler) {
        if (handler == null) {
            return;
        }
        if (!this.handlerList.contains(handler)) {
            this.handlerList.add(handler);
        }
    }

    public synchronized void removeListener(IMessageReceivedListener handler) {
        if (handler == null) {
            return;
        }
        if (this.handlerList.contains(handler)) {
            this.handlerList.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAll(MessageReceivedEvent event) {
        if (event == null) {
            return;
        }
        if (this.handlerList.isEmpty()) {
            return;
        }
        List<IMessageReceivedListener> list = this.handlerList;
        synchronized (list) {
            for (IMessageReceivedListener type : this.handlerList) {
                if (type == null) continue;
                if (event.getSource() == null && this.getSource() != null) {
                    type.handle(new MessageReceivedEvent(this.getSource(), event.getMessage()));
                    continue;
                }
                type.handle(event);
            }
        }
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }
}

