/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.queue.internal;

import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import org.soyatec.windows.azure.authenticate.StorageAccountInfo;
import org.soyatec.windows.azure.blob.IRetryPolicy;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.queue.ICloudQueue;
import org.soyatec.windows.azure.queue.IMessage;
import org.soyatec.windows.azure.queue.IMessageReceivedListener;
import org.soyatec.windows.azure.queue.IQueueProperties;
import org.soyatec.windows.azure.queue.internal.Message;
import org.soyatec.windows.azure.queue.internal.MessageReceivedListenerSupport;
import org.soyatec.windows.azure.util.TimeSpan;
import org.soyatec.windows.azure.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CloudQueue
implements ICloudQueue {
    protected transient MessageReceivedListenerSupport changeSupport = new MessageReceivedListenerSupport();
    private String name;
    private StorageAccountInfo account;
    private boolean usePathStyleUris = Boolean.TRUE;
    private URI queueUri;
    private IRetryPolicy retryPolicy;
    private TimeSpan timeout;

    protected CloudQueue() {
    }

    protected CloudQueue(String name, StorageAccountInfo account) {
        if (Utilities.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("Queue name cannot be null or empty!");
        }
        if (account == null) {
            throw new IllegalArgumentException("Account information is not given!");
        }
        if (!Utilities.isValidContainerOrQueueName(name)) {
            throw new IllegalArgumentException(MessageFormat.format("The specified queue name \"{0}\" is not valid!\nPlease choose a name that conforms to the naming conventions for queues!\nSee <a>http://msdn.microsoft.com/en-us/library/dd179349.aspx</a> for more information.", name));
        }
        this.name = name;
        this.account = account;
    }

    @Override
    public abstract boolean createQueue() throws StorageException;

    @Override
    public boolean isQueueExist() {
        try {
            this.getProperties();
            return true;
        }
        catch (StorageException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public abstract boolean deleteQueue() throws StorageException;

    @Override
    public abstract boolean setProperties(IQueueProperties var1) throws StorageException;

    @Override
    public abstract IQueueProperties getProperties() throws StorageException;

    @Override
    public abstract int getApproximateCount() throws StorageException;

    @Override
    public abstract boolean putMessage(IMessage var1) throws StorageException;

    @Override
    public abstract boolean putMessage(IMessage var1, int var2) throws StorageException;

    @Override
    public abstract IMessage getMessage() throws StorageException;

    @Override
    public abstract IMessage getMessage(int var1) throws StorageException;

    @Override
    public abstract List<Message> getMessages(int var1) throws StorageException;

    @Override
    public abstract List<Message> getMessages(int var1, int var2) throws StorageException;

    @Override
    public abstract IMessage peekMessage() throws StorageException;

    @Override
    public abstract List<Message> peekMessages(int var1) throws StorageException;

    @Override
    public abstract boolean deleteMessage(IMessage var1) throws StorageException;

    @Override
    public abstract boolean clear() throws StorageException;

    @Override
    public abstract boolean startReceiving();

    @Override
    public abstract void stopReceiving();

    @Override
    public void addMessageReceivedListener(IMessageReceivedListener listener) {
        this.changeSupport.addListener(listener);
    }

    @Override
    public void removeMessageReceivedListener(IMessageReceivedListener listener) {
        this.changeSupport.removeListener(listener);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public StorageAccountInfo getAccount() {
        return this.account;
    }

    @Override
    public boolean isUsePathStyleUris() {
        return this.usePathStyleUris;
    }

    @Override
    public URI getQueueUri() {
        return this.queueUri;
    }

    @Override
    public void setQueueUri(URI uri) {
        this.queueUri = uri;
    }

    @Override
    public IRetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Override
    public void setRetryPolicy(IRetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @Override
    public TimeSpan getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(TimeSpan timeout) {
        this.timeout = timeout;
    }

    @Override
    public abstract int getPollInterval();

    @Override
    public abstract void setPollInterval(int var1);

    @Override
    public abstract String getLastStatus();
}

