/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.queue;

import java.net.URI;
import java.util.List;
import org.soyatec.windows.azure.authenticate.StorageAccountInfo;
import org.soyatec.windows.azure.blob.IRetryPolicy;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.queue.IMessage;
import org.soyatec.windows.azure.queue.IMessageReceivedListener;
import org.soyatec.windows.azure.queue.IQueueProperties;
import org.soyatec.windows.azure.queue.internal.Message;
import org.soyatec.windows.azure.util.TimeSpan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ICloudQueue {
    public static final int DEFAULT_POLL_INTERVAL = 5000;

    public boolean createQueue() throws StorageException;

    public boolean isQueueExist();

    public boolean deleteQueue() throws StorageException;

    public boolean setProperties(IQueueProperties var1) throws StorageException;

    public IQueueProperties getProperties() throws StorageException;

    public int getApproximateCount() throws StorageException;

    public boolean putMessage(IMessage var1) throws StorageException;

    public boolean putMessage(IMessage var1, int var2) throws StorageException;

    public IMessage getMessage() throws StorageException;

    public IMessage getMessage(int var1) throws StorageException;

    public List<Message> getMessages(int var1) throws StorageException;

    public List<Message> getMessages(int var1, int var2) throws StorageException;

    public IMessage peekMessage() throws StorageException;

    public List<Message> peekMessages(int var1) throws StorageException;

    public boolean deleteMessage(IMessage var1) throws StorageException;

    public boolean clear() throws StorageException;

    public boolean startReceiving();

    public void stopReceiving();

    public void addMessageReceivedListener(IMessageReceivedListener var1);

    public void removeMessageReceivedListener(IMessageReceivedListener var1);

    public String getName();

    public StorageAccountInfo getAccount();

    public boolean isUsePathStyleUris();

    public URI getQueueUri();

    public void setQueueUri(URI var1);

    public IRetryPolicy getRetryPolicy();

    public void setRetryPolicy(IRetryPolicy var1);

    public TimeSpan getTimeout();

    public void setTimeout(TimeSpan var1);

    public int getPollInterval();

    public void setPollInterval(int var1);

    public String getLastStatus();
}

