/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.management;

import org.soyatec.windows.azure.authenticate.Base64;
import org.soyatec.windows.azure.management.Configuration;
import org.soyatec.windows.azure.management.UpgradeType;

public class UpgradeConfiguration
extends Configuration {
    private UpgradeType mode;
    private String upgradeRole;
    private String deploymentLabel;

    public UpgradeConfiguration() {
    }

    public UpgradeConfiguration(String pkgUrl, String configurefileUrl, UpgradeType mode, String upgradeRole, String label) {
        this.packageBlobUrl = pkgUrl;
        this.configurationFileUrl = configurefileUrl;
        this.mode = mode;
        this.upgradeRole = upgradeRole;
        this.deploymentLabel = label;
    }

    public void validate() {
        if (this.isEmpty(this.deploymentLabel)) {
            throw new IllegalStateException("DeploymentLabel is required!");
        }
        if (this.isEmpty(this.packageBlobUrl)) {
            throw new IllegalStateException("Package blob url is required!");
        }
        if (this.isEmpty(this.configurationFileUrl)) {
            throw new IllegalStateException("Configuration file is required!");
        }
        if (this.isEmpty(this.upgradeRole)) {
            throw new IllegalStateException("UpgradeRole is required!");
        }
        this.readConfigurationContent();
    }

    public String getDeploymentLabel() {
        return this.deploymentLabel;
    }

    public void setDeploymentLabel(String label) {
        this.deploymentLabel = label;
    }

    public String getBase64Label() {
        return Base64.encode(this.getDeploymentLabel().getBytes());
    }

    public UpgradeType getMode() {
        return this.mode;
    }

    public void setMode(UpgradeType mode) {
        this.mode = mode;
    }

    public String getUpgradeRole() {
        return this.upgradeRole;
    }

    public void setUpgradeRole(String upgradeRole) {
        this.upgradeRole = upgradeRole;
    }
}

