/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.management;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.dom4j.Document;
import org.dom4j.Element;
import org.soyatec.windows.azure.authenticate.Base64;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.internal.constants.HttpWebResponse;
import org.soyatec.windows.azure.management.AffinityGroup;
import org.soyatec.windows.azure.management.AffinityGroupProperties;
import org.soyatec.windows.azure.management.AsyncResultCallback;
import org.soyatec.windows.azure.management.Certificate;
import org.soyatec.windows.azure.management.CertificateFormat;
import org.soyatec.windows.azure.management.Deployment;
import org.soyatec.windows.azure.management.DeploymentConfiguration;
import org.soyatec.windows.azure.management.DeploymentSlotType;
import org.soyatec.windows.azure.management.HostedService;
import org.soyatec.windows.azure.management.HostedServiceProperties;
import org.soyatec.windows.azure.management.KeyType;
import org.soyatec.windows.azure.management.OperatingSystem;
import org.soyatec.windows.azure.management.OperationState;
import org.soyatec.windows.azure.management.OperationStatus;
import org.soyatec.windows.azure.management.ServiceManagement;
import org.soyatec.windows.azure.management.StorageAccount;
import org.soyatec.windows.azure.management.StorageAccountKey;
import org.soyatec.windows.azure.management.StorageAccountProperties;
import org.soyatec.windows.azure.management.UpdateStatus;
import org.soyatec.windows.azure.management.UpgradeConfiguration;
import org.soyatec.windows.azure.util.HttpUtilities;
import org.soyatec.windows.azure.util.Utilities;
import org.soyatec.windows.azure.util.xml.XPathQueryHelper;
import org.soyatec.windows.azure.util.xml.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagementRest
extends ServiceManagement {
    private static final String APPLICATION_XML = "application/xml";
    private static final String MEIDA_TYPE_TEXT_XML = "text/xml";
    private static final String KEYS_ACTION_REGENERATE = "/keys?action=regenerate";
    private static final String SERVICE_KEYS = "/keys";
    private static final String SERVICES_AFFINITYGROUPS = "/affinitygroups";
    private static final String SERVICES_HOSTEDSERVICES = "/services/hostedservices";
    private static final String SERVICES_STORAGESERVICE = "/services/storageservices";
    private static final String DEPLOYMENT_SLOTS = "/deploymentslots";
    private static final String DEPLOYMENTS = "/deployments";
    private static final String CERTIFICATES = "/certificates";
    private static final String OPERATIONS = "/operations";
    private static final String OPERATING_SYSTEMS = "/operatingsystems";
    private static final String CREATE_DEPLOYMENT_BODY = "<?xml version=\"1.0\"?><CreateDeployment xmlns=\"http://schemas.microsoft.com/windowsazure\"><Name>{0}</Name><PackageUrl>{1}</PackageUrl><Label>{3}</Label><Configuration>{2}</Configuration></CreateDeployment>";

    public ServiceManagementRest(String subscriptionId, String keyStoreFile, String keyStorePassword, String trustStoreFile, String trustStorePassword, String certificateAlias) throws Exception {
        super(subscriptionId, keyStoreFile, keyStorePassword, trustStoreFile, trustStorePassword, certificateAlias);
    }

    @Override
    public List<HostedService> listHostedServices() {
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_HOSTEDSERVICES), "GET");
        try {
            HttpWebResponse response = HttpUtilities.getSSLReponse(request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                return XPathQueryHelper.parseHostServiceResponse(response.getStream());
            }
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    @Override
    public Deployment getDeployment(String serviceName, DeploymentSlotType type) {
        HttpRequest request = this.createHttpRequest("GET", serviceName, type, "");
        return this.getDeployment(request);
    }

    @Override
    public Deployment getDeployment(String serviceName, String deploymentName) {
        HttpRequest request = this.createHttpRequest("GET", serviceName, deploymentName, "");
        return this.getDeployment(request);
    }

    private Deployment getDeployment(HttpRequest request) {
        try {
            HttpWebResponse response = HttpUtilities.getSSLReponse(request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                return XPathQueryHelper.parseDeploymentResponse(response.getStream());
            }
            if (response.getStatusCode() == 404) {
                return null;
            }
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    @Override
    public String updateDeplymentStatus(String serviceName, DeploymentSlotType type, UpdateStatus status, AsyncResultCallback callback) {
        HttpRequest request = this.createHttpRequest("POST", serviceName, type, "/?comp=status");
        return this.updateDeplymentStatus(request, status, callback);
    }

    private HttpRequest createHttpRequest(String method, String serviceName, DeploymentSlotType type, String params) {
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_HOSTEDSERVICES + "/" + serviceName + DEPLOYMENT_SLOTS + "/" + type.getLiteral().toLowerCase() + params), method);
        return request;
    }

    private HttpRequest createHttpRequest(String method, String serviceName, String deploymentName, String params) {
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_HOSTEDSERVICES + "/" + serviceName + DEPLOYMENTS + "/" + deploymentName + params), method);
        return request;
    }

    @Override
    public String updateDeplymentStatus(String serviceName, String deploymentName, UpdateStatus status, AsyncResultCallback callback) {
        HttpRequest request = this.createHttpRequest("POST", serviceName, deploymentName, "/?comp=status");
        return this.updateDeplymentStatus(request, status, callback);
    }

    private String changeDeploymentConfiguration(HttpRequest request, String configurationFileUrl, AsyncResultCallback callback) {
        String template = "<ChangeConfiguration xmlns=\"http://schemas.microsoft.com/windowsazure\"><Configuration>{0}</Configuration></ChangeConfiguration>";
        String configurationFile = this.readBase64(configurationFileUrl);
        System.out.println(Utilities.encode(configurationFile));
        request.setHeader("Content-Type", APPLICATION_XML);
        return this.sendAsyncPostRequest(request, callback, template, Utilities.encode(configurationFile));
    }

    private String updateDeplymentStatus(HttpRequest request, UpdateStatus status, AsyncResultCallback callback) {
        String template = "<UpdateDeploymentStatus xmlns=\"http://schemas.microsoft.com/windowsazure\"><Status>{0}</Status></UpdateDeploymentStatus>";
        request.setHeader("Content-Type", APPLICATION_XML);
        return this.sendAsyncPostRequest(request, callback, template, status.getLiteral());
    }

    @Override
    public String swapDeployment(String serviceName, String productName, String sourceName, AsyncResultCallback callback) {
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_HOSTEDSERVICES + "/" + serviceName), "POST");
        String template = "<Swap xmlns=\"http://schemas.microsoft.com/windowsazure\"><Production>{0}</Production><SourceDeployment>{1}</SourceDeployment></Swap>";
        request.setHeader("Content-Type", APPLICATION_XML);
        return this.sendAsyncPostRequest(request, callback, template, productName, sourceName);
    }

    private String sendAsyncPostRequest(HttpRequest request, AsyncResultCallback callback, String template, Object ... arugments) {
        String body = MessageFormat.format(template, arugments);
        ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity(body.getBytes()));
        return this.sendAsynchronousRequest(request, callback);
    }

    @Override
    public String walkUpgradeDomain(String serviceName, DeploymentSlotType type, String domainId, AsyncResultCallback callback) {
        HttpRequest request = this.createHttpRequest("POST", serviceName, type, "/action=walkupgradedomain");
        return this.walkUpgradeDomain(request, domainId, callback);
    }

    @Override
    public String walkUpgradeDomain(String serviceName, String deploymentName, String domainId, AsyncResultCallback callback) {
        HttpRequest request = this.createHttpRequest("POST", serviceName, deploymentName, "/action=walkupgradedomain");
        return this.walkUpgradeDomain(request, domainId, callback);
    }

    private String walkUpgradeDomain(HttpRequest request, String domainId, AsyncResultCallback callback) {
        String template = "<WalkUpgradeDomain xmlns=\"http://schemas.microsoft.com/windowsazure\"><UpgradeDomain>{0}</UpgradeDomain></WalkUpgradeDomain>";
        request.setHeader("Content-Type", APPLICATION_XML);
        return this.sendAsyncPostRequest(request, callback, template, domainId);
    }

    @Override
    public String changeDeploymentConfiguration(String serviceName, DeploymentSlotType type, String configurationFileUrl, AsyncResultCallback callback) {
        HttpRequest request = this.createHttpRequest("POST", serviceName, type, "/?comp=config");
        return this.changeDeploymentConfiguration(request, configurationFileUrl, callback);
    }

    @Override
    public String changeDeploymentConfiguration(String serviceName, String deploymentName, String configurationFileUrl, AsyncResultCallback callback) {
        HttpRequest request = this.createHttpRequest("POST", serviceName, deploymentName, "/?comp=config");
        return this.changeDeploymentConfiguration(request, configurationFileUrl, callback);
    }

    private String readBase64(String configurationFileUrl) {
        File file = new File(configurationFileUrl);
        if (file.exists() && file.isFile() && file.canRead()) {
            try {
                byte[] bytes = Utilities.getBytesFromFile(file);
                String content = new String(bytes);
                content = content.replaceAll("\r\n", "");
                return Base64.encode(content.getBytes("utf-8"));
            }
            catch (IOException e) {
                throw new IllegalStateException("Configuration file is invalid");
            }
        }
        throw new IllegalStateException("Configuration file is invalid");
    }

    @Override
    public String upgradeDeployment(String serviceName, DeploymentSlotType type, UpgradeConfiguration configuration, AsyncResultCallback callback) {
        HttpRequest request = this.createHttpRequest("POST", serviceName, type, "/action=upgrade");
        return this.upgradeDeployment(request, configuration, callback);
    }

    @Override
    public String upgradeDeployment(String serviceName, String deploymentName, UpgradeConfiguration configuration, AsyncResultCallback callback) {
        HttpRequest request = this.createHttpRequest("POST", serviceName, deploymentName, "/action=upgrade");
        return this.upgradeDeployment(request, configuration, callback);
    }

    private String upgradeDeployment(HttpRequest request, UpgradeConfiguration configuration, AsyncResultCallback callback) {
        configuration.validate();
        StringBuilder buf = new StringBuilder();
        buf.append("<UpgradeDeployment xmlns=\"http://schemas.microsoft.com/windowsazure\">");
        buf.append("<Mode>" + configuration.getMode().getLiteral() + "</Mode>");
        buf.append("<PackageUrl>" + configuration.getPackageBlobUrl() + "</PackageUrl>");
        buf.append("<RoleToUpgrade>" + configuration.getUpgradeRole() + "</RoleToUpgrade>");
        buf.append("<Configuration>" + this.readBase64(configuration.getConfigurationFileUrl()) + "</Configuration>");
        buf.append("<DeploymentLabel>" + configuration.getBase64Label() + "</DeploymentLabel>");
        buf.append("</UpgradeDeployment>");
        request.setHeader("Content-Type", APPLICATION_XML);
        ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity(buf.toString().getBytes()));
        return this.sendAsynchronousRequest(request, callback);
    }

    @Override
    public String deleteDeployment(String serviceName, DeploymentSlotType type, AsyncResultCallback callback) {
        HttpRequest request = this.createHttpRequest("DELETE", serviceName, type, "");
        return this.sendAsynchronousRequest(request, callback);
    }

    @Override
    public String deleteDeployment(String serviceName, String deploymentName, AsyncResultCallback callback) {
        HttpRequest request = this.createHttpRequest("DELETE", serviceName, deploymentName, "");
        return this.sendAsynchronousRequest(request, callback);
    }

    private String sendAsynchronousRequest(HttpRequest request, AsyncResultCallback callback) {
        try {
            HttpWebResponse response = HttpUtilities.getSSLReponse(request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                String requestId = this.getHeaderValueFromResponse(response, "x-ms-request-id");
                if (callback != null) {
                    this.observeOperationStatus(requestId, callback, this.isBlocking());
                }
                return requestId;
            }
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    private String getHeaderValueFromResponse(HttpWebResponse response, String headerName) {
        return response.getHeader(headerName);
    }

    @Override
    public HostedServiceProperties getHostedServiceProperties(String serviceName, boolean embedDetail) {
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_HOSTEDSERVICES + "/" + serviceName + "?embed-detail=" + embedDetail), "GET");
        try {
            HttpWebResponse response = HttpUtilities.getSSLReponse(request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                return XPathQueryHelper.parseHostedPropertiesResponse(response.getStream());
            }
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    protected boolean isRequestAccepted(HttpWebResponse response) {
        return response.getStatusCode() == 200 || response.getStatusCode() == 202;
    }

    @Override
    public List<AffinityGroup> listAffinityGroups() {
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_AFFINITYGROUPS), "GET");
        try {
            HttpWebResponse response = HttpUtilities.getSSLReponse(request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                return XPathQueryHelper.parseAffinityGroupResponse(response.getStream());
            }
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    @Override
    public List<Certificate> listCertificates(String serviceName) {
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_HOSTEDSERVICES + "/" + serviceName + CERTIFICATES), "GET");
        try {
            HttpWebResponse response = HttpUtilities.getSSLReponse(request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                return XPathQueryHelper.parseCertificateResponse(response.getStream());
            }
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    @Override
    public Certificate getCertificate(String serviceName, String thumbprintAlgorithm, String thumbprint) {
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_HOSTEDSERVICES + "/" + serviceName + CERTIFICATES + "/" + thumbprintAlgorithm + "-" + thumbprint), "GET");
        try {
            HttpWebResponse response = HttpUtilities.getSSLReponse(request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                Document load = XmlUtil.load(response.getStream());
                Element element = load.getRootElement();
                return XPathQueryHelper.parseCertificate(element);
            }
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    @Override
    public void deleteCertificate(String serviceName, String thumbprintAlgorithm, String thumbprint) {
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_HOSTEDSERVICES + "/" + serviceName + CERTIFICATES + "/" + thumbprintAlgorithm + "-" + thumbprint), "DELETE");
        try {
            HttpWebResponse response = HttpUtilities.getSSLReponse(request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                return;
            }
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void addCertificate(String serviceName, byte[] data, CertificateFormat format, String password) {
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_HOSTEDSERVICES + "/" + serviceName + CERTIFICATES), "POST");
        String template = "<CertificateFile xmlns=\"http://schemas.microsoft.com/windowsazure\"><Data>{0}</Data><CertificateFormat>{1}</CertificateFormat><Password>{2}</Password></CertificateFile>";
        request.setHeader("Content-Type", APPLICATION_XML);
        String body = MessageFormat.format(template, Base64.encode(data), format.getLiteral(), password == null ? "" : password);
        ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity(body.getBytes()));
        try {
            HttpWebResponse response = HttpUtilities.getSSLReponse(request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                return;
            }
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<OperatingSystem> listOSVersions() {
        HttpUriRequest request = HttpUtilities.createHttpRequest(URI.create(this.getBaseUrl() + OPERATING_SYSTEMS), "GET");
        request.addHeader("x-ms-version", "2010-04-01");
        try {
            HttpWebResponse response = HttpUtilities.getSSLReponse((HttpRequest)request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                return XPathQueryHelper.parseOperatingSystemResponse(response.getStream());
            }
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    @Override
    public StorageAccountKey getStorageAccountKeys(String serviceName) {
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_STORAGESERVICE + "/" + serviceName + SERVICE_KEYS), "GET");
        try {
            HttpWebResponse response = HttpUtilities.getSSLReponse(request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                return this.convertServiceToKeys(response);
            }
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    private StorageAccountKey convertServiceToKeys(HttpWebResponse response) {
        StorageAccount service = XPathQueryHelper.parseStorageServiceKeysResponse(response.getStream());
        if (service != null) {
            StorageAccountKey keys = new StorageAccountKey();
            keys.setPrimaryKey(service.getPrimaryKey());
            keys.setSecondaryKey(service.getSecondaryKey());
            return keys;
        }
        return null;
    }

    @Override
    public StorageAccountKey regenerateKeys(String serviceName, KeyType type) {
        if (type == null) {
            throw new IllegalArgumentException("Key type null");
        }
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_STORAGESERVICE + "/" + serviceName + KEYS_ACTION_REGENERATE), "POST");
        request.addHeader("Content-Type", MEIDA_TYPE_TEXT_XML);
        try {
            String template = "<RegenerateKeys xmlns=\"http://schemas.microsoft.com/windowsazure\"><KeyType>{0}</KeyType></RegenerateKeys>";
            String body = MessageFormat.format(template, type.getLiteral());
            ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity(body.getBytes()));
            HttpWebResponse response = HttpUtilities.getSSLReponse(request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                return this.convertServiceToKeys(response);
            }
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    @Override
    public StorageAccountProperties getStorageAccountProperties(String serviceName) {
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_STORAGESERVICE + "/" + serviceName), "GET");
        try {
            HttpWebResponse response = HttpUtilities.getSSLReponse(request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                return XPathQueryHelper.parseStorageServicePropertiesResponse(response.getStream());
            }
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    @Override
    public List<StorageAccount> listStorageAccounts() {
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_STORAGESERVICE), "GET");
        try {
            HttpWebResponse response = HttpUtilities.getSSLReponse(request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                return XPathQueryHelper.parseStorageServiceResponse(response.getStream());
            }
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    @Override
    public AffinityGroupProperties getAffinityGroupProperties(String groupName) {
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_AFFINITYGROUPS + "/" + groupName), "GET");
        try {
            HttpWebResponse response = HttpUtilities.getSSLReponse(request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                return XPathQueryHelper.parseAffinityGroupPropertiesResponse(response.getStream());
            }
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    protected void observeOperationStatus(final String requestId, final AsyncResultCallback callback, boolean blocked) {
        Runnable runnable = new Runnable(){

            public void run() {
                while (true) {
                    OperationStatus status;
                    if ((status = ServiceManagementRest.this.getOperationStatus(requestId)).getStatus() == OperationState.Failed) {
                        callback.onError(status);
                        return;
                    }
                    if (status.getStatus() == OperationState.Succeeded) {
                        callback.onSuccess(status);
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        if (blocked) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public OperationStatus getOperationStatus(String requestId) {
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + OPERATIONS + "/" + requestId), "GET");
        try {
            this.attachHeaderForRequestId(requestId, request);
            HttpWebResponse response = HttpUtilities.getSSLReponse(request, this.getSslSocketFactory());
            if (this.isRequestAccepted(response)) {
                return XPathQueryHelper.parseOperationStatusResponse(response.getStream());
            }
            HttpUtilities.processUnexpectedStatusCode(response);
        }
        catch (StorageException we) {
            throw HttpUtilities.translateWebException(we);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    private void attachHeaderForRequestId(String requestId, HttpRequest request) {
        request.addHeader("x-ms-request-id", requestId);
    }

    @Override
    public String createDeployment(String serviceName, DeploymentSlotType deploySlotName, DeploymentConfiguration configuration, AsyncResultCallback callback) {
        if (serviceName == null) {
            throw new IllegalArgumentException("Service name is required!");
        }
        if (deploySlotName == null) {
            throw new IllegalArgumentException("Deploy Slot is required!");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Deployment define is required!");
        }
        configuration.validate();
        HttpRequest request = HttpUtilities.createServiceHttpRequest(URI.create(this.getBaseUrl() + SERVICES_HOSTEDSERVICES + "/" + serviceName + DEPLOYMENT_SLOTS + "/" + deploySlotName.getLiteral().toLowerCase()), "POST");
        request.addHeader("Content-Type", APPLICATION_XML);
        String content = this.readBase64(configuration.getConfigurationFileUrl());
        String label = configuration.getBase64Label();
        String body = MessageFormat.format(CREATE_DEPLOYMENT_BODY, configuration.getName(), configuration.getPackageBlobUrl(), content, label);
        ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity(body.getBytes()));
        return this.sendAsynchronousRequest(request, callback);
    }
}

