/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.management;

import org.soyatec.windows.azure.authenticate.Base64;
import org.soyatec.windows.azure.management.Configuration;

public class DeploymentConfiguration
extends Configuration {
    private String name;
    private String label;

    public DeploymentConfiguration() {
    }

    public DeploymentConfiguration(String name, String pkgUrl, String configurefileUrl, String label) {
        this.name = name;
        this.packageBlobUrl = pkgUrl;
        this.configurationFileUrl = configurefileUrl;
        this.label = label;
    }

    public void validate() {
        if (this.isEmpty(this.name)) {
            throw new IllegalStateException("Name is required!");
        }
        if (this.isEmpty(this.packageBlobUrl)) {
            throw new IllegalStateException("Package blob url is required!");
        }
        if (this.isEmpty(this.configurationFileUrl)) {
            throw new IllegalStateException("Configuration file is required!");
        }
        if (this.isEmpty(this.label)) {
            throw new IllegalStateException("Label is required!");
        }
        this.readConfigurationContent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getBase64Label() {
        return Base64.encode(this.getLabel().getBytes());
    }
}

