/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.internal.log4j;

import java.net.URI;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.table.AbstractTableStorageEntity;
import org.soyatec.windows.azure.table.ICloudTable;
import org.soyatec.windows.azure.table.TableStorage;

public class TableAppender
extends AppenderSkeleton {
    public static final String DEV_STORE_ACCOUNT = "devstoreaccount1";
    public static final String DEV_STORE_KEY = "Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==";
    public static final URI DEV_TABLE_URI = URI.create("http://127.0.0.1:10002");
    public static final URI CLOUD_TABLE_URI = URI.create("http://table.core.windows.net");
    private String accountName = "devstoreaccount1";
    private String accountKey = "Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==";
    private String tableName = "WADLogsTable";
    private String pattern = "%-4r %-5p %d{yyyy-MM-dd HH:mm:ss} %c %m%n";
    private TableStorage storage;
    private ICloudTable table;

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void activateOptions() {
        Logger.getLogger((String)"org.apache.http").setLevel(Level.OFF);
        this.init();
    }

    private void init() {
        this.storage = DEV_STORE_ACCOUNT.equals(this.accountName) ? TableStorage.create(DEV_TABLE_URI, true, this.accountName, this.accountKey) : TableStorage.create(CLOUD_TABLE_URI, false, this.accountName, this.accountKey);
        if (this.tableName == null) {
            LogLog.error((String)"TableName is required!");
            return;
        }
        this.createLogTable();
        if (this.layout == null) {
            LogLog.debug((String)"The layout is not loaded... we set it.");
            this.setLayout((Layout)new PatternLayout(this.pattern));
        }
    }

    private void createLogTable() {
        try {
            this.tableName = this.tableName.trim();
            this.table = this.storage.getWindowsAzureTable(this.tableName);
            this.table.createTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void append(LoggingEvent event) {
        if (this.table == null) {
            return;
        }
        String msg = event.getLevel().toString() + ": " + this.getLayout().format(event);
        LogEntity entity = new LogEntity("log4j." + event.getLevel().toString(), String.valueOf(System.currentTimeMillis()));
        entity.setMessage(msg);
        try {
            this.table.insertEntity(entity);
        }
        catch (StorageException e) {
            e.printStackTrace();
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    static class LogEntity
    extends AbstractTableStorageEntity {
        private String message = "";

        public LogEntity(String partitionKey, String rowKey) {
            super(partitionKey, rowKey);
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

