/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.blob.internal;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.http.HttpRequest;
import org.dom4j.Document;
import org.dom4j.Element;
import org.soyatec.windows.azure.authenticate.Base64;
import org.soyatec.windows.azure.authenticate.HttpRequestAccessor;
import org.soyatec.windows.azure.authenticate.SharedKeyCredentials;
import org.soyatec.windows.azure.blob.BlobStorage;
import org.soyatec.windows.azure.blob.DateTime;
import org.soyatec.windows.azure.blob.IBlobContainer;
import org.soyatec.windows.azure.blob.IContainerAccessControl;
import org.soyatec.windows.azure.blob.ISharedAccessUrl;
import org.soyatec.windows.azure.blob.ResourceType;
import org.soyatec.windows.azure.blob.SharedAccessPermissions;
import org.soyatec.windows.azure.blob.internal.BlobContainerRest;
import org.soyatec.windows.azure.blob.internal.ContainerProperties;
import org.soyatec.windows.azure.blob.internal.ListContainersResult;
import org.soyatec.windows.azure.blob.internal.SharedAccessUrl;
import org.soyatec.windows.azure.error.StorageErrorCode;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.error.StorageServerException;
import org.soyatec.windows.azure.internal.OutParameter;
import org.soyatec.windows.azure.internal.ResourceUriComponents;
import org.soyatec.windows.azure.internal.constants.HttpStatusConstant;
import org.soyatec.windows.azure.internal.constants.HttpWebResponse;
import org.soyatec.windows.azure.util.HttpUtilities;
import org.soyatec.windows.azure.util.NameValueCollection;
import org.soyatec.windows.azure.util.Utilities;
import org.soyatec.windows.azure.util.xml.XPathQueryHelper;
import org.soyatec.windows.azure.util.xml.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobStorageRest
extends BlobStorage {
    private final SharedKeyCredentials credentials;
    private String lastStatus;

    public BlobStorageRest(URI baseUri, boolean usePathStyleUris, String accountName, String base64Key) {
        super(baseUri, usePathStyleUris, accountName, base64Key);
        byte[] key = null;
        this.setBase64Key(base64Key);
        if (base64Key != null) {
            key = Base64.decode(this.getBase64Key());
        }
        this.credentials = new SharedKeyCredentials(accountName, key);
    }

    @Override
    public List<IBlobContainer> listBlobContainers() throws StorageServerException {
        String marker = "";
        String prefix = null;
        int maxResults = 100;
        ArrayList<IBlobContainer> all = new ArrayList<IBlobContainer>();
        do {
            ListContainersResult partResult = this.listContainersImpl(prefix, marker, 100);
            marker = partResult.getNextMarker();
            for (ContainerProperties container : partResult.getContains()) {
                all.add(new BlobContainerRest(this.getBaseUri(), this.isUsePathStyleUris(), this.getAccountName(), container.getName(), this.getBase64Key(), container.getLastModifiedTime(), this.getTimeout(), this.getRetryPolicy()));
            }
        } while (marker != null);
        return all;
    }

    private ListContainersResult listContainersImpl(String prefix, String marker, int maxResults) throws StorageServerException {
        final OutParameter result = new OutParameter();
        ResourceUriComponents uriComponents = new ResourceUriComponents(this.getAccountName(), null, null);
        URI listContainerssUri = this.createRequestUriForListContainers(prefix, marker, null, maxResults, uriComponents);
        final HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(listContainerssUri, "GET", this.getTimeout());
        this.credentials.signRequest(request, uriComponents);
        this.getRetryPolicy().execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 200) {
                        result.setValue(BlobStorageRest.this.listContainersResultFromResponse(response.getStream()));
                    } else {
                        HttpUtilities.processUnexpectedStatusCode(response);
                    }
                }
                catch (Exception ioe) {
                    throw new StorageServerException(StorageErrorCode.TransportError, "The connection may be lost", HttpStatusConstant.DEFAULT_STATUS, null, ioe);
                }
                return result;
            }
        });
        return (ListContainersResult)result.getValue();
    }

    private ListContainersResult listContainersResultFromResponse(InputStream stream) {
        ArrayList<ContainerProperties> props = new ArrayList<ContainerProperties>();
        String nextMarker = null;
        Document document = XmlUtil.load(stream);
        List xmlNodes = document.selectNodes(XPathQueryHelper.ContainerQuery);
        for (Element containerNode : xmlNodes) {
            Timestamp lastModified = XPathQueryHelper.loadSingleChildDateTimeValue(containerNode, "LastModified", false);
            String eTag = XPathQueryHelper.loadSingleChildStringValue(containerNode, "Etag", false);
            String containerUri = XPathQueryHelper.loadSingleChildStringValue(containerNode, "Url", true);
            String containerName = XPathQueryHelper.loadSingleChildStringValue(containerNode, "Name", true);
            ContainerProperties properties = new ContainerProperties(containerName);
            if (lastModified != null) {
                properties.setLastModifiedTime(lastModified);
            }
            properties.setETag(eTag);
            if (!Utilities.isNullOrEmpty(containerUri)) {
                properties.setUri(URI.create(containerUri));
            }
            props.add(properties);
        }
        Element nextMarkerNode = (Element)document.selectSingleNode(XPathQueryHelper.NextMarkerQuery);
        if (nextMarkerNode != null && nextMarkerNode.hasContent()) {
            nextMarker = nextMarkerNode.getStringValue();
        }
        ListContainersResult result = new ListContainersResult();
        result.setContains(props);
        result.setNextMarker(nextMarker);
        return result;
    }

    private URI createRequestUriForListContainers(String prefix, String marker, String delimiter, int maxResults, ResourceUriComponents uriComponents) {
        NameValueCollection queryParams = BlobStorageRest.createRequestUriForListing(prefix, marker, delimiter, maxResults);
        return HttpUtilities.createRequestUri(this.getBaseUri(), this.isUsePathStyleUris(), this.getAccountName(), null, null, this.getTimeout(), queryParams, uriComponents);
    }

    private static NameValueCollection createRequestUriForListing(String prefix, String marker, String delimiter, int maxResults) {
        NameValueCollection queryParams = new NameValueCollection();
        queryParams.put("comp", "list");
        if (!Utilities.isNullOrEmpty(prefix)) {
            queryParams.put("prefix", prefix);
        }
        if (!Utilities.isNullOrEmpty(marker)) {
            queryParams.put("marker", marker);
        }
        if (!Utilities.isNullOrEmpty(delimiter)) {
            queryParams.put("delimiter", delimiter);
        }
        queryParams.put("maxresults", Integer.toString(maxResults));
        return queryParams;
    }

    @Override
    public IBlobContainer getBlobContainer(String containerName) {
        if (Utilities.isNullOrEmpty(containerName)) {
            throw new IllegalArgumentException("Container name cannot be null or empty!");
        }
        return new BlobContainerRest(this.getBaseUri(), this.isUsePathStyleUris(), this.getAccountName(), containerName, this.getBase64Key(), Utilities.minTime(), this.getTimeout(), this.getRetryPolicy());
    }

    public SharedKeyCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public ISharedAccessUrl createSharedAccessUrl(String containerName, String blobName, ResourceType resource, int permissions, DateTime start, DateTime expiry, String identifier) throws StorageServerException {
        if (Utilities.isNullOrEmpty(containerName)) {
            throw new IllegalArgumentException("Container name cannot be null or empty!");
        }
        if (!Utilities.isValidContainerOrQueueName(containerName)) {
            throw new IllegalArgumentException(MessageFormat.format("The specified container name \"{0}\" is not valid!\nPlease choose a name that conforms to the naming conventions for containers!", containerName));
        }
        if (identifier == null && start != null && expiry != null) {
            Calendar calendar = start.toCalendar();
            calendar.add(11, 1);
            if (calendar.before(expiry.toCalendar())) {
                throw new IllegalArgumentException("Access without signed identifier cannot have time window more than 1 hour");
            }
        }
        SharedAccessUrl result = new SharedAccessUrl();
        result.setAccountName(this.getAccountName());
        String resourceName = containerName;
        if (blobName != null) {
            resourceName = resourceName + "/" + blobName;
        }
        StringBuilder buf = new StringBuilder();
        try {
            if (start != null) {
                buf.append("st=").append(this.urlencode(start.toString())).append("&");
            }
            buf.append("se=").append(this.urlencode(expiry.toString())).append("&");
            buf.append("sr=").append(resource.toString()).append("&");
            if (permissions != 0) {
                buf.append("sp=").append(SharedAccessPermissions.toString(permissions)).append("&");
            }
            if (identifier != null) {
                buf.append("si=").append(identifier).append("&");
            }
            String canonicalizedResource = "/" + this.getAccountName();
            if (this.isUsePathStyleUris()) {
                canonicalizedResource = canonicalizedResource + "/" + this.getAccountName();
            }
            canonicalizedResource = canonicalizedResource + "/" + resourceName;
            String signature = this.credentials.signSharedAccessUrl(SharedAccessPermissions.toString(permissions), start == null ? null : start.toString(), expiry == null ? null : expiry.toString(), canonicalizedResource, identifier);
            buf.append("sig=").append(this.urlencode(signature));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ResourceUriComponents uriComponents = new ResourceUriComponents(this.getAccountName(), "", null);
        URI containerUri = HttpRequestAccessor.constructResourceUri(this.getBaseUri(), uriComponents, this.isUsePathStyleUris());
        result.setRestUrl(containerUri.toString() + "/" + resourceName);
        result.setSignedString(buf.toString());
        return result;
    }

    private String urlencode(String str) throws UnsupportedEncodingException {
        return URLEncoder.encode(str, "UTF-8");
    }

    @Override
    public boolean isContainerExist(String containerName) throws StorageException {
        IBlobContainer container = this.getBlobContainer(containerName);
        return container.isContainerExist();
    }

    @Override
    public boolean deleteContainer(final String name) throws StorageException {
        boolean result = (Boolean)this.getRetryPolicy().execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ResourceUriComponents uriComponents = new ResourceUriComponents(BlobStorageRest.this.getAccountName(), name, null);
                NameValueCollection queryParams = new NameValueCollection();
                queryParams.put("restype", "container");
                URI uri = HttpUtilities.createRequestUri(BlobStorageRest.this.getBaseUri(), BlobStorageRest.this.isUsePathStyleUris(), BlobStorageRest.this.getAccountName(), name, null, BlobStorageRest.this.getTimeout(), queryParams, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "DELETE", BlobStorageRest.this.getTimeout());
                request.addHeader("x-ms-version", "2009-07-17");
                BlobStorageRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 200 || response.getStatusCode() == 202) {
                        return true;
                    }
                    if (response.getStatusCode() == 404) {
                        return false;
                    }
                    HttpUtilities.processUnexpectedStatusCode(response);
                }
                catch (StorageException we) {
                    throw HttpUtilities.translateWebException(we);
                }
                return false;
            }
        });
        return result;
    }

    @Override
    public IBlobContainer createContainer(String containerName) throws StorageException {
        return this.createContainer(containerName, null, IContainerAccessControl.Private);
    }

    @Override
    public IBlobContainer createContainer(String containerName, NameValueCollection metadata, IContainerAccessControl accessControl) throws StorageException {
        boolean create = this.createContainerImpl(metadata, accessControl, containerName);
        if (create) {
            return this.getBlobContainer(containerName);
        }
        throw new StorageException("Blob container " + containerName + " already exists!");
    }

    private boolean createContainerImpl(final NameValueCollection metadata, final IContainerAccessControl accessControl, final String containerName) throws StorageException {
        boolean result = false;
        result = (Boolean)this.getRetryPolicy().execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ResourceUriComponents uriComponents = new ResourceUriComponents(BlobStorageRest.this.getAccountName(), containerName, null);
                NameValueCollection queryParams = new NameValueCollection();
                queryParams.put("restype", "container");
                URI uri = HttpUtilities.createRequestUri(BlobStorageRest.this.getBaseUri(), BlobStorageRest.this.isUsePathStyleUris(), BlobStorageRest.this.getAccountName(), containerName, null, BlobStorageRest.this.getTimeout(), queryParams, uriComponents);
                HttpRequest request = HttpUtilities.createHttpRequestWithCommonHeaders(uri, "PUT", BlobStorageRest.this.getTimeout());
                request.addHeader("x-ms-version", "2009-07-17");
                if (metadata != null) {
                    HttpUtilities.addMetadataHeaders(request, metadata);
                }
                if (accessControl.isPublic()) {
                    request.addHeader("x-ms-prop-publicaccess", "true");
                }
                BlobStorageRest.this.credentials.signRequest(request, uriComponents);
                try {
                    HttpWebResponse response = HttpUtilities.getResponse(request);
                    if (response.getStatusCode() == 201) {
                        return true;
                    }
                    if (response.getStatusCode() == 409) {
                        BlobStorageRest.this.lastStatus = HttpUtilities.convertStreamToString(response.getStream());
                        return false;
                    }
                    HttpUtilities.processUnexpectedStatusCode(response);
                    return false;
                }
                catch (StorageException we) {
                    throw HttpUtilities.translateWebException(we);
                }
            }
        });
        return result;
    }

    @Override
    public String getLastStatus() {
        return this.lastStatus;
    }
}

