/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.blob.internal;

import java.net.URI;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import org.soyatec.windows.azure.blob.BlobStorage;
import org.soyatec.windows.azure.blob.IBlobContainer;
import org.soyatec.windows.azure.blob.IRetryPolicy;
import org.soyatec.windows.azure.blob.ISharedAccessUrl;
import org.soyatec.windows.azure.internal.ResourceUriComponents;
import org.soyatec.windows.azure.util.HttpUtilities;
import org.soyatec.windows.azure.util.NameValueCollection;
import org.soyatec.windows.azure.util.TimeSpan;
import org.soyatec.windows.azure.util.Utilities;

public abstract class BlobContainer
implements IBlobContainer {
    private final URI baseUri;
    private final String accountName;
    private final String containerName;
    private final boolean usePathStyleUris;
    private URI containerUri;
    private Timestamp lastModifiedTime;
    private TimeSpan timeout;
    private IRetryPolicy retryPolicy;
    private long blockSize = 0x100000L;
    private final AtomicBoolean stopFlag = new AtomicBoolean(Boolean.FALSE);

    protected BlobContainer(URI baseUri, String accountName, String containerName) {
        this(baseUri, true, accountName, containerName, Utilities.minTime());
    }

    protected BlobContainer(URI baseUri, boolean usePathStyleUris, String accountName, String containerName) {
        this(baseUri, usePathStyleUris, accountName, containerName, Utilities.minTime());
    }

    public abstract void useSharedAccessUrl(ISharedAccessUrl var1);

    public abstract void clearSharedAccessUrl();

    protected BlobContainer(URI baseUri, boolean usePathStyleUris, String accountName, String containerName, Timestamp lastModified) {
        if (!"$root".equals(containerName) && !Utilities.isValidContainerOrQueueName(containerName)) {
            throw new IllegalArgumentException(MessageFormat.format("The specified container name \"{0}\" is not valid!\nPlease choose a name that conforms to the naming conventions for containers!\nSee <a>http://msdn.microsoft.com/en-us/library/dd135715.aspx</a> for more information.", containerName));
        }
        this.baseUri = baseUri;
        this.usePathStyleUris = usePathStyleUris;
        this.accountName = accountName;
        this.containerName = containerName;
        this.timeout = BlobStorage.DefaultTimeout;
        this.retryPolicy = BlobStorage.DefaultRetryPolicy;
        this.lastModifiedTime = lastModified;
    }

    public String getURL() {
        ResourceUriComponents uriComponents = new ResourceUriComponents(this.getAccountName(), this.getContainerName(), null);
        URI uri = HttpUtilities.createRequestUri(this.getBaseUri(), this.isUsePathStyleUris(), this.getAccountName(), this.getContainerName(), null, null, new NameValueCollection(), uriComponents);
        return uri.toString();
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public boolean isUsePathStyleUris() {
        return this.usePathStyleUris;
    }

    public URI getContainerUri() {
        return this.containerUri;
    }

    public Timestamp getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public TimeSpan getTimeout() {
        return this.timeout;
    }

    public IRetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setTimeout(TimeSpan timeout) {
        this.timeout = timeout;
    }

    public void setRetryPolicy(IRetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    void setLastModifiedTime(Timestamp lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public void setContainerUri(URI containerUri) {
        this.containerUri = containerUri;
    }

    public void stopFetchProgress(boolean stop) {
        this.stopFlag.set(stop);
    }

    public boolean isStopped() {
        return this.stopFlag.get();
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public abstract String getLastStatus();
}

