/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.blob;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.soyatec.windows.azure.authenticate.StorageAccountInfo;
import org.soyatec.windows.azure.blob.DateTime;
import org.soyatec.windows.azure.blob.IBlobContainer;
import org.soyatec.windows.azure.blob.IBlobContents;
import org.soyatec.windows.azure.blob.IBlobProperties;
import org.soyatec.windows.azure.blob.IContainerAccessControl;
import org.soyatec.windows.azure.blob.IRetryPolicy;
import org.soyatec.windows.azure.blob.ISharedAccessUrl;
import org.soyatec.windows.azure.blob.ResourceType;
import org.soyatec.windows.azure.blob.internal.BlobContents;
import org.soyatec.windows.azure.blob.internal.BlobProperties;
import org.soyatec.windows.azure.blob.internal.BlobStorageRest;
import org.soyatec.windows.azure.blob.internal.RetryPolicies;
import org.soyatec.windows.azure.blob.io.BlobFileStream;
import org.soyatec.windows.azure.blob.io.BlobStream;
import org.soyatec.windows.azure.error.StorageException;
import org.soyatec.windows.azure.error.StorageServerException;
import org.soyatec.windows.azure.util.NameValueCollection;
import org.soyatec.windows.azure.util.TimeSpan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlobStorage {
    private final boolean usePathStyleUris;
    private final URI baseUri;
    private final String accountName;
    protected String base64Key;
    private TimeSpan timeout;
    private IRetryPolicy retryPolicy;
    public static final TimeSpan DefaultTimeout = TimeSpan.fromSeconds(30L);
    public static final IRetryPolicy DefaultRetryPolicy = RetryPolicies.noRetry();

    public static BlobStorage create(URI baseUri, boolean usePathStyleUris, String accountName, String base64Key) {
        return new BlobStorageRest(baseUri, usePathStyleUris, accountName, base64Key);
    }

    public static BlobStorage create(boolean usePathStyleUris, String accountName, String base64key) {
        URI hostUri = null;
        hostUri = usePathStyleUris ? URI.create("http://127.0.0.1:10000") : URI.create("http://blob.core.windows.net");
        return new BlobStorageRest(hostUri, usePathStyleUris, accountName, base64key);
    }

    public static BlobStorage create(StorageAccountInfo accountInfo) {
        return new BlobStorageRest(accountInfo.getBaseUri(), accountInfo.isUsePathStyleUris(), accountInfo.getAccountName(), accountInfo.getBase64Key());
    }

    public static IBlobProperties createBlobProperties(String blobName) {
        return new BlobProperties(blobName);
    }

    public static IBlobContents createBlobContents(File file) throws IOException {
        return new BlobContents(new BlobFileStream(file));
    }

    public static IBlobContents createBlobContents(byte[] value) {
        return new BlobContents(value);
    }

    public static IBlobContents createBlobContents(InputStream stream) throws IOException {
        return new BlobContents(stream);
    }

    public static IBlobContents createBlobContents(BlobStream stream) {
        return new BlobContents(stream);
    }

    public abstract boolean isContainerExist(String var1) throws StorageException;

    public abstract IBlobContainer createContainer(String var1, NameValueCollection var2, IContainerAccessControl var3) throws StorageException;

    public abstract IBlobContainer createContainer(String var1) throws StorageException;

    public abstract IBlobContainer getBlobContainer(String var1);

    public abstract List<IBlobContainer> listBlobContainers() throws StorageServerException;

    public abstract ISharedAccessUrl createSharedAccessUrl(String var1, String var2, ResourceType var3, int var4, DateTime var5, DateTime var6, String var7) throws StorageServerException;

    public abstract boolean deleteContainer(String var1) throws StorageException;

    protected BlobStorage(URI baseUri, boolean usePathStyleUris, String accountName, String base64Key) {
        this.baseUri = baseUri;
        this.accountName = accountName;
        this.base64Key = base64Key;
        this.usePathStyleUris = usePathStyleUris;
        this.timeout = DefaultTimeout;
        this.retryPolicy = DefaultRetryPolicy;
    }

    public boolean isUsePathStyleUris() {
        return this.usePathStyleUris;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getBase64Key() {
        return this.base64Key;
    }

    public TimeSpan getTimeout() {
        return this.timeout;
    }

    public IRetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setBase64Key(String base64Key) {
        this.base64Key = base64Key;
    }

    public void setTimeout(TimeSpan timeout) {
        this.timeout = timeout;
    }

    public void setRetryPolicy(IRetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public abstract String getLastStatus();
}

