/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.windows.azure.authenticate;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIUtils;
import org.soyatec.windows.azure.authenticate.SharedKeyCredentials;
import org.soyatec.windows.azure.blob.IBlobContainer;
import org.soyatec.windows.azure.blob.ISharedAccessUrl;
import org.soyatec.windows.azure.internal.ResourceUriComponents;
import org.soyatec.windows.azure.util.HttpUtilities;
import org.soyatec.windows.azure.util.Logger;
import org.soyatec.windows.azure.util.Utilities;

public class SharedKeyCredentialsWrapper
extends SharedKeyCredentials {
    private final SharedKeyCredentials credentials;
    private final ISharedAccessUrl shareAccessUrl;
    private final IBlobContainer container;

    public SharedKeyCredentialsWrapper(SharedKeyCredentials credentials, ISharedAccessUrl url, IBlobContainer container) {
        this.credentials = credentials;
        this.shareAccessUrl = url;
        this.container = container;
    }

    public void signRequest(HttpRequest request, ResourceUriComponents uriComponents) {
        if (request instanceof HttpRequestBase) {
            HttpRequestBase hrb = (HttpRequestBase)request;
            URI uri = hrb.getURI();
            uri = this.replaceAccountName(uri, this.shareAccessUrl.getAccountName());
            uri = this.replaceContainerName(uri, this.shareAccessUrl.getContainerName());
            uri = this.appendSignString(uri, this.shareAccessUrl.getSignedString());
            ((HttpRequestBase)request).setURI(uri);
        }
        this.addVerisonHeader(request);
    }

    private URI appendSignString(URI uri, String signedString) {
        try {
            return URIUtils.createURI((String)uri.getScheme(), (String)uri.getHost(), (int)uri.getPort(), (String)HttpUtilities.getNormalizePath(uri), (String)((uri.getQuery() == null ? Utilities.emptyString() : uri.getQuery()) + "&" + signedString), (String)uri.getFragment());
        }
        catch (URISyntaxException e) {
            Logger.error("", e);
            return uri;
        }
    }

    private void addVerisonHeader(HttpRequest request) {
        request.addHeader("x-ms-version", "2009-07-17");
    }

    private URI replaceAccountName(URI uri, String accountName) {
        try {
            String host = uri.getHost();
            String[] temp = host.split("\\.");
            temp[0] = accountName;
            return URIUtils.createURI((String)uri.getScheme(), (String)SharedKeyCredentialsWrapper.join(".", temp), (int)uri.getPort(), (String)HttpUtilities.getNormalizePath(uri), (String)(uri.getQuery() == null ? Utilities.emptyString() : uri.getQuery()), (String)uri.getFragment());
        }
        catch (URISyntaxException e) {
            Logger.error("", e);
            return uri;
        }
    }

    private URI replaceContainerName(URI uri, String containerName) {
        if (containerName == null) {
            return uri;
        }
        try {
            String host = uri.getPath();
            String[] temp = host.split("/");
            temp[0] = containerName;
            return URIUtils.createURI((String)uri.getScheme(), (String)uri.getHost(), (int)uri.getPort(), (String)SharedKeyCredentialsWrapper.join("/", temp), (String)(uri.getQuery() == null ? Utilities.emptyString() : uri.getQuery()), (String)uri.getFragment());
        }
        catch (URISyntaxException e) {
            Logger.error("", e);
            return uri;
        }
    }

    public static final String join(String se, String[] sources) {
        StringBuffer sb = new StringBuffer();
        int n = sources.length;
        for (int i = 0; i < n; ++i) {
            sb.append(sources[i]);
            if (i >= n - 1) continue;
            sb.append(se);
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        return this.credentials.equals(obj);
    }

    public String getAccountName() {
        return this.credentials.getAccountName();
    }

    public byte[] getKey() {
        return this.credentials.getKey();
    }

    public int hashCode() {
        return this.credentials.hashCode();
    }

    public void signRequestForSharedKeyLite(HttpRequest request, ResourceUriComponents uriComponents) {
        this.credentials.signRequestForSharedKeyLite(request, uriComponents);
    }

    public String signSharedAccessUrl(String permissions, String start, String expiry, String canonicalizedResource, String identifier) {
        return this.credentials.signSharedAccessUrl(permissions, start, expiry, canonicalizedResource, identifier);
    }

    public String toString() {
        return this.credentials.toString();
    }

    public ISharedAccessUrl getShareAccessUrl() {
        return this.shareAccessUrl;
    }

    public SharedKeyCredentials getCredentials() {
        return this.credentials;
    }
}

