/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.putty;

import ch.ethz.ssh2.crypto.Base64;
import ch.ethz.ssh2.crypto.PEMDecryptException;
import ch.ethz.ssh2.crypto.cipher.AES;
import ch.ethz.ssh2.crypto.cipher.CBCMode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.putty.DEREncoder;
import org.kohsuke.putty.KeyReader;

public class PuTTYKey {
    private static final String PUTTY_SIGNATURE = "PuTTY-User-Key-File-";
    private byte[] privateKey;
    private byte[] publicKey;
    private Map<String, String> payload = new HashMap<String, String>();
    private final Map<String, String> headers = new HashMap<String, String>();

    public PuTTYKey(File ppkFile) throws IOException {
        this(new FileReader(ppkFile));
    }

    public PuTTYKey(InputStream in) throws IOException {
        this(new InputStreamReader(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PuTTYKey(Reader in) throws IOException {
        BufferedReader r = new BufferedReader(in);
        try {
            String line;
            String headerName = null;
            while ((line = r.readLine()) != null) {
                int idx = line.indexOf(": ");
                if (idx > 0) {
                    headerName = line.substring(0, idx);
                    this.headers.put(headerName, line.substring(idx + 2));
                    continue;
                }
                String s = this.payload.get(headerName);
                s = s == null ? line : s + line;
                this.payload.put(headerName, s);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            r.close();
            throw throwable;
        }
        r.close();
        this.publicKey = PuTTYKey.decodeBase64(this.payload.get("Public-Lines"));
        this.privateKey = PuTTYKey.decodeBase64(this.payload.get("Private-Lines"));
    }

    public boolean isEncrypted() {
        return "aes256-cbc".equals(this.headers.get("Encryption"));
    }

    private byte[] decrypt(String passphrase) throws IOException {
        if (this.isEncrypted()) {
            AES aes = new AES();
            byte[] key = this.toKey(passphrase);
            aes.init(false, key);
            CBCMode cbc = new CBCMode(aes, new byte[16], false);
            byte[] out = new byte[this.privateKey.length];
            for (int i = 0; i < this.privateKey.length / cbc.getBlockSize(); ++i) {
                cbc.transformBlock(this.privateKey, i * cbc.getBlockSize(), out, i * cbc.getBlockSize());
            }
            return out;
        }
        return this.privateKey;
    }

    public String getAlgorithm() {
        return this.headers.get("PuTTY-User-Key-File-2");
    }

    private byte[] toKey(String passphrase) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(new byte[]{0, 0, 0, 0});
            digest.update(passphrase.getBytes());
            byte[] key1 = digest.digest();
            digest.update(new byte[]{0, 0, 0, 1});
            digest.update(passphrase.getBytes());
            byte[] key2 = digest.digest();
            byte[] r = new byte[32];
            System.arraycopy(key1, 0, r, 0, 20);
            System.arraycopy(key2, 0, r, 20, 12);
            return r;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] decodeBase64(String s) throws IOException {
        return Base64.decode(s.toCharArray());
    }

    public String toOpenSSH(String passphrase) throws IOException, PEMDecryptException {
        if ("ssh-rsa".equals(this.getAlgorithm())) {
            KeyReader r = new KeyReader(this.publicKey);
            r.skip();
            BigInteger e = r.readInt();
            BigInteger n = r.readInt();
            r = new KeyReader(this.decrypt(passphrase));
            BigInteger d = r.readInt();
            BigInteger p = r.readInt();
            BigInteger q = r.readInt();
            BigInteger iqmp = r.readInt();
            BigInteger dmp1 = d.mod(p.subtract(BigInteger.ONE));
            BigInteger dmq1 = d.mod(q.subtract(BigInteger.ONE));
            DEREncoder payload = new DEREncoder().writeSequence(new DEREncoder().write(BigInteger.ZERO, n, e, d, p, q, dmp1, dmq1, iqmp).toByteArray());
            StringBuilder buf = new StringBuilder();
            buf.append("-----BEGIN RSA PRIVATE KEY-----\n");
            buf.append(payload.toBase64());
            buf.append("-----END RSA PRIVATE KEY-----\n");
            return buf.toString();
        }
        if ("ssh-dss".equals(this.getAlgorithm())) {
            KeyReader r = new KeyReader(this.publicKey);
            r.skip();
            BigInteger p = r.readInt();
            BigInteger q = r.readInt();
            BigInteger g = r.readInt();
            BigInteger y = r.readInt();
            r = new KeyReader(this.decrypt(passphrase));
            BigInteger x = r.readInt();
            DEREncoder payload = new DEREncoder().writeSequence(new DEREncoder().write(BigInteger.ZERO, p, q, g, y, x).toByteArray());
            StringBuilder buf = new StringBuilder();
            buf.append("-----BEGIN DSA PRIVATE KEY-----\n");
            buf.append(payload.toBase64());
            buf.append("-----END DSA PRIVATE KEY-----\n");
            return buf.toString();
        }
        throw new IllegalArgumentException("Unrecognized key type: " + this.getAlgorithm());
    }

    public static boolean isPuTTYKeyFile(File ppkFile) throws IOException {
        return PuTTYKey.isPuTTYKeyFile(new FileReader(ppkFile));
    }

    public static boolean isPuTTYKeyFile(InputStream in) throws IOException {
        return PuTTYKey.isPuTTYKeyFile(new InputStreamReader(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPuTTYKeyFile(Reader _reader) throws IOException {
        boolean bl;
        BufferedReader r = new BufferedReader(_reader);
        try {
            String line;
            while ((line = r.readLine()) != null) {
                if (!line.startsWith(PUTTY_SIGNATURE)) continue;
                bl = true;
                Object var5_5 = null;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            r.close();
            throw throwable;
        }
        {
            r.close();
            return bl;
        }
        boolean bl2 = false;
        Object var5_6 = null;
        r.close();
        return bl2;
    }
}

