/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ClientServerHello {
    String server_line;
    String client_line;
    String server_versioncomment;

    public static final int readLineRN(InputStream is, byte[] buffer) throws IOException {
        int len;
        block4: {
            int pos = 0;
            boolean need10 = false;
            len = 0;
            while (true) {
                int c;
                if ((c = is.read()) == -1) {
                    throw new IOException("Premature connection close");
                }
                buffer[pos++] = (byte)c;
                if (c == 13) {
                    need10 = true;
                    continue;
                }
                if (c == 10) break block4;
                if (need10) {
                    throw new IOException("Malformed line sent by the server, the line does not end correctly.");
                }
                ++len;
                if (pos >= buffer.length) break;
            }
            throw new IOException("The server sent a too long line.");
        }
        return len;
    }

    public ClientServerHello(String identification, InputStream bi, OutputStream bo) throws IOException {
        this.client_line = "SSH-2.0-" + identification;
        bo.write((this.client_line + "\r\n").getBytes());
        bo.flush();
        byte[] serverVersion = new byte[512];
        for (int i = 0; i < 50; ++i) {
            int len = ClientServerHello.readLineRN(bi, serverVersion);
            this.server_line = new String(serverVersion, 0, len);
            if (this.server_line.startsWith("SSH-")) break;
        }
        if (!this.server_line.startsWith("SSH-")) {
            throw new IOException("Malformed server identification string. There was no line starting with 'SSH-' amongst the first 50 lines.");
        }
        if (this.server_line.startsWith("SSH-1.99-")) {
            this.server_versioncomment = this.server_line.substring(9);
        } else if (this.server_line.startsWith("SSH-2.0-")) {
            this.server_versioncomment = this.server_line.substring(8);
        } else {
            throw new IOException("Server uses incompatible protocol, it is not SSH-2 compatible.");
        }
    }

    public byte[] getClientString() {
        return this.client_line.getBytes();
    }

    public byte[] getServerString() {
        return this.server_line.getBytes();
    }
}

