/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Collection;
import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.ErrorListener;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.BackgroundException;
import ch.cyberduck.ui.growl.Growl;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepeatableBackgroundAction
extends AbstractBackgroundAction
implements ErrorListener,
TranscriptListener {
    private static Logger log = Logger.getLogger(RepeatableBackgroundAction.class);
    private static final String lineSeparator = System.getProperty("line.separator");
    private List<BackgroundException> exceptions = new Collection<BackgroundException>();
    private boolean failed;
    private StringBuilder transcript;
    private final int repeatAttempts = Preferences.instance().getInteger("connection.retry");
    protected int repeatCount;
    private static final int TRANSCRIPT_MAX_LENGTH = Preferences.instance().getInteger("transcript.length");

    @Override
    public void error(BackgroundException exception) {
        String description;
        Throwable cause = exception.getCause();
        if (cause instanceof ConnectionCanceledException) {
            log.warn((Object)cause.getMessage());
            return;
        }
        if (cause instanceof CertificateException) {
            log.warn((Object)cause.getMessage());
            return;
        }
        if (cause instanceof SSLPeerUnverifiedException) {
            log.warn((Object)cause.getMessage());
            return;
        }
        String string = description = null == exception.getPath() ? exception.getSession().getHost().getHostname() : exception.getPath().getName();
        if (this.exceptions.size() < Preferences.instance().getInteger("growl.limit")) {
            Growl.instance().notify(exception.getMessage(), description);
        }
        if (!this.exceptions.contains(exception)) {
            this.exceptions.add(exception);
        }
        this.failed = true;
    }

    public List<BackgroundException> getExceptions() {
        return this.exceptions;
    }

    public String getTranscript() {
        return this.transcript.toString();
    }

    public boolean hasTranscript() {
        return this.transcript.length() > 0;
    }

    @Override
    public void log(boolean request, String message) {
        if (this.transcript.length() > TRANSCRIPT_MAX_LENGTH) {
            this.transcript = new StringBuilder();
        }
        this.transcript.append(message).append(lineSeparator);
    }

    @Override
    public void init() {
        BackgroundActionRegistry.global().add(this);
    }

    @Override
    public boolean prepare() {
        Session session = this.getSession();
        if (session != null) {
            session.addErrorListener(this);
            session.addTranscriptListener(this);
        }
        this.transcript = new StringBuilder();
        return super.prepare();
    }

    protected abstract Session getSession();

    public int retry() {
        if (!this.isCanceled()) {
            for (BackgroundException e : this.exceptions) {
                Throwable cause = e.getCause();
                if (!(cause instanceof SocketException) && !(cause instanceof SocketTimeoutException) && !(cause instanceof UnknownHostException)) continue;
                return this.repeatAttempts - this.repeatCount;
            }
        }
        return 0;
    }

    protected void reset() {
        this.failed = false;
        this.exceptions.clear();
    }

    protected void diagnose() {
        List<BackgroundException> exceptions = this.getExceptions();
        exceptions.get(exceptions.size() - 1).getSession().getHost().diagnose();
    }

    protected boolean hasFailed() {
        return this.failed;
    }

    public boolean isNetworkFailure() {
        for (BackgroundException e : this.getExceptions()) {
            Throwable cause = e.getCause();
            if (!(cause instanceof SocketException) && !(cause instanceof UnknownHostException)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void finish() {
        while (this.hasFailed() && this.retry() > 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Retry failed background action:" + this));
            }
            this.pause();
            if (this.isCanceled()) continue;
            ++this.repeatCount;
            this.failed = false;
            this.run();
        }
        Session session = this.getSession();
        if (session != null) {
            session.removeTranscriptListener(this);
            session.removeErrorListener(this);
        }
        super.finish();
    }

    public void pause() {
        if (0 == Preferences.instance().getInteger("connection.retry.delay")) {
            log.info((Object)"No pause between retry");
            return;
        }
        Timer wakeup = new Timer();
        final CyclicBarrier wait = new CyclicBarrier(2);
        wakeup.scheduleAtFixedRate(new TimerTask(){
            private int delay = (int)Preferences.instance().getDouble("connection.retry.delay");
            private final String pattern = Locale.localizedString("Retry again in {0} seconds ({1} more attempts)", "Status");

            public void run() {
                if (0 == this.delay || RepeatableBackgroundAction.this.isCanceled()) {
                    this.cancel();
                    return;
                }
                Session session = RepeatableBackgroundAction.this.getSession();
                if (session != null) {
                    session.message(MessageFormat.format(this.pattern, this.delay--, RepeatableBackgroundAction.this.retry()));
                }
            }

            public boolean cancel() {
                try {
                    wait.await();
                }
                catch (InterruptedException e) {
                    log.error((Object)e.getMessage());
                }
                catch (BrokenBarrierException e) {
                    log.error((Object)e.getMessage());
                }
                return super.cancel();
            }
        }, 0L, 1000L);
        try {
            wait.await();
        }
        catch (InterruptedException e) {
            log.error((Object)e.getMessage());
        }
        catch (BrokenBarrierException e) {
            log.error((Object)e.getMessage());
        }
    }

    @Override
    public Object lock() {
        return this.getSession();
    }

    @Override
    public String toString() {
        Session session = this.getSession();
        if (session != null) {
            return session.getHost().getHostname();
        }
        return Locale.localizedString("Unknown");
    }
}

