/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBackgroundAction
implements BackgroundAction {
    private boolean canceled;
    private boolean running;
    private Set<BackgroundActionListener> listeners = Collections.synchronizedSet(new HashSet());
    private final Object lock = new Object();

    @Override
    public void init() {
    }

    @Override
    public void cancel() {
        BackgroundActionListener[] l;
        this.canceled = true;
        for (BackgroundActionListener listener : l = this.listeners.toArray(new BackgroundActionListener[this.listeners.size()])) {
            listener.cancel(this);
        }
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean prepare() {
        BackgroundActionListener[] l;
        if (this.isCanceled()) {
            return false;
        }
        this.running = true;
        for (BackgroundActionListener listener : l = this.listeners.toArray(new BackgroundActionListener[this.listeners.size()])) {
            listener.start(this);
        }
        return true;
    }

    @Override
    public void finish() {
        BackgroundActionListener[] l;
        this.running = false;
        for (BackgroundActionListener listener : l = this.listeners.toArray(new BackgroundActionListener[this.listeners.size()])) {
            listener.stop(this);
        }
    }

    @Override
    public void cleanup() {
    }

    protected String toString(List<Path> files) {
        StringBuilder name = new StringBuilder();
        name.append(files.get(0).getName());
        if (files.size() > 1) {
            name.append("\u2026");
        }
        return name.toString();
    }

    @Override
    public void addListener(BackgroundActionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(BackgroundActionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public String getActivity() {
        return Locale.localizedString("Unknown");
    }

    public String toString() {
        return this.getActivity();
    }

    @Override
    public Object lock() {
        return this.lock;
    }
}

