/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.KeychainFactory;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.ssl.AbstractX509TrustManager;
import java.io.IOException;
import java.net.Socket;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public abstract class KeychainX509TrustManager
extends AbstractX509TrustManager {
    protected static Logger log = Logger.getLogger(KeychainX509TrustManager.class);
    private static KeyStore store;

    public abstract String getHostname();

    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.checkCertificates(x509Certificates);
    }

    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.checkCertificates(x509Certificates);
    }

    private void checkCertificates(X509Certificate[] certs) throws CertificateException {
        if (Arrays.asList(this.getAcceptedIssuers()).containsAll(Arrays.asList(certs))) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Certificate for " + this.getHostname() + " previously trusted"));
            }
            return;
        }
        if (KeychainFactory.instance().isTrusted(this.getHostname(), certs)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Certificate for " + this.getHostname() + " trusted in Keychain"));
            }
        } else {
            throw new CertificateException(Locale.localizedString("No trusted certificate found", "Status"));
        }
        this.acceptCertificate(certs);
    }

    private KeyStore init() {
        if (null == store) {
            try {
                store = KeyStore.getInstance("KeychainStore", "Apple");
                store.load(null, null);
            }
            catch (CertificateException e) {
                log.error((Object)e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)e.getMessage());
            }
            catch (KeyStoreException e) {
                log.error((Object)e.getMessage());
            }
            catch (IOException e) {
                log.error((Object)e.getMessage());
            }
            catch (NoSuchProviderException e) {
                log.error((Object)e.getMessage());
            }
        }
        return store;
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        try {
            KeyStore store = this.init();
            ArrayList<String> list = new ArrayList<String>();
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                log.info((Object)("Alias in Keychain:" + alias));
                if (store.isKeyEntry(alias)) {
                    log.info((Object)("Private key for alias:" + alias));
                    continue;
                }
                if (!store.isCertificateEntry(alias)) continue;
                Certificate cert = store.getCertificate(alias);
                if (null == cert) {
                    log.warn((Object)("Failed to retrieve certificate for alias:" + alias));
                    continue;
                }
                if (!(cert instanceof X509Certificate) || !Arrays.asList(issuers).contains(((X509Certificate)cert).getIssuerX500Principal())) continue;
                list.add(((X509Certificate)cert).getIssuerX500Principal().getName());
            }
            X509Certificate cert = KeychainFactory.instance().chooseCertificate(list.toArray(new String[list.size()]), MessageFormat.format(Locale.localizedString("Select the certificate to use when connecting to {0}."), this.getHostname()));
            if (null == cert) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("No certificate selected for hostname:" + this.getHostname()));
                }
                return null;
            }
            String alias = store.getCertificateAlias(cert);
            log.info((Object)("Certificate alias choosen:" + alias));
            return alias;
        }
        catch (KeyStoreException e) {
            log.error((Object)("Keystore not loaded:" + e.getMessage()));
            return null;
        }
    }

    public X509Certificate[] getCertificateChain(String alias) {
        try {
            KeyStore store = this.init();
            ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
            Certificate[] chain = store.getCertificateChain(alias);
            if (null == chain) {
                log.warn((Object)("No certificate chain for alias:" + alias));
            } else {
                for (Certificate cert : chain) {
                    if (!(cert instanceof X509Certificate)) continue;
                    result.add((X509Certificate)cert);
                }
            }
            if (result.isEmpty()) {
                log.warn((Object)("No certificate chain for alias:" + alias));
                Certificate cert = store.getCertificate(alias);
                if (cert instanceof X509Certificate) {
                    result.add((X509Certificate)cert);
                }
            }
            return result.toArray(new X509Certificate[result.size()]);
        }
        catch (KeyStoreException e) {
            log.error((Object)("Keystore not loaded:" + e.getMessage()));
            return null;
        }
    }

    public PrivateKey getPrivateKey(String alias) {
        KeyStore store = this.init();
        try {
            Key key;
            if (store.isKeyEntry(alias) && (key = store.getKey(alias, "null".toCharArray())) instanceof PrivateKey) {
                return (PrivateKey)key;
            }
        }
        catch (KeyStoreException e) {
            log.error((Object)("Keystore not loaded:" + e.getMessage()));
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage());
        }
        catch (UnrecoverableKeyException e) {
            log.error((Object)e.getMessage());
        }
        log.warn((Object)("No private key for alias:" + alias));
        return null;
    }
}

