/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.Preferences;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomTrustSSLProtocolSocketFactory
extends SSLSocketFactory {
    private static Logger log = Logger.getLogger(CustomTrustSSLProtocolSocketFactory.class);
    private SSLSocketFactory factory;
    private SSLContext context;
    private static final List<String> ENABLED_SSL_PROTOCOLS = new ArrayList<String>();

    public List<String> getEnabledProtocols() {
        return ENABLED_SSL_PROTOCOLS;
    }

    public CustomTrustSSLProtocolSocketFactory(X509TrustManager trust) {
        this(trust, null);
    }

    public CustomTrustSSLProtocolSocketFactory(X509TrustManager trust, X509KeyManager key) {
        try {
            this.context = SSLContext.getInstance("TLS");
            this.context.init(new KeyManager[]{key}, new TrustManager[]{trust}, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using SSL context:" + this.context));
            }
            this.factory = this.context.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
    }

    private void configure(Socket socket, String[] protocols) throws IOException {
        if (socket instanceof SSLSocket) {
            try {
                log.debug((Object)("Configure SSL parameters with protocol:" + Arrays.toString(protocols)));
                ((SSLSocket)socket).setEnabledProtocols(protocols);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to configure SSL parameters:" + e.getMessage()));
            }
        }
    }

    private Socket handshake(SocketGetter f) throws IOException {
        Socket socket = f.create();
        try {
            this.configure(socket, ENABLED_SSL_PROTOCOLS.toArray(new String[ENABLED_SSL_PROTOCOLS.size()]));
            log.debug((Object)("handhsake:" + socket));
        }
        catch (IOException e) {
            log.warn((Object)("Handshake failed for:" + e.getMessage()));
            throw e;
        }
        return socket;
    }

    public SSLContext getSSLContext() {
        return this.context;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.handshake(new SocketGetter(){

            public Socket create() throws IOException {
                return CustomTrustSSLProtocolSocketFactory.this.factory.createSocket();
            }
        });
    }

    @Override
    public Socket createSocket(final String host, final int port, final InetAddress clientHost, final int clientPort) throws IOException {
        return this.handshake(new SocketGetter(){

            public Socket create() throws IOException {
                return CustomTrustSSLProtocolSocketFactory.this.factory.createSocket(host, port, clientHost, clientPort);
            }
        });
    }

    @Override
    public Socket createSocket(final InetAddress host, final int port) throws IOException {
        return this.handshake(new SocketGetter(){

            public Socket create() throws IOException {
                return CustomTrustSSLProtocolSocketFactory.this.factory.createSocket(host, port);
            }
        });
    }

    @Override
    public Socket createSocket(final InetAddress host, final int port, final InetAddress localHost, final int localPort) throws IOException {
        return this.handshake(new SocketGetter(){

            public Socket create() throws IOException {
                return CustomTrustSSLProtocolSocketFactory.this.factory.createSocket(host, port, localHost, localPort);
            }
        });
    }

    @Override
    public Socket createSocket(final String host, final int port) throws IOException {
        return this.handshake(new SocketGetter(){

            public Socket create() throws IOException {
                return CustomTrustSSLProtocolSocketFactory.this.factory.createSocket(host, port);
            }
        });
    }

    @Override
    public Socket createSocket(final Socket socket, final String host, final int port, final boolean autoClose) throws IOException {
        return this.handshake(new SocketGetter(){

            public Socket create() throws IOException {
                return CustomTrustSSLProtocolSocketFactory.this.factory.createSocket(socket, host, port, autoClose);
            }
        });
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return this.context.getServerSocketFactory().createServerSocket(port);
    }

    static {
        for (String protocol : Preferences.instance().getProperty("connection.ssl.protocols").split(",")) {
            ENABLED_SSL_PROTOCOLS.add(protocol.trim());
        }
    }

    private static interface SocketGetter {
        public Socket create() throws IOException;
    }
}

