/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.StreamListener;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.IOResumeException;
import ch.cyberduck.core.sftp.SFTPInputStream;
import ch.cyberduck.core.sftp.SFTPOutputStream;
import ch.cyberduck.core.sftp.SFTPSession;
import ch.cyberduck.ui.DateFormatterFactory;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.sftp.SFTPException;
import ch.ethz.ssh2.sftp.SFTPv3DirectoryEntry;
import ch.ethz.ssh2.sftp.SFTPv3FileAttributes;
import ch.ethz.ssh2.sftp.SFTPv3FileHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFTPPath
extends Path {
    private static Logger log = Logger.getLogger(SFTPPath.class);
    private final SFTPSession session;

    public static PathFactory factory() {
        return new Factory();
    }

    private SFTPPath(SFTPSession s, String parent, String name, int type) {
        super(parent, name, type);
        this.session = s;
    }

    private SFTPPath(SFTPSession s, String path, int type) {
        super(path, type);
        this.session = s;
    }

    private SFTPPath(SFTPSession s, String parent, Local file) {
        super(parent, file);
        this.session = s;
    }

    private <T> SFTPPath(SFTPSession s, T dict) {
        super(dict);
        this.session = s;
    }

    @Override
    public SFTPSession getSession() {
        return this.session;
    }

    @Override
    public AttributedList<Path> list(AttributedList<Path> children) {
        block4: {
            if (this.attributes().isDirectory()) {
                try {
                    this.getSession().check();
                    this.getSession().message(MessageFormat.format(Locale.localizedString("Listing directory {0}", "Status"), this.getName()));
                    for (SFTPv3DirectoryEntry f : this.getSession().sftp().ls(this.getAbsolute())) {
                        if (f.filename.equals(".") || f.filename.equals("..")) continue;
                        SFTPv3FileAttributes attributes = f.attributes;
                        SFTPPath p = new SFTPPath(this.getSession(), this.getAbsolute(), f.filename, attributes.isDirectory() ? 2 : 1);
                        p.setParent(this);
                        p.readAttributes(attributes);
                        children.add(p);
                    }
                    this.getSession().setWorkdir(this);
                }
                catch (IOException e) {
                    log.warn((Object)("Listing directory failed:" + e.getMessage()));
                    children.attributes().setReadable(false);
                    if (!this.cache().isEmpty()) break block4;
                    this.error(e.getMessage(), e);
                }
            }
        }
        return children;
    }

    @Override
    public void mkdir() {
        if (this.attributes().isDirectory()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Making directory {0}", "Status"), this.getName()));
                this.getSession().sftp().mkdir(this.getAbsolute(), Integer.parseInt(new Permission(Preferences.instance().getInteger("queue.upload.permissions.folder.default")).getOctalString(), 8));
                this.cache().put(this.getReference(), AttributedList.emptyList());
                this.getParent().invalidate();
            }
            catch (IOException e) {
                this.error("Cannot create folder {0}", e);
            }
        }
    }

    @Override
    public void rename(AbstractPath renamed) {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Renaming {0} to {1}", "Status"), this.getName(), renamed));
            if (renamed.exists()) {
                renamed.delete();
            }
            this.getSession().sftp().mv(this.getAbsolute(), renamed.getAbsolute());
            renamed.getParent().invalidate();
            this.getParent().invalidate();
        }
        catch (IOException e) {
            this.error("Cannot rename {0}", e);
        }
    }

    @Override
    public void delete() {
        try {
            this.getSession().check();
            if (this.attributes().isFile() || this.attributes().isSymbolicLink()) {
                this.getSession().message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                this.getSession().sftp().rm(this.getAbsolute());
            } else if (this.attributes().isDirectory()) {
                for (AbstractPath child : this.children()) {
                    if (!this.getSession().isConnected()) break;
                    child.delete();
                }
                this.getSession().message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                this.getSession().sftp().rmdir(this.getAbsolute());
            }
            this.getParent().invalidate();
        }
        catch (IOException e) {
            this.error("Cannot delete {0}", e);
        }
    }

    protected void readAttributes() throws IOException {
        this.readAttributes(this.getSession().sftp().stat(this.getAbsolute()));
    }

    protected void readAttributes(SFTPv3FileAttributes attributes) {
        String perm;
        if (null != attributes.size) {
            this.attributes().setSize(attributes.size);
        }
        if (null != (perm = attributes.getOctalPermissions())) {
            try {
                String octal = Integer.toOctalString(attributes.permissions);
                this.attributes().setPermission(new Permission(Integer.parseInt(octal.substring(octal.length() - 4))));
            }
            catch (IndexOutOfBoundsException e) {
                log.warn((Object)("Failure parsing mode:" + e.getMessage()));
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Failure parsing mode:" + e.getMessage()));
            }
        }
        if (null != attributes.uid) {
            this.attributes().setOwner(attributes.uid.toString());
        }
        if (null != attributes.gid) {
            this.attributes().setGroup(attributes.gid.toString());
        }
        if (null != attributes.mtime) {
            this.attributes().setModificationDate(Long.parseLong(attributes.mtime.toString()) * 1000L);
        }
        if (null != attributes.atime) {
            this.attributes().setAccessedDate(Long.parseLong(attributes.atime.toString()) * 1000L);
        }
        if (attributes.isSymlink()) {
            try {
                String target = this.getSession().sftp().readLink(this.getAbsolute());
                if (!target.startsWith(String.valueOf('/'))) {
                    target = Path.normalize(this.getParent().getAbsolute() + String.valueOf('/') + target);
                }
                this.setSymlinkTarget(target);
                SFTPv3FileAttributes targetAttributes = this.getSession().sftp().stat(target);
                if (targetAttributes.isDirectory()) {
                    this.attributes().setType(6);
                } else if (targetAttributes.isRegularFile()) {
                    this.attributes().setType(5);
                }
            }
            catch (IOException e) {
                log.error((Object)("Cannot read symbolic link target of " + this.getAbsolute() + ":" + e.getMessage()));
                this.attributes().setType(5);
            }
        }
    }

    protected void writeAttributes(SFTPv3FileAttributes attributes) throws IOException {
        this.getSession().sftp().setstat(this.getAbsolute(), attributes);
    }

    @Override
    public void readSize() {
        if (this.attributes().isFile()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Getting size of {0}", "Status"), this.getName()));
                this.readAttributes();
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    @Override
    public void readTimestamp() {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Getting timestamp of {0}", "Status"), this.getName()));
            this.readAttributes();
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    @Override
    public void readUnixPermission() {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Getting permission of {0}", "Status"), this.getName()));
            this.readAttributes();
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    @Override
    public void writeOwner(String owner, boolean recursive) {
        block4: {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Changing owner of {0} to {1}", "Status"), this.getName(), owner));
                SFTPv3FileAttributes attr = new SFTPv3FileAttributes();
                attr.uid = new Integer(owner);
                this.writeAttributes(attr);
                if (!this.attributes().isDirectory() || !recursive) break block4;
                for (AbstractPath child : this.children()) {
                    if (this.getSession().isConnected()) {
                        ((Path)child).writeOwner(owner, recursive);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.error("Cannot change owner", e);
            }
        }
    }

    @Override
    public void writeGroup(String group, boolean recursive) {
        block4: {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Changing group of {0} to {1}", "Status"), this.getName(), group));
                SFTPv3FileAttributes attr = new SFTPv3FileAttributes();
                attr.gid = new Integer(group);
                this.writeAttributes(attr);
                if (!this.attributes().isDirectory() || !recursive) break block4;
                for (AbstractPath child : this.children()) {
                    if (this.getSession().isConnected()) {
                        ((Path)child).writeGroup(group, recursive);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                this.error("Cannot change group", e);
            }
        }
    }

    @Override
    public void writeUnixPermission(Permission perm, boolean recursive) {
        try {
            this.getSession().check();
            this.writeUnixPermissionImpl(perm, recursive);
        }
        catch (IOException e) {
            this.error("Cannot change permissions", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUnixPermissionImpl(Permission perm, boolean recursive) throws IOException {
        this.getSession().message(MessageFormat.format(Locale.localizedString("Changing permission of {0} to {1}", "Status"), this.getName(), perm.getOctalString()));
        try {
            try {
                SFTPv3FileAttributes attr = new SFTPv3FileAttributes();
                attr.permissions = Integer.parseInt(perm.getOctalString(), 8);
                this.writeAttributes(attr);
                if (this.attributes().isDirectory() && recursive) {
                    for (AbstractPath child : this.children()) {
                        if (!this.getSession().isConnected()) break;
                        ((SFTPPath)child).writeUnixPermissionImpl(perm, recursive);
                    }
                }
                Object var7_7 = null;
                this.attributes().clear(false, false, true, false);
            }
            catch (SFTPException ignore) {
                log.warn((Object)ignore.getMessage());
                Object var7_8 = null;
                this.attributes().clear(false, false, true, false);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.attributes().clear(false, false, true, false);
            throw throwable;
        }
    }

    @Override
    public void writeTimestamp(long created, long modified, long accessed) {
        try {
            this.writeModificationDateImpl(modified);
        }
        catch (IOException e) {
            this.error("Cannot change timestamp", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeModificationDateImpl(long modified) throws IOException {
        this.getSession().message(MessageFormat.format(Locale.localizedString("Changing timestamp of {0} to {1}", "Status"), this.getName(), DateFormatterFactory.instance().getShortFormat(modified)));
        try {
            try {
                SFTPv3FileAttributes attrs = new SFTPv3FileAttributes();
                int t = (int)(modified / 1000L);
                attrs.atime = t;
                attrs.mtime = t;
                this.writeAttributes(attrs);
            }
            catch (SFTPException ignore) {
                log.warn((Object)ignore.getMessage());
                Object var6_6 = null;
                this.attributes().clear(true, false, false, false);
            }
            Object var6_5 = null;
            this.attributes().clear(true, false, false, false);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.attributes().clear(true, false, false, false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void download(BandwidthThrottle throttle, StreamListener listener, boolean check) {
        if (!this.attributes().isFile()) return;
        InputStream in = null;
        OutputStream out = null;
        try {
            try {
                if (check) {
                    this.getSession().check();
                }
                if (Preferences.instance().getProperty("ssh.transfer").equals(Protocol.SFTP.getIdentifier())) {
                    SFTPv3FileHandle handle = this.getSession().sftp().openFileRO(this.getAbsolute());
                    in = new SFTPInputStream(handle);
                    if (this.status().isResume()) {
                        log.info((Object)("Skipping " + this.status().getCurrent() + " bytes"));
                        long skipped = in.skip(this.status().getCurrent());
                        if (skipped < this.status().getCurrent()) {
                            throw new IOResumeException("Skipped " + skipped + " bytes instead of " + this.status().getCurrent());
                        }
                    }
                }
                if (Preferences.instance().getProperty("ssh.transfer").equals(Protocol.SCP.getIdentifier())) {
                    SCPClient scp = this.getSession().openScp();
                    scp.setCharset(this.getSession().getEncoding());
                    in = scp.get(this.getAbsolute());
                }
                out = this.getLocal().getOutputStream(this.status().isResume());
                this.getSession().sftp().setRequestParallelism((int)(this.attributes().getSize() / (long)Preferences.instance().getInteger("connection.chunksize")) + 1);
                this.download(in, out, throttle, listener);
            }
            catch (IOException e) {
                this.error("Download failed", e);
                Object var10_10 = null;
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                return;
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    @Override
    public void symlink(String target) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("symlink:" + target));
        }
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Uploading {0}", "Status"), this.getName()));
            this.getSession().sftp().createSymlink(this.getAbsolute(), target);
            this.getParent().invalidate();
        }
        catch (IOException e) {
            this.error("Cannot create file {0}", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void upload(BandwidthThrottle throttle, StreamListener listener, boolean check) {
        block22: {
            if (this.attributes().isFile()) {
                InputStream in = null;
                OutputStream out = null;
                SFTPv3FileHandle handle = null;
                if (check) {
                    this.getSession().check();
                }
                in = this.getLocal().getInputStream();
                if (Preferences.instance().getProperty("ssh.transfer").equals(Protocol.SFTP.getIdentifier())) {
                    try {
                        SFTPv3FileAttributes attr = new SFTPv3FileAttributes();
                        if (Preferences.instance().getBoolean("queue.upload.preserveDate")) {
                            int t = (int)(this.attributes().getModificationDate() / 1000L);
                            attr.atime = t;
                            attr.mtime = t;
                        }
                        if (Preferences.instance().getBoolean("queue.upload.changePermissions")) {
                            attr.permissions = Integer.parseInt(this.attributes().getPermission().getOctalString(), 8);
                        }
                        handle = this.status().isResume() && this.exists() ? this.getSession().sftp().openFile(this.getAbsolute(), 6, attr) : this.getSession().sftp().openFile(this.getAbsolute(), 26, attr);
                    }
                    catch (SFTPException ignore) {
                        log.warn((Object)ignore.getMessage());
                        handle = this.status().isResume() && this.exists() ? this.getSession().sftp().openFile(this.getAbsolute(), 6, null) : this.getSession().sftp().openFile(this.getAbsolute(), 26, null);
                    }
                    out = new SFTPOutputStream(handle);
                    if (this.status().isResume()) {
                        long skipped = out.skip(this.status().getCurrent());
                        log.info((Object)("Skipping " + skipped + " bytes"));
                        if (skipped < this.status().getCurrent()) {
                            throw new IOResumeException("Skipped " + skipped + " bytes instead of " + this.status().getCurrent());
                        }
                    }
                } else if (Preferences.instance().getProperty("ssh.transfer").equals(Protocol.SCP.getIdentifier())) {
                    SCPClient scp = this.getSession().openScp();
                    scp.setCharset(this.getSession().getEncoding());
                    out = scp.put(this.getName(), this.getLocal().attributes().getSize(), this.getParent().getAbsolute(), "0" + this.attributes().getPermission().getOctalString());
                }
                this.getSession().sftp().setRequestParallelism((int)(this.attributes().getSize() / (long)Preferences.instance().getInteger("connection.chunksize")) + 1);
                this.upload(out, in, throttle, listener);
                Object var10_13 = null;
                try {
                    if (handle != null) {
                        this.getSession().sftp().closeFile(handle);
                    }
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((OutputStream)out);
                }
                catch (IOException e2) {
                    log.error((Object)e2.getMessage());
                }
                break block22;
                {
                    catch (IOException e) {
                        this.error("Upload failed", e);
                        Object var10_14 = null;
                        try {
                            if (handle != null) {
                                this.getSession().sftp().closeFile(handle);
                            }
                            IOUtils.closeQuietly((InputStream)in);
                            IOUtils.closeQuietly(out);
                        }
                        catch (IOException e2) {
                            log.error((Object)e2.getMessage());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    try {
                        if (handle != null) {
                            this.getSession().sftp().closeFile(handle);
                        }
                        IOUtils.closeQuietly((InputStream)in);
                        IOUtils.closeQuietly(out);
                    }
                    catch (IOException e2) {
                        log.error((Object)e2.getMessage());
                    }
                    throw throwable;
                }
            }
        }
    }

    @Override
    public void touch() {
        if (this.attributes().isFile()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Uploading {0}", "Status"), this.getName()));
                SFTPv3FileAttributes attr = new SFTPv3FileAttributes();
                Permission permission = new Permission(Preferences.instance().getInteger("queue.upload.permissions.file.default"));
                attr.permissions = Integer.parseInt(permission.getOctalString(), 8);
                this.getSession().sftp().createFile(this.getAbsolute(), attr);
                try {
                    this.writeUnixPermissionImpl(permission, false);
                }
                catch (SFTPException ignore) {
                    log.warn((Object)ignore.getMessage());
                }
                this.getParent().invalidate();
            }
            catch (IOException e) {
                this.error("Cannot create file {0}", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathFactory<SFTPSession> {
        private Factory() {
        }

        @Override
        protected Path create(SFTPSession session, String path, int type) {
            return new SFTPPath(session, path, type);
        }

        @Override
        protected Path create(SFTPSession session, String parent, String name, int type) {
            return new SFTPPath(session, parent, name, type);
        }

        @Override
        protected Path create(SFTPSession session, String parent, Local file) {
            return new SFTPPath(session, parent, file);
        }

        @Override
        protected <T> Path create(SFTPSession session, T dict) {
            return new SFTPPath(session, dict);
        }
    }
}

