/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.ErrorListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.LoginControllerFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Proxy;
import ch.cyberduck.core.ProxyFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.cloud.CloudHTTP3Session;
import ch.cyberduck.core.cloudfront.CloudFrontDistributionConfiguration;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.threading.BackgroundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3BucketLoggingStatus;
import org.jets3t.service.model.S3BucketVersioningStatus;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.model.StorageOwner;
import org.jets3t.service.model.WebsiteConfig;
import org.jets3t.service.model.cloudfront.CustomOrigin;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;
import org.jets3t.service.utils.ServiceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3Session
extends CloudHTTP3Session {
    private static Logger log = Logger.getLogger(S3Session.class);
    private RequestEntityRestStorageService S3;
    private Jets3tProperties configuration = new Jets3tProperties();
    private Map<String, S3Bucket> buckets = new HashMap<String, S3Bucket>();
    private boolean bucketLocationSupported = true;
    private List<String> storageClasses = Arrays.asList("STANDARD", "REDUCED_REDUNDANCY");
    private boolean loggingSupported = true;
    private Map<String, S3BucketLoggingStatus> loggingStatus = new HashMap<String, S3BucketLoggingStatus>();
    private boolean versioningSupported = true;
    private Map<String, S3BucketVersioningStatus> versioningStatus = new HashMap<String, S3BucketVersioningStatus>();
    private boolean requesterPaysSupported = true;
    private DistributionConfiguration cf;

    public static SessionFactory factory() {
        return new Factory();
    }

    protected S3Session(Host h) {
        super(h);
    }

    protected RequestEntityRestStorageService getClient() throws ConnectionCanceledException {
        if (null == this.S3) {
            throw new ConnectionCanceledException();
        }
        return this.S3;
    }

    protected Jets3tProperties getProperties() {
        return this.configuration;
    }

    protected void configure(String hostname) {
        log.debug((Object)("configure:" + hostname));
        if (StringUtils.isNotBlank((String)this.host.getProtocol().getDefaultHostname()) && hostname.endsWith(this.host.getProtocol().getDefaultHostname())) {
            this.configuration.setProperty("s3service.s3-endpoint", this.host.getProtocol().getDefaultHostname());
        } else {
            this.configuration.setProperty("s3service.s3-endpoint", hostname);
            this.configuration.setProperty("s3service.disable-dns-buckets", String.valueOf(true));
        }
        this.configuration.setProperty("s3service.enable-storage-classes", String.valueOf(true));
        this.configuration.setProperty("s3service.https-only", String.valueOf(this.host.getProtocol().isSecure()));
        this.configuration.setProperty("s3service.internal-error-retry-max", String.valueOf(0));
        this.configuration.setProperty("s3service.max-thread-count", String.valueOf(1));
        this.configuration.setProperty("httpclient.proxy-autodetect", String.valueOf(false));
        if (Preferences.instance().getBoolean("connection.proxy.enable")) {
            Proxy proxy = ProxyFactory.instance();
            if (this.host.getProtocol().isSecure()) {
                if (proxy.isHTTPSProxyEnabled(this.host)) {
                    this.configuration.setProperty("httpclient.proxy-host", proxy.getHTTPSProxyHost(this.host));
                    this.configuration.setProperty("httpclient.proxy-port", String.valueOf(proxy.getHTTPSProxyPort(this.host)));
                    this.configuration.setProperty("httpclient.proxy-user", null);
                    this.configuration.setProperty("httpclient.proxy-password", null);
                    if (StringUtils.isNotEmpty((String)Preferences.instance().getProperty("connection.proxy.ntlm.domain"))) {
                        this.configuration.setProperty("httpclient.proxy-domain", Preferences.instance().getProperty("connection.proxy.ntlm.domain"));
                    }
                }
            } else if (proxy.isHTTPProxyEnabled(this.host)) {
                this.configuration.setProperty("httpclient.proxy-host", proxy.getHTTPProxyHost(this.host));
                this.configuration.setProperty("httpclient.proxy-port", String.valueOf(proxy.getHTTPProxyPort(this.host)));
                this.configuration.setProperty("httpclient.proxy-user", null);
                this.configuration.setProperty("httpclient.proxy-password", null);
                if (StringUtils.isNotEmpty((String)Preferences.instance().getProperty("connection.proxy.ntlm.domain"))) {
                    this.configuration.setProperty("httpclient.proxy-domain", Preferences.instance().getProperty("connection.proxy.ntlm.domain"));
                }
            }
        }
        this.configuration.setProperty("httpclient.connection-timeout-ms", String.valueOf(this.timeout()));
        this.configuration.setProperty("httpclient.socket-timeout-ms", String.valueOf(this.timeout()));
        this.configuration.setProperty("httpclient.useragent", this.getUserAgent());
        this.configuration.setProperty("httpclient.authentication-preemptive", String.valueOf(false));
        this.configuration.setProperty("httpclient.retry-max", String.valueOf(0));
    }

    @Override
    public String getHostnameForContainer(String bucket) {
        if (this.configuration.getBoolProperty("s3service.disable-dns-buckets", false)) {
            return this.getHost().getHostname(true);
        }
        if (!ServiceUtils.isBucketNameValidDNSName((String)bucket)) {
            return this.getHost().getHostname(true);
        }
        if (this.getHost().getHostname().equals(this.getHost().getProtocol().getDefaultHostname())) {
            return bucket + "." + this.getHost().getHostname(true);
        }
        return this.getHost().getHostname(true);
    }

    protected List<S3Bucket> getBuckets(boolean reload) throws IOException, ServiceException {
        if (this.buckets.isEmpty() || reload) {
            this.buckets.clear();
            if (this.host.getCredentials().isAnonymousLogin()) {
                log.info((Object)"Anonymous cannot list buckets");
                String bucketname = this.getContainerForHostname(this.host.getHostname(true));
                if (StringUtils.isEmpty((String)bucketname)) {
                    if (StringUtils.isNotBlank((String)this.host.getDefaultPath())) {
                        Path d = PathFactory.createPath((Session)this, this.host.getDefaultPath(), 2);
                        while (!d.getParent().isRoot()) {
                            d = d.getParent();
                        }
                        bucketname = d.getName();
                    }
                    log.info((Object)("Using default path to determine bucket name:" + bucketname));
                }
                if (StringUtils.isEmpty((String)bucketname)) {
                    log.warn((Object)("No bucket name given in hostname " + this.host.getHostname()));
                    this.configure(this.host.getProtocol().getDefaultHostname());
                    bucketname = this.host.getHostname(true);
                }
                if (!this.getClient().isBucketAccessible(bucketname)) {
                    throw new IOException(Locale.localizedString("Cannot read container configuration", "Error"));
                }
                S3Bucket bucket = new S3Bucket(bucketname);
                try {
                    StorageOwner owner = this.getClient().getBucketAcl(bucketname).getOwner();
                    bucket.setOwner(owner);
                }
                catch (ServiceException e) {
                    log.warn((Object)e.getMessage());
                }
                this.buckets.put(bucketname, bucket);
            } else {
                String bucketname = this.getContainerForHostname(this.host.getHostname(true));
                if (StringUtils.isNotEmpty((String)bucketname)) {
                    if (!this.getClient().isBucketAccessible(bucketname)) {
                        throw new IOException(Locale.localizedString("Cannot read container configuration", "Error"));
                    }
                    S3Bucket bucket = new S3Bucket(bucketname);
                    try {
                        StorageOwner owner = this.getClient().getBucketAcl(bucketname).getOwner();
                        bucket.setOwner(owner);
                    }
                    catch (ServiceException e) {
                        log.warn((Object)e.getMessage());
                    }
                    this.buckets.put(bucketname, bucket);
                } else {
                    for (S3Bucket bucket : this.getClient().listAllBuckets()) {
                        this.buckets.put(bucket.getName(), bucket);
                    }
                }
            }
            if (reload) {
                this.loggingStatus.clear();
                this.versioningStatus.clear();
                this.cdn().clear();
            }
        }
        return new ArrayList<S3Bucket>(this.buckets.values());
    }

    protected S3Bucket getBucket(String bucketname) throws IOException {
        try {
            for (S3Bucket bucket : this.getBuckets(false)) {
                if (!bucket.getName().equals(bucketname)) continue;
                return bucket;
            }
        }
        catch (ServiceException e) {
            this.error("Cannot read container configuration", e);
        }
        throw new ConnectionCanceledException("Bucket not found with name:" + bucketname);
    }

    public static List<String> getAvailableLocations() {
        return Arrays.asList("US", "EU", "us-west-1", "ap-southeast-1", "ap-northeast-1");
    }

    public boolean isBucketLocationSupported() {
        return this.bucketLocationSupported;
    }

    protected void setBucketLocationSupported(boolean bucketLocationSupported) {
        this.bucketLocationSupported = bucketLocationSupported;
    }

    public String getLocation(String container) {
        if (this.isBucketLocationSupported()) {
            try {
                S3Bucket bucket = this.getBucket(container);
                if (bucket.isLocationKnown()) {
                    return bucket.getLocation();
                }
                if (this.getHost().getCredentials().isAnonymousLogin()) {
                    log.info((Object)"Anonymous cannot access bucket location");
                    return null;
                }
                this.check();
                String location = this.getClient().getBucketLocation(container);
                if (StringUtils.isBlank((String)location)) {
                    location = "US";
                }
                bucket.setLocation(location);
                return location;
            }
            catch (ServiceException e) {
                log.warn((Object)("Bucket location not supported:" + e.getMessage()));
                this.setBucketLocationSupported(false);
            }
            catch (IOException e) {
                this.error("Cannot read container configuration", e);
            }
        }
        return null;
    }

    @Override
    protected void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        this.fireConnectionWillOpenEvent();
        this.configure(this.host.getHostname());
        this.login();
        this.fireConnectionDidOpenEvent();
    }

    @Override
    protected void login(LoginController controller, Credentials credentials) throws IOException {
        try {
            this.S3 = new RequestEntityRestStorageService((ProviderCredentials)(credentials.isAnonymousLogin() ? null : new AWSCredentials(credentials.getUsername(), credentials.getPassword())));
            for (S3Bucket bucket : this.getBuckets(true)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Bucket:" + bucket));
            }
        }
        catch (ServiceException e) {
            if (this.isLoginFailure(e)) {
                this.message(Locale.localizedString("Login failed", "Credentials"));
                controller.fail(this.host.getProtocol(), credentials);
                this.login();
            }
            IOException failure = new IOException(e.getMessage());
            failure.initCause(e);
            throw failure;
        }
    }

    protected Credentials mfa(LoginController controller) throws ConnectionCanceledException {
        Credentials credentials = new Credentials(Preferences.instance().getProperty("s3.mfa.serialnumber"), null, false){

            public String getUsernamePlaceholder() {
                return Locale.localizedString("MFA Serial Number", "S3");
            }

            public String getPasswordPlaceholder() {
                return Locale.localizedString("MFA Authentication Code", "S3");
            }
        };
        controller.prompt(this.host.getProtocol(), credentials, Locale.localizedString("Provide additional login credentials", "Credentials"), Locale.localizedString("Multi-Factor Authentication", "S3"), false, false, false);
        Preferences.instance().setProperty("s3.mfa.serialnumber", credentials.getUsername());
        return credentials;
    }

    protected boolean isLoginFailure(ServiceException e) {
        if (403 == e.getResponseCode()) {
            return true;
        }
        if (null == e.getErrorCode()) {
            return false;
        }
        return e.getErrorCode().equals("InvalidAccessKeyId") || e.getErrorCode().equals("SignatureDoesNotMatch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.isConnected()) {
                this.fireConnectionWillCloseEvent();
            }
            Object var2_1 = null;
            this.S3 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.S3 = null;
            this.fireConnectionDidCloseEvent();
            throw throwable;
        }
        this.fireConnectionDidCloseEvent();
    }

    @Override
    public boolean isDownloadResumable() {
        return true;
    }

    @Override
    public boolean isUploadResumable() {
        return false;
    }

    @Override
    public boolean isAclSupported() {
        return true;
    }

    public boolean isMultipartUploadSupported() {
        return this.host.getHostname().equals(Protocol.S3_SSL.getDefaultHostname());
    }

    @Override
    public boolean isCreateFileSupported(Path workdir) {
        return !workdir.isRoot();
    }

    @Override
    public boolean isRenameSupported(Path file) {
        return !file.attributes().isVolume();
    }

    @Override
    public List<String> getSupportedStorageClasses() {
        return this.storageClasses;
    }

    private void setSupportedStorageClasses(List<String> storageClasses) {
        this.storageClasses = storageClasses;
    }

    public boolean isLoggingSupported() {
        return this.loggingSupported;
    }

    protected void setLoggingSupported(boolean loggingSupported) {
        this.loggingSupported = loggingSupported;
    }

    @Override
    public boolean isChecksumSupported() {
        return true;
    }

    public boolean isLogging(String container) {
        if (this.isLoggingSupported()) {
            if (!this.loggingStatus.containsKey(container)) {
                try {
                    if (this.getHost().getCredentials().isAnonymousLogin()) {
                        log.info((Object)"Anonymous cannot access logging status");
                        return false;
                    }
                    this.check();
                    S3BucketLoggingStatus status = this.getClient().getBucketLoggingStatus(container);
                    this.loggingStatus.put(container, status);
                }
                catch (ServiceException e) {
                    log.warn((Object)("Bucket logging not supported:" + e.getMessage()));
                    this.setLoggingSupported(false);
                }
                catch (IOException e) {
                    this.error("Cannot read container configuration", e);
                }
            }
            if (this.loggingStatus.containsKey(container)) {
                return this.loggingStatus.get(container).isLoggingEnabled();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLogging(String container, boolean enabled) {
        if (!this.isLoggingSupported()) return;
        try {
            try {
                S3BucketLoggingStatus status = new S3BucketLoggingStatus(container, null);
                if (enabled) {
                    status.setLogfilePrefix(Preferences.instance().getProperty("s3.logging.prefix"));
                }
                this.check();
                this.getClient().setBucketLoggingStatus(container, status, true);
            }
            catch (ServiceException e) {
                this.error("Cannot write file attributes", e);
                Object var5_7 = null;
                this.loggingStatus.remove(container);
                return;
            }
            catch (IOException e) {
                this.error("Cannot write file attributes", e);
                Object var5_8 = null;
                this.loggingStatus.remove(container);
                return;
            }
            Object var5_6 = null;
            this.loggingStatus.remove(container);
            return;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.loggingStatus.remove(container);
            throw throwable;
        }
    }

    public boolean isVersioningSupported() {
        return this.versioningSupported;
    }

    @Override
    public boolean isRevertSupported() {
        return this.isVersioningSupported();
    }

    protected void setVersioningSupported(boolean versioningSupported) {
        this.versioningSupported = versioningSupported;
    }

    public boolean isVersioning(String container) {
        if (this.isVersioningSupported()) {
            if (!this.versioningStatus.containsKey(container)) {
                try {
                    this.check();
                    S3BucketVersioningStatus status = this.getClient().getBucketVersioningStatus(container);
                    this.versioningStatus.put(container, status);
                }
                catch (ServiceException e) {
                    log.warn((Object)("Bucket versioning not supported:" + e.getMessage()));
                    this.setVersioningSupported(false);
                }
                catch (IOException e) {
                    this.error("Cannot read container configuration", e);
                }
            }
            if (this.versioningStatus.containsKey(container)) {
                return this.versioningStatus.get(container).isVersioningEnabled();
            }
        }
        return false;
    }

    public boolean isMultiFactorAuthentication(String container) {
        if (this.isVersioning(container)) {
            return this.versioningStatus.get(container).isMultiFactorAuthDeleteRequired();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVersioning(String container, boolean mfa, boolean versioning) {
        if (!this.isVersioningSupported()) return;
        try {
            block16: {
                try {
                    this.check();
                    if (this.isMultiFactorAuthentication(container)) {
                        LoginController c = LoginControllerFactory.instance(this);
                        Credentials auth = this.mfa(c);
                        if (versioning) {
                            if (this.isVersioning(container)) {
                                log.debug((Object)("Versioning already enabled for bucket " + container));
                            } else {
                                log.debug((Object)("Enable bucket versioning with MFA " + auth.getUsername() + " for " + container));
                                this.getClient().enableBucketVersioningWithMFA(container, auth.getUsername(), auth.getPassword());
                            }
                        } else {
                            log.debug((Object)("Suspend bucket versioning with MFA " + auth.getUsername() + " for " + container));
                            this.getClient().suspendBucketVersioningWithMFA(container, auth.getUsername(), auth.getPassword());
                        }
                        if (versioning && !mfa) {
                            log.debug((Object)("Disable MFA " + auth.getUsername() + " for " + container));
                            Credentials auth2 = this.mfa(c);
                            this.getClient().disableMFAForVersionedBucket(container, auth2.getUsername(), auth2.getPassword());
                        }
                        break block16;
                    }
                    if (versioning) {
                        if (mfa) {
                            LoginController c = LoginControllerFactory.instance(this);
                            Credentials auth = this.mfa(c);
                            log.debug((Object)("Enable bucket versioning with MFA " + auth.getUsername() + " for " + container));
                            this.getClient().enableBucketVersioningWithMFA(container, auth.getUsername(), auth.getPassword());
                            break block16;
                        }
                        if (this.isVersioning(container)) {
                            log.debug((Object)("Versioning already enabled for bucket " + container));
                            break block16;
                        } else {
                            log.debug((Object)("Enable bucket versioning for " + container));
                            this.getClient().enableBucketVersioning(container);
                        }
                        break block16;
                    }
                    log.debug((Object)("Susped bucket versioning for " + container));
                    this.getClient().suspendBucketVersioning(container);
                }
                catch (ServiceException e) {
                    this.error("Cannot write file attributes", e);
                    Object var8_12 = null;
                    this.versioningStatus.remove(container);
                    return;
                }
                catch (IOException e) {
                    this.error("Cannot write file attributes", e);
                    Object var8_13 = null;
                    this.versioningStatus.remove(container);
                    return;
                }
            }
            Object var8_11 = null;
            this.versioningStatus.remove(container);
            return;
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            this.versioningStatus.remove(container);
            throw throwable;
        }
    }

    public boolean isRequesterPaysSupported() {
        return this.requesterPaysSupported;
    }

    protected void setRequesterPaysSupported(boolean requesterPaysSupported) {
        this.requesterPaysSupported = requesterPaysSupported;
    }

    public void setRequesterPays(String container, boolean enabled) {
        if (this.isRequesterPaysSupported()) {
            try {
                this.check();
                this.getClient().setRequesterPaysBucket(container, enabled);
            }
            catch (ServiceException e) {
                this.error("Cannot write file attributes", e);
            }
            catch (IOException e) {
                this.error("Cannot write file attributes", e);
            }
        }
    }

    public boolean isRequesterPays(String container) {
        if (this.isRequesterPaysSupported()) {
            try {
                this.check();
                return this.getClient().isRequesterPaysBucket(container);
            }
            catch (ServiceException e) {
                this.error("Cannot read container configuration", e);
            }
            catch (IOException e) {
                this.error("Cannot read container configuration", e);
            }
        }
        return false;
    }

    @Override
    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        return Arrays.asList(new Acl.Role(Permission.PERMISSION_FULL_CONTROL.toString()), new Acl.Role(Permission.PERMISSION_READ.toString()), new Acl.Role(Permission.PERMISSION_WRITE.toString()), new Acl.Role(Permission.PERMISSION_READ_ACP.toString()), new Acl.Role(Permission.PERMISSION_WRITE_ACP.toString()));
    }

    @Override
    public List<Acl.User> getAvailableAclUsers() {
        ArrayList<Acl.User> users = new ArrayList<Acl.User>(Arrays.asList(new Acl.CanonicalUser(), new Acl.GroupUser(GroupGrantee.ALL_USERS.getIdentifier(), false), new Acl.EmailUser(){

            public String getPlaceholder() {
                return Locale.localizedString("Amazon Customer Email Address", "S3");
            }
        }));
        for (S3Bucket container : this.buckets.values()) {
            final StorageOwner owner = container.getOwner();
            if (null == owner) {
                log.warn((Object)("Owner not known for container " + container));
                continue;
            }
            Acl.CanonicalUser canonicalUser = new Acl.CanonicalUser(owner.getId(), owner.getDisplayName(), false){

                public String getPlaceholder() {
                    return owner.getDisplayName() + " (" + Locale.localizedString("Owner") + ")";
                }
            };
            if (users.contains(canonicalUser)) continue;
            users.add(0, canonicalUser);
        }
        return users;
    }

    @Override
    public Acl getPrivateAcl(String container) {
        for (S3Bucket bucket : this.buckets.values()) {
            if (!bucket.getName().equals(container)) continue;
            StorageOwner owner = bucket.getOwner();
            if (null == owner) {
                log.warn((Object)("Owner not known for container " + container));
                continue;
            }
            return new Acl(new Acl.CanonicalUser(owner.getId()), new Acl.Role(Permission.PERMISSION_FULL_CONTROL.toString()));
        }
        log.warn((Object)("No such container:" + container));
        return new Acl();
    }

    @Override
    public Acl getPublicAcl(String container, boolean readable, boolean writable) {
        Acl acl = this.getPrivateAcl(container);
        if (readable) {
            acl.addAll(new Acl.GroupUser(GroupGrantee.ALL_USERS.getIdentifier()), new Acl.Role(Permission.PERMISSION_READ.toString()));
        }
        if (writable) {
            acl.addAll(new Acl.GroupUser(GroupGrantee.ALL_USERS.getIdentifier()), new Acl.Role(Permission.PERMISSION_WRITE.toString()));
        }
        return acl;
    }

    private String getWebsiteEndpoint(String bucket, Distribution.Method method) {
        String location = this.getLocation(bucket);
        String endpoint = "s3-website-us-east-1.amazonaws.com";
        if ("EU".equals(location)) {
            endpoint = "s3-website-eu-west-1.amazonaws.com";
        } else if ("us-west-1".equals(location)) {
            endpoint = "s3-website-us-west-1.amazonaws.com";
        } else if ("ap-southeast-1".equals(location)) {
            endpoint = "s3-website-ap-southeast-1.amazonaws.com";
        }
        return bucket + "." + endpoint;
    }

    @Override
    public DistributionConfiguration cdn() {
        if (this.host.getHostname().equals(Protocol.S3_SSL.getDefaultHostname())) {
            if (null == this.cf) {
                this.cf = new WebsiteCloudFrontDistributionConfiguration();
            }
        } else {
            return super.cdn();
        }
        return this.cf;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebsiteCloudFrontDistributionConfiguration
    extends CloudFrontDistributionConfiguration {
        public WebsiteCloudFrontDistributionConfiguration() {
            super(LoginControllerFactory.instance(S3Session.this), S3Session.this.host.getCredentials(), new ErrorListener(){

                public void error(BackgroundException exception) {
                    S3Session.this.error(exception);
                }
            });
        }

        @Override
        public List<Distribution.Method> getMethods() {
            return Arrays.asList(Distribution.WEBSITE, Distribution.WEBSITE_CDN, Distribution.DOWNLOAD, Distribution.STREAMING);
        }

        @Override
        public String toString(Distribution.Method method) {
            if (method.equals(Distribution.WEBSITE)) {
                return method.toString();
            }
            return super.toString(method);
        }

        @Override
        public String getOrigin(Distribution.Method method, String container) {
            if (method.equals(Distribution.WEBSITE)) {
                return S3Session.this.getHostnameForContainer(container);
            }
            if (method.equals(Distribution.WEBSITE_CDN)) {
                return S3Session.this.getWebsiteEndpoint(container, method);
            }
            return super.getOrigin(method, container);
        }

        @Override
        public Distribution read(String origin, Distribution.Method method) {
            if (method.equals(Distribution.WEBSITE)) {
                String bucket = S3Session.this.getContainerForHostname(origin);
                String url = method.getProtocol() + S3Session.this.getWebsiteEndpoint(bucket, method);
                if (!((Map)this.distributionStatus.get(method)).containsKey(origin) || !((Distribution)((Map)this.distributionStatus.get(method)).get(origin)).isDeployed()) {
                    try {
                        S3Session.this.check();
                        try {
                            WebsiteConfig configuration = S3Session.this.getClient().getWebsiteConfig(bucket);
                            Distribution distribution = new Distribution(null, origin, method, configuration.isWebsiteConfigActive(), configuration.isWebsiteConfigActive(), url, Locale.localizedString("Deployed", "S3"), null, false, configuration.getIndexDocumentSuffix());
                            ((Map)this.distributionStatus.get(method)).put(origin, distribution);
                        }
                        catch (ServiceException e) {
                            String status = Locale.localizedString(e.getErrorCode());
                            if (status.equals(e.getErrorCode())) {
                                status = e.getErrorMessage();
                            }
                            Distribution distribution = new Distribution(null, origin, method, false, url, status);
                            ((Map)this.distributionStatus.get(method)).put(origin, distribution);
                        }
                    }
                    catch (IOException e) {
                        this.error("Cannot read CDN configuration", e);
                    }
                }
            }
            return super.read(origin, method);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(boolean enabled, String origin, Distribution.Method method, String[] cnames, boolean logging, String defaultRootObject) {
            if (method.equals(Distribution.WEBSITE)) {
                try {
                    block11: {
                        try {
                            S3Session.this.check();
                            StringBuilder name = new StringBuilder(Locale.localizedString("Website", "S3")).append(" ").append(method.toString());
                            if (enabled) {
                                this.message(MessageFormat.format(Locale.localizedString("Enable {0} Distribution", "Status"), name));
                            } else {
                                this.message(MessageFormat.format(Locale.localizedString("Disable {0} Distribution", "Status"), name));
                            }
                            Distribution d = (Distribution)((Map)this.distributionStatus.get(method)).get(origin);
                            String bucket = S3Session.this.getContainerForHostname(origin);
                            if (enabled) {
                                String suffix = "index.html";
                                if (StringUtils.isNotBlank((String)defaultRootObject)) {
                                    suffix = FilenameUtils.getName((String)defaultRootObject);
                                }
                                S3Session.this.getClient().setWebsiteConfig(bucket, new WebsiteConfig(suffix));
                                break block11;
                            }
                            S3Session.this.getClient().deleteWebsiteConfig(bucket);
                        }
                        catch (IOException e) {
                            this.error("Cannot write CDN configuration", e);
                            Object var12_14 = null;
                            ((Map)this.distributionStatus.get(method)).clear();
                        }
                        catch (S3ServiceException e) {
                            this.error("Cannot write CDN configuration", e);
                            Object var12_15 = null;
                            ((Map)this.distributionStatus.get(method)).clear();
                        }
                    }
                    Object var12_13 = null;
                    ((Map)this.distributionStatus.get(method)).clear();
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    ((Map)this.distributionStatus.get(method)).clear();
                    throw throwable;
                }
            } else {
                super.write(enabled, origin, method, cnames, logging, defaultRootObject);
            }
        }

        @Override
        protected CustomOrigin getCustomOriginConfiguration(Distribution.Method method, String origin) {
            if (method.equals(Distribution.WEBSITE_CDN)) {
                return new CustomOrigin(origin, CustomOrigin.OriginProtocolPolicy.HTTP_ONLY);
            }
            return super.getCustomOriginConfiguration(method, origin);
        }

        @Override
        public boolean isDefaultRootSupported(Distribution.Method method) {
            if (method.equals(Distribution.WEBSITE)) {
                return true;
            }
            return super.isDefaultRootSupported(method);
        }

        @Override
        public boolean isLoggingSupported(Distribution.Method method) {
            if (method.equals(Distribution.WEBSITE)) {
                return false;
            }
            return super.isLoggingSupported(method);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RequestEntityRestStorageService
    extends RestS3Service {
        public RequestEntityRestStorageService(ProviderCredentials credentials) throws ServiceException {
            super(credentials, S3Session.this.getUserAgent(), new CredentialsProvider(){

                public org.apache.commons.httpclient.Credentials getCredentials(AuthScheme authscheme, String hostname, int port, boolean proxy) throws CredentialsNotAvailableException {
                    log.error((Object)("Additional HTTP authentication not supported:" + authscheme.getSchemeName()));
                    throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
                }
            }, S3Session.this.getProperties(), S3Session.this.getHostConfiguration());
        }

        public void putObjectWithRequestEntityImpl(String bucketName, StorageObject object, RequestEntity requestEntity, Map<String, String> requestParams) throws ServiceException {
            super.putObjectWithRequestEntityImpl(bucketName, object, requestEntity, requestParams);
        }

        public void verifyExpectedAndActualETagValues(String expectedETag, StorageObject uploadedObject) throws ServiceException {
            super.verifyExpectedAndActualETagValues(expectedETag, uploadedObject);
        }
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new S3Session(h);
        }
    }
}

