/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.LoginControllerFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.StreamListener;
import ch.cyberduck.core.cloud.CloudPath;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.ui.DateFormatterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.VersionOrDeleteMarkersChunk;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.CanonicalGrantee;
import org.jets3t.service.acl.EmailAddressGrantee;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.model.BaseVersionOrDeleteMarker;
import org.jets3t.service.model.MultipartPart;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.S3Version;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.model.StorageOwner;
import org.jets3t.service.utils.ServiceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3Path
extends CloudPath {
    private static Logger log = Logger.getLogger(S3Path.class);
    private final S3Session session;
    protected StorageObject _details;
    private SimpleDateFormat rfc1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    private static final String METADATA_HEADER_EXPIRES = "Expires";
    public static final String METADATA_HEADER_CACHE_CONTROL = "Cache-Control";
    private static final long DEFAULT_MULTIPART_UPLOAD_THRESHOLD = 0x500000L;
    private static final int DEFAULT_MINIMUM_UPLOAD_PART_SIZE = 0x500000;
    public static final int MAXIMUM_UPLOAD_PARTS = 10000;

    public static PathFactory factory() {
        return new Factory();
    }

    protected S3Path(S3Session s, String parent, String name, int type) {
        super(parent, name, type);
        this.rfc1123.setTimeZone(TimeZone.getDefault());
        this.session = s;
    }

    protected S3Path(S3Session s, String path, int type) {
        super(path, type);
        this.rfc1123.setTimeZone(TimeZone.getDefault());
        this.session = s;
    }

    protected S3Path(S3Session s, String parent, Local file) {
        super(parent, file);
        this.rfc1123.setTimeZone(TimeZone.getDefault());
        this.session = s;
    }

    protected <T> S3Path(S3Session s, T dict) {
        super(dict);
        this.rfc1123.setTimeZone(TimeZone.getDefault());
        this.session = s;
    }

    @Override
    public S3Session getSession() {
        return this.session;
    }

    protected StorageObject getDetails() throws IOException, ServiceException {
        String container = this.getContainerName();
        if (null == this._details || !this._details.isMetadataComplete()) {
            try {
                this._details = this.attributes().isDuplicate() ? this.getSession().getClient().getVersionedObjectDetails(this.attributes().getVersionId(), container, this.getKey()) : this.getSession().getClient().getObjectDetails(container, this.getKey());
            }
            catch (ServiceException e) {
                log.warn((Object)("Cannot read object details:" + e.getMessage()));
            }
        }
        if (null == this._details) {
            log.warn((Object)"Cannot read object details.");
            S3Object object = new S3Object(this.getKey());
            object.setBucketName(this.getContainerName());
            return object;
        }
        return this._details;
    }

    @Override
    public void revert() {
        if (this.attributes().isFile()) {
            try {
                S3Object destination = new S3Object(this.getKey());
                destination.setStorageClass(this.attributes().getStorageClass());
                if (Acl.EMPTY.equals(this.attributes().getAcl())) {
                    this.readAcl();
                }
                destination.setAcl(this.convert(this.attributes().getAcl()));
                this.getSession().getClient().copyVersionedObject(this.attributes().getVersionId(), this.getContainerName(), this.getKey(), this.getContainerName(), destination, false);
                this.getParent().invalidate();
            }
            catch (ServiceException e) {
                this.error("Cannot revert file", e);
            }
            catch (IOException e) {
                this.error("Cannot revert file", e);
            }
        }
    }

    @Override
    public void readAcl() {
        try {
            Credentials credentials = this.getSession().getHost().getCredentials();
            if (credentials.isAnonymousLogin()) {
                return;
            }
            String container = this.getContainerName();
            if (this.isContainer()) {
                this.attributes().setAcl(this.convert(this.getSession().getClient().getBucketAcl(container)));
            } else if (this.attributes().isFile() || this.attributes().isPlaceholder()) {
                AccessControlList list = this.getSession().isVersioning(container) ? this.getSession().getClient().getVersionedObjectAcl(this.attributes().getVersionId(), container, this.getKey()) : this.getSession().getClient().getObjectAcl(container, this.getKey());
                this.attributes().setAcl(this.convert(list));
            }
        }
        catch (ServiceException e) {
            this.error("Cannot read file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    protected Acl convert(AccessControlList list) {
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)list.toXml());
            }
            catch (ServiceException e) {
                log.error((Object)e.getMessage());
            }
        }
        Acl acl = new Acl();
        for (GrantAndPermission grant : list.getGrantAndPermissions()) {
            Acl.Role role = new Acl.Role(grant.getPermission().toString());
            if (grant.getGrantee() instanceof CanonicalGrantee) {
                acl.addAll(new Acl.CanonicalUser(grant.getGrantee().getIdentifier(), ((CanonicalGrantee)grant.getGrantee()).getDisplayName(), false), role);
                continue;
            }
            if (grant.getGrantee() instanceof EmailAddressGrantee) {
                acl.addAll(new Acl.EmailUser(grant.getGrantee().getIdentifier()), role);
                continue;
            }
            if (!(grant.getGrantee() instanceof GroupGrantee)) continue;
            acl.addAll(new Acl.GroupUser(grant.getGrantee().getIdentifier()), role);
        }
        return acl;
    }

    public void setExpiration(Date expiration) {
        try {
            this.getSession().check();
            StorageObject target = this.getDetails();
            target.addMetadata(METADATA_HEADER_EXPIRES, this.rfc1123.format(expiration));
            this.getSession().getClient().updateObjectMetadata(this.getContainerName(), target);
        }
        catch (ServiceException e) {
            this.error("Cannot write file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot write file attributes", e);
        }
    }

    public void setCacheControl(String maxage) {
        try {
            this.getSession().check();
            StorageObject target = this.getDetails();
            if (StringUtils.isEmpty((String)maxage)) {
                target.removeMetadata(METADATA_HEADER_CACHE_CONTROL);
            } else {
                target.addMetadata(METADATA_HEADER_CACHE_CONTROL, maxage);
            }
            this.getSession().getClient().updateObjectMetadata(this.getContainerName(), target);
        }
        catch (ServiceException e) {
            this.error("Cannot write file attributes", e);
        }
        catch (IOException e) {
            this.error("Cannot write file attributes", e);
        }
    }

    @Override
    public void readMetadata() {
        if (this.attributes().isFile() || this.attributes().isPlaceholder()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Reading metadata of {0}", "Status"), this.getName()));
                StorageObject target = this.getDetails();
                HashMap<String, String> metadata = new HashMap<String, String>();
                Map source = target.getModifiableMetadata();
                for (String key : source.keySet()) {
                    metadata.put(key, source.get(key).toString());
                }
                this.attributes().setMetadata(metadata);
            }
            catch (ServiceException e) {
                this.error("Cannot read file attributes", e);
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMetadata(Map<String, String> meta) {
        block7: {
            if (this.attributes().isFile() || this.attributes().isPlaceholder()) {
                try {
                    try {
                        this.getSession().check();
                        this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Writing metadata of {0}", "Status"), this.getName()));
                        StorageObject target = this.getDetails();
                        target.replaceAllMetadata(new HashMap<String, String>(meta));
                        if (Acl.EMPTY.equals(this.attributes().getAcl())) {
                            this.readAcl();
                        }
                        target.setAcl(this.convert(this.attributes().getAcl()));
                        this.getSession().getClient().updateObjectMetadata(this.getContainerName(), target);
                        target.setMetadataComplete(false);
                    }
                    catch (ServiceException e) {
                        this.error("Cannot write file attributes", e);
                        Object var4_6 = null;
                        this.attributes().clear(false, false, false, true);
                        break block7;
                    }
                    catch (IOException e) {
                        this.error("Cannot write file attributes", e);
                        Object var4_7 = null;
                        this.attributes().clear(false, false, false, true);
                    }
                    Object var4_5 = null;
                    this.attributes().clear(false, false, false, true);
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    this.attributes().clear(false, false, false, true);
                    throw throwable;
                }
            }
        }
    }

    @Override
    public void readChecksum() {
        if (this.attributes().isFile()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Compute MD5 hash of {0}", "Status"), this.getName()));
                StorageObject details = this.getDetails();
                if (StringUtils.isNotEmpty((String)details.getMd5HashAsHex())) {
                    this.attributes().setChecksum(details.getMd5HashAsHex());
                } else {
                    log.debug((Object)("Setting ETag Header as checksum for:" + this.toString()));
                    this.attributes().setChecksum(details.getETag());
                }
            }
            catch (ServiceException e) {
                this.error("Cannot read file attributes", e);
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    @Override
    public void readSize() {
        if (this.attributes().isFile()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Getting size of {0}", "Status"), this.getName()));
                StorageObject details = this.getDetails();
                this.attributes().setSize(details.getContentLength());
            }
            catch (ServiceException e) {
                this.error("Cannot read file attributes", e);
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    @Override
    public void readTimestamp() {
        if (this.attributes().isFile()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Getting timestamp of {0}", "Status"), this.getName()));
                StorageObject details = this.getDetails();
                this.attributes().setModificationDate(details.getLastModifiedDate().getTime());
            }
            catch (ServiceException e) {
                this.error("Cannot read file attributes", e);
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void download(BandwidthThrottle throttle, StreamListener listener, boolean check) {
        if (!this.attributes().isFile()) return;
        OutputStream out = null;
        InputStream in = null;
        try {
            try {
                if (check) {
                    this.getSession().check();
                }
                in = this.attributes().isDuplicate() ? this.getSession().getClient().getVersionedObject(this.attributes().getVersionId(), this.getContainerName(), this.getKey(), null, null, null, null, this.status().isResume() ? Long.valueOf(this.status().getCurrent()) : null, null).getDataInputStream() : this.getSession().getClient().getObject(this.getContainerName(), this.getKey(), null, null, null, null, this.status().isResume() ? Long.valueOf(this.status().getCurrent()) : null, null).getDataInputStream();
                out = this.getLocal().getOutputStream(this.status().isResume());
                this.download(in, out, throttle, listener);
            }
            catch (ServiceException e) {
                this.error("Download failed", e);
                Object var8_7 = null;
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                return;
            }
            catch (IOException e) {
                this.error("Download failed", e);
                Object var8_8 = null;
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                return;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    @Override
    protected void upload(BandwidthThrottle throttle, StreamListener listener, boolean check) {
        block33: {
            try {
                if (!this.attributes().isFile()) break block33;
                if (check) {
                    this.getSession().check();
                }
                S3Object object = new S3Object(this.getKey());
                object.setContentType(this.getLocal().getMimeType());
                if (Preferences.instance().getBoolean("s3.upload.metadata.md5")) {
                    try {
                        this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Compute MD5 hash of {0}", "Status"), this.getName()));
                        object.setMd5Hash(ServiceUtils.computeMD5Hash((InputStream)this.getLocal().getInputStream()));
                    }
                    catch (NoSuchAlgorithmException e) {
                        log.error((Object)e.getMessage());
                    }
                }
                Acl acl = Acl.EMPTY;
                if (this.exists()) {
                    if (this.attributes().getAcl().equals(Acl.EMPTY)) {
                        this.readAcl();
                    }
                    acl = this.attributes().getAcl();
                } else if (Preferences.instance().getBoolean("queue.upload.changePermissions")) {
                    Permission perm = Permission.EMPTY;
                    if (Preferences.instance().getBoolean("queue.upload.permissions.useDefault")) {
                        if (this.attributes().isFile()) {
                            perm = new Permission(Preferences.instance().getInteger("queue.upload.permissions.file.default"));
                        }
                        if (this.attributes().isDirectory()) {
                            perm = new Permission(Preferences.instance().getInteger("queue.upload.permissions.folder.default"));
                        }
                    } else if (this.getLocal().exists()) {
                        perm = this.getLocal().attributes().getPermission();
                    }
                    if (perm.equals(Permission.EMPTY)) {
                        log.debug((Object)("Skip writing empty permissions for:" + this.toString()));
                    } else {
                        acl = this.getSession().getPublicAcl(this.getContainerName(), perm.getOtherPermissions()[0], perm.getOtherPermissions()[1]);
                    }
                }
                if (Acl.EMPTY.equals(acl)) {
                    object.setAcl(AccessControlList.REST_CANNED_PRIVATE);
                } else if (acl.equals(this.getSession().getPrivateAcl(this.getContainerName()))) {
                    object.setAcl(AccessControlList.REST_CANNED_PRIVATE);
                } else if (acl.equals(this.getSession().getPublicAcl(this.getContainerName(), true, false))) {
                    object.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
                } else if (acl.equals(this.getSession().getPublicAcl(this.getContainerName(), true, true))) {
                    object.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ_WRITE);
                } else {
                    object.setAcl(this.convert(acl));
                }
                object.setStorageClass(Preferences.instance().getProperty("s3.storage.class"));
                for (String m : Preferences.instance().getList("s3.metadata.default")) {
                    if (StringUtils.isBlank((String)m)) {
                        log.warn((Object)("Invalid header " + m));
                        continue;
                    }
                    if (!m.contains("=")) {
                        log.warn((Object)("Invalid header " + m));
                        continue;
                    }
                    int split = m.indexOf(61);
                    String name = m.substring(0, split);
                    if (StringUtils.isBlank((String)name)) {
                        log.warn((Object)("Missing key in " + m));
                        continue;
                    }
                    String value = m.substring(split + 1);
                    if (StringUtils.isEmpty((String)value)) {
                        log.warn((Object)("Missing value in " + m));
                        continue;
                    }
                    object.addMetadata(name, value);
                }
                this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Uploading {0}", "Status"), this.getName()));
                if (this.getSession().isMultipartUploadSupported() && this.getLocal().attributes().getSize() > 0x500000L) {
                    this.uploadMultipart(throttle, listener, object);
                } else {
                    this.status().setResume(false);
                    this.uploadSingle(throttle, listener, object);
                }
            }
            catch (ServiceException e) {
                this.status().setComplete(false);
                this.error("Upload failed", e);
            }
            catch (IOException e) {
                this.error("Upload failed", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadSingle(final BandwidthThrottle throttle, final StreamListener listener, S3Object object) throws IOException, ServiceException {
        InputStream in;
        MessageDigest digest = null;
        if (!Preferences.instance().getBoolean("s3.upload.metadata.md5")) {
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)e.getMessage());
            }
        }
        if (null == digest) {
            log.warn((Object)"MD5 calculation disabled");
            in = this.getLocal().getInputStream();
        } else {
            in = new DigestInputStream(this.getLocal().getInputStream(), digest);
        }
        try {
            this.getSession().getClient().putObjectWithRequestEntityImpl(this.getContainerName(), (StorageObject)object, (RequestEntity)new InputStreamRequestEntity(in, this.getLocal().attributes().getSize() - this.status().getCurrent(), this.getLocal().getMimeType()){

                public void writeRequest(OutputStream out) throws IOException {
                    S3Path.this.upload(out, in, throttle, listener);
                }
            }, Collections.<String, String>emptyMap());
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            IOUtils.closeQuietly((InputStream)in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        if (null != digest) {
            this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Compute MD5 hash of {0}", "Status"), this.getName()));
            String hexMD5 = ServiceUtils.toHex((byte[])digest.digest());
            this.getSession().getClient().verifyExpectedAndActualETagValues(hexMD5, (StorageObject)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void uploadMultipart(BandwidthThrottle throttle, StreamListener listener, S3Object object) throws IOException, ServiceException {
        List completed;
        ThreadFactory threadFactory = new ThreadFactory(){
            private int threadCount = 1;

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("multipart-" + this.threadCount++);
                return thread;
            }
        };
        MultipartUpload multipart = null;
        if (this.status().isResume()) {
            List uploads = this.getSession().getClient().multipartListUploads(this.getContainerName());
            for (MultipartUpload upload : uploads) {
                if (!upload.getBucketName().equals(this.getContainerName()) || !upload.getObjectKey().equals(this.getKey())) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Resume multipart upload:" + upload));
                }
                multipart = upload;
                break;
            }
        }
        if (null == multipart) {
            log.info((Object)"No pending multipart upload found");
            this.status().setResume(false);
            Map metadata = object.getModifiableMetadata();
            metadata.put(this.getSession().getClient().getRestHeaderPrefix() + "storage-class", Preferences.instance().getProperty("s3.storage.class"));
            multipart = this.getSession().getClient().multipartStartUpload(this.getContainerName(), this.getKey(), metadata);
        }
        if (this.status().isResume()) {
            log.info((Object)("List completed parts of " + multipart.getUploadId()));
            completed = this.getSession().getClient().multipartListParts(multipart);
        } else {
            completed = new ArrayList();
        }
        ExecutorService pool = Executors.newFixedThreadPool(Preferences.instance().getInteger("s3.upload.concurency"), threadFactory);
        try {
            ArrayList<Future<MultipartPart>> parts = new ArrayList<Future<MultipartPart>>();
            long defaultPartSize = Math.max(this.getLocal().attributes().getSize() / 10000L, 0x500000L);
            long remaining = this.getLocal().attributes().getSize();
            long marker = 0L;
            int partNumber = 1;
            while (remaining > 0L) {
                boolean bl = false;
                if (this.status().isResume()) {
                    log.info((Object)("Determine if part " + partNumber + " can be skipped"));
                    for (MultipartPart c : completed) {
                        if (!c.getPartNumber().equals(partNumber)) continue;
                        log.info((Object)("Skip completed part number " + partNumber));
                        listener.bytesSent(c.getSize());
                        bl = true;
                        break;
                    }
                }
                long length = Math.min(defaultPartSize, remaining);
                if (!bl) {
                    parts.add(this.submitPart(throttle, listener, multipart, pool, partNumber, marker, length));
                }
                remaining -= length;
                marker += length;
                ++partNumber;
            }
            for (Future future : parts) {
                try {
                    completed.add(future.get());
                }
                catch (InterruptedException e) {
                    log.error((Object)("Part upload failed:" + e.getMessage()));
                    pool.shutdown();
                    throw new ConnectionCanceledException(e.getMessage());
                }
                catch (ExecutionException e) {
                    log.warn((Object)("Part upload failed:" + e.getMessage()));
                    pool.shutdown();
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (!(e.getCause() instanceof IOException)) throw new ConnectionCanceledException(e.getMessage());
                    throw (IOException)e.getCause();
                }
            }
            if (this.status().isComplete()) {
                this.getSession().getClient().multipartCompleteUpload(multipart, completed);
            }
            Object var20_22 = null;
            if (this.status().isComplete()) return;
        }
        catch (Throwable throwable) {
            Object var20_23 = null;
            if (this.status().isComplete()) throw throwable;
            log.info((Object)("Cancel multipart upload:" + multipart.getUploadId()));
            this.getSession().getClient().multipartAbortUpload(multipart);
            throw throwable;
        }
        log.info((Object)("Cancel multipart upload:" + multipart.getUploadId()));
        this.getSession().getClient().multipartAbortUpload(multipart);
    }

    private Future<MultipartPart> submitPart(final BandwidthThrottle throttle, final StreamListener listener, final MultipartUpload multipart, ExecutorService pool, final int partNumber, final long offset, final long length) throws ConnectionCanceledException {
        if (pool.isShutdown()) {
            throw new ConnectionCanceledException();
        }
        log.info((Object)("Submit part to queue:" + partNumber));
        return pool.submit(new Callable<MultipartPart>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MultipartPart call() throws IOException, ServiceException {
                InputStream in;
                HashMap<String, String> requestParameters = new HashMap<String, String>();
                requestParameters.put("uploadId", multipart.getUploadId());
                requestParameters.put("partNumber", String.valueOf(partNumber));
                MessageDigest digest = null;
                if (!Preferences.instance().getBoolean("s3.upload.metadata.md5")) {
                    try {
                        digest = MessageDigest.getInstance("MD5");
                    }
                    catch (NoSuchAlgorithmException e) {
                        log.error((Object)e.getMessage());
                    }
                }
                if (null == digest) {
                    log.warn((Object)"MD5 calculation disabled");
                    in = S3Path.this.getLocal().getInputStream();
                } else {
                    in = new DigestInputStream(S3Path.this.getLocal().getInputStream(), digest);
                }
                S3Object part = new S3Object(S3Path.this.getKey());
                try {
                    S3Path.this.getSession().getClient().putObjectWithRequestEntityImpl(S3Path.this.getContainerName(), (StorageObject)part, (RequestEntity)new InputStreamRequestEntity(in, length, S3Path.this.getLocal().getMimeType()){

                        public void writeRequest(OutputStream out) throws IOException {
                            S3Path.this.upload(out, in, throttle, listener, offset, length);
                        }
                    }, requestParameters);
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    IOUtils.closeQuietly((InputStream)in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                if (null != digest) {
                    String hexMD5 = ServiceUtils.toHex((byte[])digest.digest());
                    S3Path.this.getSession().getClient().verifyExpectedAndActualETagValues(hexMD5, (StorageObject)part);
                }
                return new MultipartPart(Integer.valueOf(partNumber), part.getLastModifiedDate(), part.getETag(), Long.valueOf(part.getContentLength()));
            }
        });
    }

    @Override
    public AttributedList<Path> list(AttributedList<Path> children) {
        block13: {
            if (this.attributes().isDirectory()) {
                try {
                    this.getSession().check();
                    this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Listing directory {0}", "Status"), this.getName()));
                    if (this.isRoot()) {
                        for (S3Bucket bucket : this.getSession().getBuckets(this.cache().get(this.getReference()).attributes().isInvalid())) {
                            Path p = PathFactory.createPath(this.getSession(), this.getAbsolute(), bucket.getName(), 10);
                            if (null != bucket.getOwner()) {
                                p.attributes().setOwner(bucket.getOwner().getDisplayName());
                                p.attributes().setGroup(bucket.getOwner().getId());
                            }
                            if (null != bucket.getCreationDate()) {
                                p.attributes().setCreationDate(bucket.getCreationDate().getTime());
                            }
                            children.add(p);
                        }
                    } else {
                        String container = this.getContainerName();
                        String prefix = "";
                        if (!this.isContainer()) {
                            prefix = this.getKey() + String.valueOf('/');
                        }
                        String delimiter = String.valueOf('/');
                        children.addAll(this.listObjects(container, prefix, delimiter));
                        if (Preferences.instance().getBoolean("s3.revisions.enable") && this.getSession().isVersioning(container)) {
                            String priorLastKey = null;
                            String priorLastVersionId = null;
                            do {
                                VersionOrDeleteMarkersChunk chunk = this.getSession().getClient().listVersionedObjectsChunked(container, prefix, delimiter, Preferences.instance().getInteger("s3.listing.chunksize"), priorLastKey, priorLastVersionId, true);
                                children.addAll(this.listVersions(container, Arrays.asList(chunk.getItems())));
                            } while (priorLastKey != null);
                        }
                    }
                    this.getSession().setWorkdir(this);
                }
                catch (ServiceException e) {
                    log.warn((Object)("Listing directory failed:" + e.getMessage()));
                    children.attributes().setReadable(false);
                    if (this.cache().isEmpty()) {
                        this.error(e.getMessage(), e);
                    }
                }
                catch (IOException e) {
                    log.warn((Object)("Listing directory failed:" + e.getMessage()));
                    children.attributes().setReadable(false);
                    if (!this.cache().isEmpty()) break block13;
                    this.error(e.getMessage(), e);
                }
            }
        }
        return children;
    }

    protected AttributedList<Path> listObjects(String bucket, String prefix, String delimiter) throws IOException, ServiceException {
        StorageObjectsChunk chunk;
        AttributedList<Path> children = new AttributedList<Path>();
        String priorLastKey = null;
        do {
            String[] prefixes;
            StorageObject[] objects;
            chunk = this.getSession().getClient().listObjectsChunked(bucket, prefix, delimiter, Preferences.instance().getInteger("s3.listing.chunksize"), priorLastKey);
            for (StorageObject object : objects = chunk.getObjects()) {
                S3Path p = (S3Path)PathFactory.createPath(this.getSession(), bucket, object.getKey(), 1);
                p.setParent(this);
                p.attributes().setSize(object.getContentLength());
                p.attributes().setModificationDate(object.getLastModifiedDate().getTime());
                p.attributes().setOwner(this.getContainer().attributes().getOwner());
                if (object.isDirectoryPlaceholder()) {
                    p.attributes().setType(2);
                    p.attributes().setPlaceholder(true);
                } else if (0L == object.getContentLength() && "application/x-directory".equals(p.getDetails().getContentType())) {
                    p.attributes().setType(2);
                    p.attributes().setPlaceholder(true);
                }
                Object etag = object.getMetadataMap().get("ETag");
                if (null != etag) {
                    String s = etag.toString().replaceAll("\"", "");
                    p.attributes().setChecksum(s);
                    if (s.equals("d66759af42f282e1ba19144df2d405d0")) {
                        p.attributes().setType(2);
                        p.attributes().setPlaceholder(true);
                    }
                }
                p.attributes().setStorageClass(object.getStorageClass());
                if (object instanceof S3Object) {
                    p.attributes().setVersionId(((S3Object)object).getVersionId());
                }
                children.add(p);
            }
            for (String common : prefixes = chunk.getCommonPrefixes()) {
                if (common.equals(String.valueOf('/'))) {
                    log.warn((Object)("Skipping prefix " + common));
                    continue;
                }
                Path p = PathFactory.createPath(this.getSession(), bucket, common, 2);
                p.setParent(this);
                if (children.contains(p.getReference())) continue;
                p.attributes().setOwner(this.getContainer().attributes().getOwner());
                p.attributes().setPlaceholder(false);
                children.add(p);
            }
        } while ((priorLastKey = chunk.getPriorLastKey()) != null);
        return children;
    }

    private List<Path> listVersions(String bucket, List<BaseVersionOrDeleteMarker> versionOrDeleteMarkers) throws IOException, ServiceException {
        Collections.sort(versionOrDeleteMarkers, new Comparator<BaseVersionOrDeleteMarker>(){

            @Override
            public int compare(BaseVersionOrDeleteMarker o1, BaseVersionOrDeleteMarker o2) {
                return o1.getLastModified().compareTo(o2.getLastModified());
            }
        });
        ArrayList<Path> versions = new ArrayList<Path>();
        int i = 0;
        for (BaseVersionOrDeleteMarker object : versionOrDeleteMarkers) {
            StorageObject details;
            if (object.isLatest() || object.isDeleteMarker()) continue;
            S3Path path = (S3Path)PathFactory.createPath(this.getSession(), bucket, object.getKey(), 1);
            path.setParent(this);
            S3Version version = (S3Version)object;
            path.attributes().setVersionId(version.getVersionId());
            path.attributes().setRevision(++i);
            path.attributes().setDuplicate(true);
            if (0L == version.getSize() && (details = path.getDetails()).isDirectoryPlaceholder()) continue;
            path.attributes().setSize(version.getSize());
            path.attributes().setModificationDate(version.getLastModified().getTime());
            path.attributes().setOwner(this.getContainer().attributes().getOwner());
            path.attributes().setStorageClass(version.getStorageClass());
            versions.add(path);
        }
        return versions;
    }

    @Override
    public void mkdir() {
        if (this.attributes().isDirectory()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Making directory {0}", "Status"), this.getName()));
                if (this.isContainer()) {
                    if (!ServiceUtils.isBucketNameValidDNSName((String)this.getName())) {
                        throw new ServiceException(ch.cyberduck.core.i18n.Locale.localizedString("Bucket name is not DNS compatible", "S3"));
                    }
                    this.getSession().getClient().createBucket(this.getContainerName(), Preferences.instance().getProperty("s3.location"), AccessControlList.REST_CANNED_PUBLIC_READ);
                } else {
                    S3Object object = new S3Object(this.getKey() + '/');
                    object.setBucketName(this.getContainerName());
                    AccessControlList acl = AccessControlList.REST_CANNED_PRIVATE;
                    object.setAcl(acl);
                    object.setContentLength(0L);
                    object.setContentType("application/x-directory");
                    this.getSession().getClient().putObject(this.getContainerName(), object);
                }
                this.cache().put(this.getReference(), AttributedList.emptyList());
                this.getParent().invalidate();
            }
            catch (ServiceException e) {
                this.error("Cannot create folder {0}", e);
            }
            catch (IOException e) {
                this.error("Cannot create folder {0}", e);
            }
        }
    }

    @Override
    public void writeAcl(Acl acl, boolean recursive) {
        try {
            AccessControlList list = this.convert(acl);
            this.writeAcl(list, recursive);
        }
        catch (ServiceException e) {
            this.error("Cannot change permissions", e);
        }
        catch (IOException e) {
            this.error("Cannot change permissions", e);
        }
    }

    protected AccessControlList convert(Acl acl) throws IOException {
        AccessControlList list = new AccessControlList();
        StorageOwner owner = this.getSession().getBucket(this.getContainerName()).getOwner();
        list.setOwner(owner);
        for (Acl.UserAndRole userAndRole : acl.asList()) {
            if (!userAndRole.isValid()) continue;
            if (userAndRole.getUser() instanceof Acl.EmailUser) {
                list.grantPermission((GranteeInterface)new EmailAddressGrantee(userAndRole.getUser().getIdentifier()), org.jets3t.service.acl.Permission.parsePermission((String)userAndRole.getRole().getName()));
                continue;
            }
            if (userAndRole.getUser() instanceof Acl.GroupUser) {
                list.grantPermission((GranteeInterface)new GroupGrantee(userAndRole.getUser().getIdentifier()), org.jets3t.service.acl.Permission.parsePermission((String)userAndRole.getRole().getName()));
                continue;
            }
            list.grantPermission((GranteeInterface)new CanonicalGrantee(userAndRole.getUser().getIdentifier()), org.jets3t.service.acl.Permission.parsePermission((String)userAndRole.getRole().getName()));
        }
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)list.toXml());
            }
            catch (ServiceException e) {
                log.error((Object)e.getMessage());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeAcl(AccessControlList acl, boolean recursive) throws IOException, ServiceException {
        try {
            if (null == acl.getOwner()) {
                log.warn((Object)"Owner unknown. Cannot update ACL");
                Object var6_3 = null;
                this.attributes().clear(false, false, true, false);
                return;
            }
            if (this.isContainer()) {
                this.getSession().getClient().putBucketAcl(this.getContainerName(), acl);
            } else {
                if (this.attributes().isFile() || this.attributes().isPlaceholder()) {
                    this.getSession().getClient().putObjectAcl(this.getContainerName(), this.getKey(), acl);
                }
                if (this.attributes().isDirectory() && recursive) {
                    for (AbstractPath child : this.children()) {
                        if (!this.getSession().isConnected()) break;
                        ((S3Path)child).writeAcl(acl, recursive);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.attributes().clear(false, false, true, false);
            throw throwable;
        }
        Object var6_4 = null;
        this.attributes().clear(false, false, true, false);
    }

    protected AccessControlList getAccessControlList(Permission permission) throws IOException {
        AccessControlList acl = new AccessControlList();
        StorageOwner owner = this.getSession().getBucket(this.getContainerName()).getOwner();
        acl.setOwner(owner);
        CanonicalGrantee grantee = new CanonicalGrantee(owner.getId());
        if (permission.getOwnerPermissions()[0]) {
            acl.grantPermission((GranteeInterface)grantee, org.jets3t.service.acl.Permission.PERMISSION_READ);
        }
        if (permission.getOwnerPermissions()[1] && this.isContainer()) {
            acl.grantPermission((GranteeInterface)grantee, org.jets3t.service.acl.Permission.PERMISSION_WRITE);
        }
        if (permission.getOtherPermissions()[0]) {
            acl.grantPermission((GranteeInterface)GroupGrantee.ALL_USERS, org.jets3t.service.acl.Permission.PERMISSION_READ);
        }
        if (permission.getOtherPermissions()[1] && this.isContainer()) {
            acl.grantPermission((GranteeInterface)GroupGrantee.ALL_USERS, org.jets3t.service.acl.Permission.PERMISSION_WRITE);
        }
        return acl;
    }

    @Override
    public void delete() {
        try {
            this.getSession().check();
            String container = this.getContainerName();
            if (this.attributes().isFile()) {
                this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                this.delete(container, this.getKey(), this.attributes().getVersionId());
            } else if (this.attributes().isDirectory()) {
                for (AbstractPath child : this.children()) {
                    if (!this.getSession().isConnected()) break;
                    child.delete();
                }
                this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Deleting {0}", "Status"), this.getName()));
                if (this.isContainer()) {
                    this.getSession().getClient().deleteBucket(container);
                } else {
                    try {
                        this.delete(container, this.getKey() + '/', this.attributes().getVersionId());
                        this.delete(container, this.getKey(), this.attributes().getVersionId());
                    }
                    catch (ServiceException e) {
                        log.warn((Object)("Delete failed:" + e.getMessage()));
                    }
                }
            }
            this.getParent().invalidate();
        }
        catch (ServiceException e) {
            this.error("Cannot delete {0}", e);
        }
        catch (IOException e) {
            this.error("Cannot delete {0}", e);
        }
    }

    private void delete(String container, String key, String version) throws ConnectionCanceledException, ServiceException {
        if (StringUtils.isNotEmpty((String)version)) {
            if (this.getSession().isMultiFactorAuthentication(container)) {
                LoginController c = LoginControllerFactory.instance(this.getSession());
                Credentials credentials = this.getSession().mfa(c);
                this.getSession().getClient().deleteVersionedObjectWithMFA(version, credentials.getUsername(), credentials.getPassword(), container, key);
            } else {
                this.getSession().getClient().deleteVersionedObject(version, container, key);
            }
        } else {
            this.getSession().getClient().deleteObject(this.getContainerName(), key);
        }
    }

    @Override
    public void rename(AbstractPath renamed) {
        block8: {
            try {
                if (this.attributes().isVolume()) {
                    log.warn((Object)"Renaming buckets is not currently supported by S3");
                    return;
                }
                if (this.attributes().isFile() || this.attributes().isPlaceholder()) {
                    this.getSession().check();
                    this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Renaming {0} to {1}", "Status"), this.getName(), renamed));
                    S3Object destination = new S3Object(((S3Path)renamed).getKey());
                    destination.setStorageClass(this.attributes().getStorageClass());
                    if (Acl.EMPTY.equals(this.attributes().getAcl())) {
                        this.readAcl();
                    }
                    destination.setAcl(this.convert(this.attributes().getAcl()));
                    this.getSession().getClient().moveObject(this.getContainerName(), this.getKey(), ((S3Path)renamed).getContainerName(), (StorageObject)destination, false);
                    renamed.getParent().invalidate();
                    this.getParent().invalidate();
                }
                if (!this.attributes().isDirectory()) break block8;
                for (AbstractPath i : this.children()) {
                    if (this.getSession().isConnected()) {
                        i.rename(PathFactory.createPath(this.getSession(), renamed.getAbsolute(), i.getName(), i.attributes().getType()));
                        continue;
                    }
                    break;
                }
            }
            catch (ServiceException e) {
                this.error("Cannot rename {0}", e);
            }
            catch (IOException e) {
                this.error("Cannot rename {0}", e);
            }
        }
    }

    @Override
    public void copy(AbstractPath copy) {
        if (((Path)copy).getSession().equals(this.getSession())) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Copying {0} to {1}", "Status"), this.getName(), copy));
                if (this.attributes().isFile()) {
                    S3Object destination = new S3Object(((S3Path)copy).getKey());
                    destination.setStorageClass(this.attributes().getStorageClass());
                    if (Acl.EMPTY.equals(this.attributes().getAcl())) {
                        this.readAcl();
                    }
                    destination.setAcl(this.convert(this.attributes().getAcl()));
                    this.getSession().getClient().copyObject(this.getContainerName(), this.getKey(), ((S3Path)copy).getContainerName(), (StorageObject)destination, false);
                } else if (this.attributes().isDirectory()) {
                    for (AbstractPath i : this.children()) {
                        if (!this.getSession().isConnected()) break;
                        S3Path destination = (S3Path)PathFactory.createPath(this.getSession(), copy.getAbsolute(), i.getName(), i.attributes().getType());
                        ((S3Path)i).attributes().setStorageClass(this.attributes().getStorageClass());
                        i.copy(destination);
                    }
                }
                copy.getParent().invalidate();
            }
            catch (ServiceException e) {
                this.error("Cannot copy {0}");
            }
            catch (IOException e) {
                this.error("Cannot copy {0}");
            }
        } else {
            super.copy(copy);
        }
    }

    @Override
    public String toURL() {
        return this.toURL(this.getHost().getProtocol().getScheme());
    }

    @Override
    public String toHttpURL() {
        return this.toURL(Protocol.S3.getScheme());
    }

    public String toURL(String scheme) {
        StringBuilder url = new StringBuilder(scheme);
        url.append("://");
        if (this.isRoot()) {
            url.append(this.getHost().getHostname());
        } else {
            String container = this.getContainerName();
            String hostname = this.getSession().getHostnameForContainer(container);
            if (hostname.startsWith(container)) {
                url.append(hostname);
                if (!this.isContainer()) {
                    url.append(S3Path.encode(this.getKey()));
                }
            } else {
                url.append(this.getSession().getHost().getHostname());
                url.append(S3Path.encode(this.getAbsolute()));
            }
        }
        return url.toString();
    }

    public AbstractPath.DescriptiveUrl toSignedUrl() {
        return this.toSignedUrl(Preferences.instance().getInteger("s3.url.expire.seconds"));
    }

    private AbstractPath.DescriptiveUrl toSignedUrl(int seconds) {
        Calendar expiry = Calendar.getInstance();
        expiry.add(13, seconds);
        return new AbstractPath.DescriptiveUrl(this.createSignedUrl(seconds), MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("{0} URL"), ch.cyberduck.core.i18n.Locale.localizedString("Signed", "S3")) + " (" + MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("Expires on {0}", "S3") + ")", DateFormatterFactory.instance().getShortFormat(expiry.getTimeInMillis())));
    }

    public String createSignedUrl(int expiry) {
        if (this.attributes().isFile()) {
            try {
                if (this.getSession().getHost().getCredentials().isAnonymousLogin()) {
                    log.info((Object)"Anonymous cannot create signed URL");
                    return null;
                }
                this.getSession().check();
                Calendar cal = Calendar.getInstance();
                cal.add(13, expiry);
                long secondsSinceEpoch = cal.getTimeInMillis() / 1000L;
                return this.getSession().getClient().createSignedUrl("GET", this.getContainerName(), this.getKey(), null, null, secondsSinceEpoch, false, this.getHost().getProtocol().isSecure(), false);
            }
            catch (ServiceException e) {
                this.error("Cannot read file attributes", e);
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
        return null;
    }

    public AbstractPath.DescriptiveUrl toTorrentUrl() {
        if (this.attributes().isFile()) {
            try {
                return new AbstractPath.DescriptiveUrl(this.getSession().getClient().createTorrentUrl(this.getContainerName(), this.getKey()));
            }
            catch (ConnectionCanceledException e) {
                log.warn((Object)e.getMessage());
            }
        }
        return new AbstractPath.DescriptiveUrl(null, null);
    }

    @Override
    public Set<AbstractPath.DescriptiveUrl> getHttpURLs() {
        AbstractPath.DescriptiveUrl torrent;
        AbstractPath.DescriptiveUrl week;
        AbstractPath.DescriptiveUrl day;
        Set<AbstractPath.DescriptiveUrl> urls = super.getHttpURLs();
        urls.add(new AbstractPath.DescriptiveUrl(this.toURL(Protocol.S3.getScheme()), MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("{0} URL"), Protocol.S3.getScheme().toUpperCase())));
        AbstractPath.DescriptiveUrl hour = this.toSignedUrl(3600);
        if (StringUtils.isNotBlank((String)hour.getUrl())) {
            urls.add(hour);
        }
        if (StringUtils.isNotBlank((String)(day = this.toSignedUrl(Preferences.instance().getInteger("s3.url.expire.seconds"))).getUrl())) {
            urls.add(day);
        }
        if (StringUtils.isNotBlank((String)(week = this.toSignedUrl(604800)).getUrl())) {
            urls.add(week);
        }
        if (StringUtils.isNotBlank((String)(torrent = this.toTorrentUrl()).getUrl())) {
            urls.add(new AbstractPath.DescriptiveUrl(torrent.getUrl(), MessageFormat.format(ch.cyberduck.core.i18n.Locale.localizedString("{0} URL"), ch.cyberduck.core.i18n.Locale.localizedString("Torrent"))));
        }
        return urls;
    }

    @Override
    public boolean isUploadResumable() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathFactory<S3Session> {
        private Factory() {
        }

        @Override
        protected Path create(S3Session session, String path, int type) {
            return new S3Path(session, path, type);
        }

        @Override
        protected Path create(S3Session session, String parent, String name, int type) {
            return new S3Path(session, parent, name, type);
        }

        @Override
        protected Path create(S3Session session, String parent, Local file) {
            return new S3Path(session, parent, file);
        }

        @Override
        protected <T> Path create(S3Session session, T dict) {
            return new S3Path(session, dict);
        }
    }
}

