/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import org.apache.log4j.Logger;

public class BandwidthThrottle {
    protected static Logger log = Logger.getLogger(BandwidthThrottle.class);
    private static final int TICKS_PER_SECOND = 10;
    private static final int MILLIS_PER_TICK = 100;
    private volatile int _bytesPerTick;
    private volatile boolean _switching = false;
    private int _availableBytes;
    private long _nextTickTime;
    public static final int UNLIMITED = -1;
    private float _rate = -1.0f;

    public BandwidthThrottle(float bytesPerSecond) {
        this.setRate(bytesPerSecond);
    }

    public BandwidthThrottle(float bytesPerSecond, boolean switching) {
        this.setRate(bytesPerSecond);
        this.setSwitching(switching);
    }

    public void setRate(float bytesPerSecond) {
        log.debug((Object)("setRate:" + bytesPerSecond));
        if (bytesPerSecond < 0.0f) {
            this._rate = -1.0f;
        } else {
            this._rate = bytesPerSecond;
            this._bytesPerTick = (int)(bytesPerSecond / 10.0f);
        }
        if (this._switching) {
            this.fixBytesPerTick(true);
        }
    }

    public float getRate() {
        return this._rate;
    }

    public void setSwitching(boolean switching) {
        log.debug((Object)("setSwitching:" + switching));
        if (this._switching != switching) {
            this.fixBytesPerTick(switching);
        }
        this._switching = switching;
    }

    private void fixBytesPerTick(boolean raise) {
        int newBytesPerTick = this._bytesPerTick;
        newBytesPerTick = raise ? (newBytesPerTick *= 2) : (newBytesPerTick /= 2);
        if (newBytesPerTick < 0) {
            newBytesPerTick = Integer.MAX_VALUE;
        }
        this._bytesPerTick = newBytesPerTick;
    }

    public synchronized int request(int desired) {
        if (-1.0f == this._rate) {
            return desired;
        }
        this.waitForBandwidth();
        int result = Math.min(desired, this._availableBytes);
        this._availableBytes -= result;
        return result;
    }

    private void waitForBandwidth() {
        while (true) {
            long now = System.currentTimeMillis();
            this.updateWindow(now);
            if (this._availableBytes != 0) break;
            try {
                log.info((Object)("Throttling bandwidth for " + (this._nextTickTime - now) + " milliseconds"));
                Thread.sleep(this._nextTickTime - now);
            }
            catch (InterruptedException e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    private void updateWindow(long now) {
        if (now >= this._nextTickTime) {
            if (!this._switching || now / 1000L % 2L == 0L) {
                this._availableBytes = this._bytesPerTick;
                this._nextTickTime = now + 100L;
            } else {
                this._availableBytes = 0;
                long diff = 1000L - now % 1000L;
                this._nextTickTime = now + diff;
            }
        }
    }
}

