/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WsFtpBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static Logger log = Logger.getLogger(WsFtpBookmarkCollection.class);

    public String getBundleIdentifier() {
        return "com.ipswitch.wsftp";
    }

    public String getName() {
        return "WS_FTP";
    }

    public Local getFile() {
        return LocalFactory.createLocal(Preferences.instance().getProperty("bookmark.import.wsftp.location"));
    }

    protected void parse(Local folder) {
        for (Local child : folder.children(new PathFilter<Local>(){

            @Override
            public boolean accept(Local file) {
                if (file.attributes().isDirectory()) {
                    return false;
                }
                return "ini".equals(file.getExtension());
            }
        })) {
            if (child.attributes().isDirectory()) {
                this.parse(child);
                continue;
            }
            this.read(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(Local file) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(file.getInputStream()));
            try {
                String line;
                Host current = null;
                while ((line = in.readLine()) != null) {
                    log.trace((Object)line);
                    if (line.startsWith("[")) {
                        this.add(current);
                        current = new Host(Preferences.instance().getProperty("connection.hostname.default"));
                        current.getCredentials().setUsername(Preferences.instance().getProperty("connection.login.anon.name"));
                        current.setProtocol(Protocol.FTP);
                        Pattern pattern = Pattern.compile("\\[(.*)\\]");
                        Matcher matcher = pattern.matcher(line);
                        if (!matcher.matches()) continue;
                        current.setNickname(matcher.group(1));
                        continue;
                    }
                    if (StringUtils.isBlank((String)line)) {
                        this.add(current);
                        continue;
                    }
                    if (null == current) {
                        log.warn((Object)"Failed to detect start of bookmark");
                        continue;
                    }
                    Scanner scanner = new Scanner(line);
                    scanner.useDelimiter("=");
                    if (!scanner.hasNext()) {
                        log.warn((Object)("Missing key in line:" + line));
                        continue;
                    }
                    String name = scanner.next().toLowerCase();
                    if (!scanner.hasNext()) {
                        log.warn((Object)("Missing value in line:" + line));
                        continue;
                    }
                    String value = scanner.next().replaceAll("\"", "");
                    if ("conntype".equals(name)) {
                        try {
                            switch (Integer.parseInt(value)) {
                                case 4: {
                                    current.setProtocol(Protocol.SFTP);
                                    break;
                                }
                                case 5: {
                                    current.setProtocol(Protocol.FTP_TLS);
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            log.warn((Object)("Unknown Protocol:" + e.getMessage()));
                        }
                        continue;
                    }
                    if ("host".equals(name)) {
                        current.setHostname(value);
                        continue;
                    }
                    if ("port".equals(name)) {
                        try {
                            current.setPort(Integer.parseInt(value));
                        }
                        catch (NumberFormatException e) {
                            log.warn((Object)("Invalid Port:" + e.getMessage()));
                        }
                        continue;
                    }
                    if ("dir".equals(name)) {
                        current.setDefaultPath(value);
                        continue;
                    }
                    if ("comment".equals(name)) {
                        current.setComment(value);
                        continue;
                    }
                    if (!"uid".equals(name)) continue;
                    current.getCredentials().setUsername(value);
                }
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                IOUtils.closeQuietly((Reader)in);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)in);
            {
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
    }

    public boolean add(Host bookmark) {
        if (bookmark == null) {
            return false;
        }
        if (bookmark.getHostname().equals(Preferences.instance().getProperty("connection.hostname.default"))) {
            return false;
        }
        return super.add(bookmark);
    }
}

