/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PathFilter;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.importer.XmlBookmarkCollection;
import org.apache.log4j.Logger;
import org.w3c.util.DateParser;
import org.w3c.util.InvalidDateException;

public class SmartFtpBookmarkCollection
extends XmlBookmarkCollection {
    private static Logger log = Logger.getLogger(SmartFtpBookmarkCollection.class);

    public String getBundleIdentifier() {
        return "com.smartftp";
    }

    public String getName() {
        return "SmartFTP";
    }

    public Local getFile() {
        return LocalFactory.createLocal(Preferences.instance().getProperty("bookmark.import.smartftp.location"));
    }

    protected void parse(Local folder) {
        for (Local child : folder.children(new PathFilter<Local>(){

            @Override
            public boolean accept(Local file) {
                if (file.attributes().isDirectory()) {
                    return true;
                }
                return "xml".equals(file.getExtension());
            }
        })) {
            if (child.attributes().isDirectory()) {
                this.parse(child);
                continue;
            }
            this.read(child);
        }
    }

    protected XmlBookmarkCollection.AbstractHandler getHandler() {
        return new ServerHandler();
    }

    private class ServerHandler
    extends XmlBookmarkCollection.AbstractHandler {
        private Host current = null;

        private ServerHandler() {
        }

        public void startElement(String name) {
            if (name.equals("FavoriteItem")) {
                this.current = new Host(Preferences.instance().getProperty("connection.hostname.default"));
                this.current.getCredentials().setUsername(Preferences.instance().getProperty("connection.login.anon.name"));
            }
        }

        public void endElement(String name, String elementText) {
            log.debug((Object)("endElement:" + name + "," + elementText));
            if (name.equals("Host")) {
                this.current.setHostname(elementText);
            } else if (name.equals("Protocol")) {
                try {
                    switch (Integer.parseInt(elementText)) {
                        case 1: {
                            this.current.setProtocol(Protocol.FTP);
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.current.setProtocol(Protocol.FTP_TLS);
                            break;
                        }
                        case 4: {
                            this.current.setProtocol(Protocol.SFTP);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Unknown Protocol:" + e.getMessage()));
                }
            } else if (name.equals("Port")) {
                try {
                    this.current.setPort(Integer.parseInt(elementText));
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Invalid Port:" + e.getMessage()));
                }
            } else if (name.equals("LastConnect")) {
                try {
                    this.current.setTimestamp(DateParser.parse(elementText));
                }
                catch (InvalidDateException e) {
                    log.warn((Object)("Failed to parse timestamp:" + e.getMessage()));
                }
            } else if (name.equals("User")) {
                this.current.getCredentials().setUsername(elementText);
            } else if (name.equals("Name")) {
                this.current.setNickname(elementText);
            } else if (name.equals("DataConnectionMethod")) {
                try {
                    switch (Integer.parseInt(elementText)) {
                        case 0: {
                            this.current.setFTPConnectMode(FTPConnectMode.PORT);
                            break;
                        }
                        case 1: {
                            this.current.setFTPConnectMode(FTPConnectMode.PASV);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Invalid connect mode:" + e.getMessage()));
                }
            } else if (name.equals("Description")) {
                this.current.setComment(elementText);
            } else if (name.equals("Path")) {
                this.current.setDefaultPath(elementText);
            } else if (name.equals("HTTP")) {
                this.current.setWebURL(elementText);
            } else if (name.equals("WebRootPath")) {
                this.current.setDefaultPath(elementText);
            } else if (name.equals("PrivateKey")) {
                this.current.getCredentials().setIdentity(LocalFactory.createLocal(elementText));
            } else if (name.equals("FavoriteItem")) {
                SmartFtpBookmarkCollection.this.add(this.current);
            }
        }
    }
}

