/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.importer.XmlBookmarkCollection;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FilezillaBookmarkCollection
extends XmlBookmarkCollection {
    private static Logger log = Logger.getLogger(FilezillaBookmarkCollection.class);

    public String getBundleIdentifier() {
        return "de.filezilla";
    }

    public String getName() {
        return "FileZilla";
    }

    public Local getFile() {
        return LocalFactory.createLocal(Preferences.instance().getProperty("bookmark.import.filezilla.location"));
    }

    protected void parse(Local file) {
        this.read(file);
    }

    protected XmlBookmarkCollection.AbstractHandler getHandler() {
        return new ServerHandler();
    }

    private class ServerHandler
    extends XmlBookmarkCollection.AbstractHandler {
        private Host current = null;

        private ServerHandler() {
        }

        public void startElement(String name) {
            if (name.equals("Server")) {
                this.current = new Host(Preferences.instance().getProperty("connection.hostname.default"));
            }
        }

        public void endElement(String name, String elementText) {
            if (name.equals("Host")) {
                this.current.setHostname(elementText);
            } else if (name.equals("Protocol")) {
                try {
                    switch (Integer.parseInt(elementText)) {
                        case 0: {
                            this.current.setProtocol(Protocol.FTP);
                            break;
                        }
                        case 3: 
                        case 4: {
                            this.current.setProtocol(Protocol.FTP_TLS);
                            break;
                        }
                        case 1: {
                            this.current.setProtocol(Protocol.SFTP);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Unknown protocol:" + e.getMessage()));
                }
            } else if (name.equals("Port")) {
                try {
                    this.current.setPort(Integer.parseInt(elementText));
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Invalid Port:" + e.getMessage()));
                }
            } else if (name.equals("MaximumMultipleConnections")) {
                if ("0".equals(elementText)) {
                    this.current.setMaxConnections(null);
                } else {
                    try {
                        this.current.setMaxConnections(Integer.parseInt(elementText));
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Invalid MaximumMultipleConnections:" + e.getMessage()));
                    }
                }
            } else if (name.equals("User")) {
                this.current.getCredentials().setUsername(elementText);
            } else if (name.equals("Logontype")) {
                try {
                    switch (Integer.parseInt(elementText)) {
                        case 0: {
                            this.current.getCredentials().setUsername(Preferences.instance().getProperty("connection.login.anon.name"));
                        }
                    }
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Invalid Logontype:" + e.getMessage()));
                }
            } else if (name.equals("Pass")) {
                this.current.getCredentials().setPassword(elementText);
            } else if (name.equals("Name")) {
                this.current.setNickname(elementText);
            } else if (name.equals("EncodingType")) {
                if ("Auto".equals(elementText)) {
                    this.current.setEncoding(null);
                } else {
                    this.current.setEncoding(elementText);
                }
            } else if (name.equals("PasvMode")) {
                if ("MODE_DEFAULT".equals(elementText)) {
                    this.current.setFTPConnectMode(null);
                } else if ("MODE_PASSIVE".equals(elementText)) {
                    this.current.setFTPConnectMode(FTPConnectMode.PASV);
                } else if ("MODE_ACTIVE".equals(elementText)) {
                    this.current.setFTPConnectMode(FTPConnectMode.PORT);
                }
            } else if (name.equals("Comments")) {
                this.current.setComment(elementText);
            } else if (name.equals("LocalDir")) {
                this.current.setDownloadFolder(elementText);
            } else if (name.equals("RemoteDir")) {
                if (StringUtils.isNotBlank((String)elementText)) {
                    StringBuilder b = new StringBuilder();
                    int i = 0;
                    for (String component : elementText.substring(3).split("\\s")) {
                        if (i % 2 == 0) {
                            b.append(component);
                        } else {
                            b.append('/');
                        }
                        ++i;
                    }
                    if (StringUtils.isNotBlank((String)b.toString())) {
                        this.current.setDefaultPath(b.toString());
                    }
                }
            } else if (!name.equals("TimezoneOffset") && name.equals("Server")) {
                FilezillaBookmarkCollection.this.add(this.current);
            }
        }
    }
}

