/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.ui.cocoa.foundation.NSDictionary;
import ch.cyberduck.ui.cocoa.serializer.PlistDeserializer;
import java.util.List;
import org.apache.log4j.Logger;

public class FetchBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static Logger log = Logger.getLogger(FetchBookmarkCollection.class);

    public String getBundleIdentifier() {
        return "com.fetchsoftworks.Fetch";
    }

    public Local getFile() {
        return LocalFactory.createLocal(Preferences.instance().getProperty("bookmark.import.fetch.location"));
    }

    protected void parse(Local file) {
        NSDictionary serialized = NSDictionary.dictionaryWithContentsOfFile((String)file.getAbsolute());
        if (null == serialized) {
            log.error((Object)("Invalid bookmark file:" + file));
            return;
        }
        NSDictionary dict = new PlistDeserializer(serialized).objectForKey("Shortcuts v2");
        if (null == dict) {
            log.error((Object)("Invalid bookmark file:" + file));
            return;
        }
        if (null == (dict = new PlistDeserializer(dict).objectForKey("Shortcuts"))) {
            log.error((Object)("Invalid bookmark file:" + file));
            return;
        }
        List shortcuts = new PlistDeserializer(dict).listForKey("Shortcuts");
        for (NSDictionary shortcut : shortcuts) {
            String url;
            NSDictionary location;
            PlistDeserializer reader = new PlistDeserializer(shortcut);
            NSDictionary remote = reader.objectForKey("Remote Item");
            if (null == remote || null == (location = new PlistDeserializer(remote).objectForKey("Location")) || null == (url = new PlistDeserializer(location).stringForKey("URL"))) continue;
            Host host = Host.parse(url);
            host.setNickname(reader.stringForKey("Name"));
            this.add(host);
        }
    }
}

