/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.importer.XmlBookmarkCollection;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;

public class CrossFtpBookmarkCollection
extends XmlBookmarkCollection {
    private static Logger log = Logger.getLogger(CrossFtpBookmarkCollection.class);

    public String getBundleIdentifier() {
        return "com.crossftp";
    }

    public String getName() {
        return "CrossFTP";
    }

    public Local getFile() {
        return LocalFactory.createLocal(Preferences.instance().getProperty("bookmark.import.crossftp.location"));
    }

    protected void parse(Local file) {
        this.read(file);
    }

    protected XmlBookmarkCollection.AbstractHandler getHandler() {
        return new ServerHandler();
    }

    private class ServerHandler
    extends XmlBookmarkCollection.AbstractHandler {
        private Host current = null;

        private ServerHandler() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("site")) {
                this.current = new Host(attrs.getValue("hName"));
                this.current.setNickname(attrs.getValue("name"));
                this.current.getCredentials().setUsername(attrs.getValue("un"));
                this.current.setWebURL(attrs.getValue("wURL"));
                this.current.setComment(attrs.getValue("comm"));
                this.current.setDefaultPath(attrs.getValue("path"));
                String protocol = attrs.getValue("ftpPType");
                try {
                    switch (Integer.valueOf(protocol)) {
                        case 1: {
                            this.current.setProtocol(Protocol.FTP);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            this.current.setProtocol(Protocol.FTP_TLS);
                            break;
                        }
                        case 6: {
                            this.current.setProtocol(Protocol.WEBDAV);
                            break;
                        }
                        case 7: {
                            this.current.setProtocol(Protocol.WEBDAV_SSL);
                            break;
                        }
                        case 8: 
                        case 9: {
                            this.current.setProtocol(Protocol.S3_SSL);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Unknown protocol:" + e.getMessage()));
                }
                try {
                    this.current.setPort(Integer.parseInt(attrs.getValue("port")));
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Invalid Port:" + e.getMessage()));
                }
            }
            super.startElement(uri, name, qName, attrs);
        }

        public void startElement(String name) {
        }

        public void endElement(String name, String elementText) {
            if (name.equals("site")) {
                CrossFtpBookmarkCollection.this.add(this.current);
            }
        }
    }
}

