/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.importer.XmlBookmarkCollection;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;

public abstract class CloudberryBookmarkCollection
extends XmlBookmarkCollection {
    private static Logger log = Logger.getLogger(CloudberryBookmarkCollection.class);

    protected void parse(Local file) {
        this.read(file);
    }

    protected XmlBookmarkCollection.AbstractHandler getHandler() {
        return new ServerHandler();
    }

    private class ServerHandler
    extends XmlBookmarkCollection.AbstractHandler {
        private Host current = null;

        private ServerHandler() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Settings")) {
                String type = attrs.getValue("xsi:type");
                if ("GoogleSettings".equals(type)) {
                    this.current = new Host(Protocol.GOOGLESTORAGE_SSL, Protocol.GOOGLESTORAGE_SSL.getDefaultHostname(), Protocol.GOOGLESTORAGE_SSL.getDefaultPort());
                } else if ("S3Settings".equals(type)) {
                    this.current = new Host(Protocol.S3_SSL, Protocol.S3_SSL.getDefaultHostname(), Protocol.S3_SSL.getDefaultPort());
                } else if ("WalrusSettings".equals(type)) {
                    this.current = new Host(Protocol.EUCALYPTUS, Protocol.EUCALYPTUS.getDefaultHostname(), Protocol.EUCALYPTUS.getDefaultPort());
                } else if ("DunkelSettings".equals(type)) {
                    this.current = new Host(Protocol.S3_SSL, Protocol.S3_SSL.getDefaultHostname(), Protocol.S3_SSL.getDefaultPort());
                } else if ("AzureSettings".equals(type)) {
                    this.current = new Host(Protocol.AZURE_SSL, Protocol.AZURE_SSL.getDefaultHostname(), Protocol.AZURE_SSL.getDefaultPort());
                } else {
                    log.warn((Object)("Unsupported connection type:" + type));
                }
            }
            super.startElement(uri, name, qName, attrs);
        }

        public void startElement(String name) {
        }

        public void endElement(String name, String elementText) {
            if (null == this.current) {
                return;
            }
            if (name.equals("ServicePoint")) {
                this.current.setHostname(elementText);
            } else if (name.equals("AWSKey")) {
                this.current.getCredentials().setUsername(elementText);
            } else if (name.equals("Account")) {
                this.current.getCredentials().setUsername(elementText);
            } else if (name.equals("SharedKey")) {
                this.current.getCredentials().setPassword(elementText);
            } else if (name.equals("Name")) {
                this.current.setNickname(elementText);
            } else if (name.equals("Settings")) {
                CloudberryBookmarkCollection.this.add(this.current);
                this.current = null;
            }
        }
    }
}

