/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.idisk;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.dav.DAVPath;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.idisk.IDiskSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDiskPath
extends DAVPath {
    public static PathFactory factory() {
        return new Factory();
    }

    protected IDiskPath(IDiskSession s, String parent, String name, int type) {
        super(s, parent, name, type);
    }

    protected IDiskPath(IDiskSession s, String path, int type) {
        super((DAVSession)s, path, type);
    }

    protected IDiskPath(IDiskSession s, String parent, Local file) {
        super((DAVSession)s, parent, file);
    }

    protected <T> IDiskPath(IDiskSession s, T dict) {
        super(s, dict);
    }

    @Override
    public String toHttpURL() {
        String member = this.getHost().getCredentials().getUsername();
        String homepage = String.valueOf('/') + member + String.valueOf('/') + "Sites";
        String sites = String.valueOf('/') + member + String.valueOf('/') + "Web/Sites";
        String gallery = String.valueOf('/') + member + String.valueOf('/') + "Web/Sites/_gallery";
        String absolute = this.getAbsolute();
        if (absolute.startsWith(homepage)) {
            absolute = absolute.substring(homepage.length());
            return "http://homepage.mac.com/" + member + absolute;
        }
        if (absolute.startsWith(gallery)) {
            absolute = absolute.substring(gallery.length());
            return "http://gallery.me.com/" + member + absolute;
        }
        if (absolute.startsWith(sites)) {
            absolute = absolute.substring(sites.length());
            return "http://web.me.com/" + member + absolute;
        }
        return super.toHttpURL();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathFactory<IDiskSession> {
        private Factory() {
        }

        @Override
        protected Path create(IDiskSession session, String path, int type) {
            return new IDiskPath(session, path, type);
        }

        @Override
        protected Path create(IDiskSession session, String parent, String name, int type) {
            return new IDiskPath(session, parent, name, type);
        }

        @Override
        protected Path create(IDiskSession session, String parent, Local file) {
            return new IDiskPath(session, parent, file);
        }

        @Override
        protected <T> Path create(IDiskSession session, T dict) {
            return new IDiskPath(session, dict);
        }
    }
}

