/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Proxy;
import ch.cyberduck.core.ProxyFactory;
import ch.cyberduck.core.ssl.CustomTrustSSLProtocolSocketFactory;
import ch.cyberduck.core.ssl.SSLSession;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.params.AuthParams;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;

public abstract class HTTP4Session
extends SSLSession {
    private AbstractHttpClient http;

    protected HTTP4Session(Host h) {
        super(h);
    }

    protected AbstractHttpClient http() {
        if (null == this.http) {
            BasicHttpParams params = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)this.getEncoding());
            HttpProtocolParams.setUserAgent((HttpParams)params, (String)this.getUserAgent());
            AuthParams.setCredentialCharset((HttpParams)params, (String)"ISO-8859-1");
            HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.timeout());
            HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
            HttpClientParams.setRedirecting((HttpParams)params, (boolean)true);
            HttpClientParams.setAuthenticating((HttpParams)params, (boolean)true);
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", this.host.getPort(), (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            if ("https".equals(this.getHost().getProtocol().getScheme())) {
                SSLSocketFactory factory = new SSLSocketFactory(new CustomTrustSSLProtocolSocketFactory(this.getTrustManager()).getSSLContext(), SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                registry.register(new Scheme(this.host.getProtocol().getScheme(), this.host.getPort(), (SchemeSocketFactory)factory));
            }
            if (Preferences.instance().getBoolean("connection.proxy.enable")) {
                Proxy proxy = ProxyFactory.instance();
                if ("https".equals(this.getHost().getProtocol().getScheme()) && proxy.isHTTPSProxyEnabled(this.host)) {
                    ConnRouteParams.setDefaultProxy((HttpParams)params, (HttpHost)new HttpHost(proxy.getHTTPSProxyHost(this.host), proxy.getHTTPSProxyPort(this.host)));
                }
                if ("http".equals(this.getHost().getProtocol().getScheme()) && proxy.isHTTPProxyEnabled(this.host)) {
                    ConnRouteParams.setDefaultProxy((HttpParams)params, (HttpHost)new HttpHost(proxy.getHTTPProxyHost(this.host), proxy.getHTTPProxyPort(this.host)));
                }
            }
            SingleClientConnManager manager = new SingleClientConnManager(registry);
            this.http = new DefaultHttpClient((ClientConnectionManager)manager, (HttpParams)params);
            this.configure(this.http);
        }
        return this.http;
    }

    protected void configure(AbstractHttpClient client) {
        this.http.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                HTTP4Session.this.log(true, request.getRequestLine().toString());
                for (Header header : request.getAllHeaders()) {
                    HTTP4Session.this.log(true, header.toString());
                }
            }
        });
        this.http.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                HTTP4Session.this.log(true, response.getStatusLine().toString());
                for (Header header : response.getAllHeaders()) {
                    HTTP4Session.this.log(false, header.toString());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (null != this.http) {
                this.http.getConnectionManager().shutdown();
            }
            Object var2_1 = null;
            this.http = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.http = null;
            throw throwable;
        }
    }
}

