/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.http;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Proxy;
import ch.cyberduck.core.ProxyFactory;
import ch.cyberduck.core.ResolveCanceledException;
import ch.cyberduck.core.http.StickyHostConfiguration;
import ch.cyberduck.core.ssl.AbstractX509TrustManager;
import ch.cyberduck.core.ssl.CustomTrustSSLProtocolSocketFactory;
import ch.cyberduck.core.ssl.SSLSession;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.params.HostParams;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public abstract class HTTP3Session
extends SSLSession {
    private Appender appender = new AppenderSkeleton(){
        private static final String IN = "<< ";
        private static final String OUT = ">> ";

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }

        protected void append(LoggingEvent event) {
            String m = StringUtils.remove((String)StringUtils.remove((String)event.getMessage().toString(), (String)"[\\r][\\n]"), (String)"\"");
            if (m.startsWith(IN)) {
                HTTP3Session.this.log(false, StringUtils.remove((String)m, (String)IN));
            } else if (m.startsWith(OUT)) {
                HTTP3Session.this.log(true, StringUtils.remove((String)m, (String)OUT));
            }
        }
    };

    protected HTTP3Session(Host h) {
        super(h);
    }

    protected HostConfiguration getHostConfiguration() {
        return this.getHostConfiguration(this.getHost());
    }

    protected HostConfiguration getHostConfiguration(Host host) {
        Proxy proxy;
        int port = host.getPort();
        StickyHostConfiguration configuration = new StickyHostConfiguration();
        if ("https".equals(host.getProtocol().getScheme())) {
            if (-1 == port) {
                port = 443;
            }
            configuration.setHost(host.getHostname(), port, new Protocol(host.getProtocol().getScheme(), (SecureProtocolSocketFactory)new SSLSocketFactory(this.getTrustManager(host.getHostname())), port));
            if (Preferences.instance().getBoolean("connection.proxy.enable") && (proxy = ProxyFactory.instance()).isHTTPSProxyEnabled(host)) {
                configuration.setProxy(proxy.getHTTPSProxyHost(host), proxy.getHTTPSProxyPort(host));
            }
        } else if ("http".equals(host.getProtocol().getScheme())) {
            if (-1 == port) {
                port = 80;
            }
            configuration.setHost(host.getHostname(), port, new Protocol(host.getProtocol().getScheme(), (ProtocolSocketFactory)new DefaultProtocolSocketFactory(), port));
            if (Preferences.instance().getBoolean("connection.proxy.enable") && (proxy = ProxyFactory.instance()).isHTTPProxyEnabled(host)) {
                configuration.setProxy(proxy.getHTTPProxyHost(host), proxy.getHTTPProxyPort(host));
            }
        }
        HostParams parameters = configuration.getParams();
        parameters.setParameter("http.useragent", (Object)this.getUserAgent());
        parameters.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        parameters.setParameter("http.socket.timeout", (Object)this.timeout());
        parameters.setParameter("http.protocol.credential-charset", (Object)"ISO-8859-1");
        parameters.setParameter("http.protocol.max-redirects", (Object)10);
        return configuration;
    }

    protected void fireConnectionWillOpenEvent() throws ResolveCanceledException, UnknownHostException {
        Logger.getLogger((String)"httpclient.wire.header").addAppender(this.appender);
        super.fireConnectionWillOpenEvent();
    }

    protected void fireConnectionWillCloseEvent() {
        Logger.getLogger((String)"httpclient.wire.header").removeAppender(this.appender);
        super.fireConnectionWillCloseEvent();
    }

    protected static class SSLSocketFactory
    extends CustomTrustSSLProtocolSocketFactory
    implements ProtocolSocketFactory,
    SecureProtocolSocketFactory {
        public SSLSocketFactory(AbstractX509TrustManager manager) {
            super(manager);
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException {
            Socket socket = super.createSocket(host, port, localAddress, localPort);
            socket.setTcpNoDelay(params.getTcpNoDelay());
            socket.setSoTimeout(params.getSoTimeout());
            return socket;
        }
    }
}

