/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.gstorage;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.s3.S3Session;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.acl.Permission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSSession
extends S3Session {
    public static SessionFactory factory() {
        return new Factory();
    }

    protected GSSession(Host h) {
        super(h);
    }

    @Override
    protected void configure(String hostname) {
        super.configure(hostname);
        Jets3tProperties configuration = super.getProperties();
        configuration.setProperty("s3service.enable-storage-classes", String.valueOf(false));
    }

    @Override
    public List<String> getSupportedStorageClasses() {
        return Arrays.asList("STANDARD");
    }

    @Override
    public String getLocation(String container) {
        return Locale.localizedString("US", "S3");
    }

    @Override
    public boolean isLoggingSupported() {
        return false;
    }

    @Override
    public boolean isVersioningSupported() {
        return false;
    }

    @Override
    public boolean isRequesterPaysSupported() {
        return false;
    }

    @Override
    public boolean isMultipartUploadSupported() {
        return false;
    }

    @Override
    public List<Acl.User> getAvailableAclUsers() {
        List<Acl.User> users = super.getAvailableAclUsers();
        Iterator<Acl.User> iter = users.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof Acl.EmailUser)) continue;
            iter.remove();
        }
        users.add(new Acl.EmailUser(){

            public String getPlaceholder() {
                return Locale.localizedString("Google Account Email Address", "S3");
            }
        });
        return users;
    }

    @Override
    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        ArrayList<Acl.Role> roles = new ArrayList<Acl.Role>(Arrays.asList(new Acl.Role(Permission.PERMISSION_FULL_CONTROL.toString()), new Acl.Role(Permission.PERMISSION_READ.toString())));
        for (Path file : files) {
            if (!file.attributes().isVolume()) continue;
            roles.add(new Acl.Role(Permission.PERMISSION_WRITE.toString()));
            break;
        }
        return roles;
    }

    @Override
    public boolean isBucketLocationSupported() {
        return false;
    }

    @Override
    public boolean isCDNSupported() {
        return false;
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new GSSession(h);
        }
    }
}

