/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.gstorage;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.gstorage.GSSession;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.s3.S3Path;
import ch.cyberduck.core.s3.S3Session;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.CanonicalGrantee;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.GroupGrantee;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSPath
extends S3Path {
    private static Logger log = Logger.getLogger(GSPath.class);

    public static PathFactory factory() {
        return new Factory();
    }

    protected GSPath(S3Session s, String parent, String name, int type) {
        super(s, parent, name, type);
    }

    protected GSPath(S3Session s, String path, int type) {
        super(s, path, type);
    }

    protected GSPath(S3Session s, String parent, Local file) {
        super(s, parent, file);
    }

    protected <T> GSPath(S3Session s, T dict) {
        super(s, dict);
    }

    @Override
    public AbstractPath.DescriptiveUrl toAuthenticatedUrl() {
        if (this.attributes().isFile()) {
            return new AbstractPath.DescriptiveUrl("https://sandbox.google.com/storage" + this.getAbsolute());
        }
        return new AbstractPath.DescriptiveUrl(null, null);
    }

    @Override
    public AbstractPath.DescriptiveUrl toSignedUrl() {
        return new AbstractPath.DescriptiveUrl(null, null);
    }

    @Override
    public AbstractPath.DescriptiveUrl toTorrentUrl() {
        return new AbstractPath.DescriptiveUrl(null, null);
    }

    @Override
    public Set<AbstractPath.DescriptiveUrl> getHttpURLs() {
        Set<AbstractPath.DescriptiveUrl> urls = super.getHttpURLs();
        AbstractPath.DescriptiveUrl url = this.toAuthenticatedUrl();
        if (StringUtils.isNotBlank((String)url.getUrl())) {
            urls.add(new AbstractPath.DescriptiveUrl(url.getUrl(), MessageFormat.format(Locale.localizedString("{0} URL"), Locale.localizedString("Authenticated"))));
        }
        return urls;
    }

    @Override
    protected AccessControlList getAccessControlList(Permission permission) throws IOException {
        AccessControlList acl = super.getAccessControlList(permission);
        acl.revokeAllPermissions((GranteeInterface)new CanonicalGrantee(acl.getOwner().getId()));
        acl.revokeAllPermissions((GranteeInterface)GroupGrantee.ALL_USERS);
        if (permission.getOtherPermissions()[0]) {
            acl.grantPermission((GranteeInterface)GroupGrantee.ALL_USERS, org.jets3t.service.acl.Permission.PERMISSION_READ);
        }
        if (permission.getOtherPermissions()[1] && this.isContainer()) {
            acl.grantPermission((GranteeInterface)GroupGrantee.ALL_USERS, org.jets3t.service.acl.Permission.PERMISSION_READ);
            acl.grantPermission((GranteeInterface)GroupGrantee.ALL_USERS, org.jets3t.service.acl.Permission.PERMISSION_WRITE);
        }
        return acl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathFactory<GSSession> {
        private Factory() {
        }

        @Override
        protected Path create(GSSession session, String path, int type) {
            return new GSPath((S3Session)session, path, type);
        }

        @Override
        protected Path create(GSSession session, String parent, String name, int type) {
            return new GSPath(session, parent, name, type);
        }

        @Override
        protected Path create(GSSession session, String parent, Local file) {
            return new GSPath((S3Session)session, parent, file);
        }

        @Override
        protected <T> Path create(GSSession session, T dict) {
            return new GSPath(session, dict);
        }
    }
}

