/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginCanceledException;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProxyFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.ftp.FTPParserFactory;
import ch.cyberduck.core.ftp.parser.CompositeFileEntryParser;
import ch.cyberduck.core.ftp.parser.LaxUnixFTPEntryParser;
import ch.cyberduck.core.ftp.parser.RumpusFTPEntryParser;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.ssl.SSLSession;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.Configurable;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.NetwareFTPEntryParser;
import org.apache.commons.net.ftp.parser.ParserInitializationException;
import org.apache.commons.net.ftp.parser.UnixFTPEntryParser;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPSession
extends SSLSession {
    private static Logger log = Logger.getLogger(FTPSession.class);
    private FTPClient FTP;
    protected FTPFileEntryParser parser;
    private TimeZone tz;
    private Map<FTPFileEntryParser, Boolean> parsers = new HashMap<FTPFileEntryParser, Boolean>(1);
    private ProtocolCommandListener listener = new ProtocolCommandListener(){

        public void protocolCommandSent(ProtocolCommandEvent event) {
            String message = StringUtils.chomp((String)event.getMessage());
            if (message.startsWith("PASS")) {
                message = "PASS ********";
            }
            FTPSession.this.log(true, message);
        }

        public void protocolReplyReceived(ProtocolCommandEvent event) {
            FTPSession.this.log(false, StringUtils.chomp((String)event.getMessage()));
        }
    };
    private boolean unsecureswitch = Preferences.instance().getBoolean("connection.unsecure.switch");
    private boolean statListSupportedEnabled = Preferences.instance().getBoolean("ftp.command.stat");
    private boolean mlsdListSupportedEnabled = Preferences.instance().getBoolean("ftp.command.mlsd");
    private boolean extendedListEnabled = Preferences.instance().getBoolean("ftp.command.lista");
    private boolean utimeSupported = Preferences.instance().getBoolean("ftp.command.utime");

    public static SessionFactory factory() {
        return new Factory();
    }

    public FTPSession(Host h) {
        super(h);
    }

    protected FTPClient getClient() throws ConnectionCanceledException {
        if (null == this.FTP) {
            throw new ConnectionCanceledException();
        }
        return this.FTP;
    }

    @Override
    protected Path mount(String directory) throws IOException {
        Path workdir = super.mount(directory);
        if (Preferences.instance().getBoolean("ftp.timezone.auto") && null == this.host.getTimezone()) {
            List<TimeZone> matches = this.calculateTimezone();
            Iterator<TimeZone> i$ = matches.iterator();
            if (i$.hasNext()) {
                TimeZone tz = i$.next();
                this.host.setTimezone(tz);
            }
            if (!matches.isEmpty()) {
                this.parser = null;
            }
        }
        return workdir;
    }

    protected TimeZone getTimezone() throws IOException {
        if (null == this.host.getTimezone()) {
            return TimeZone.getTimeZone(Preferences.instance().getProperty("ftp.timezone.default"));
        }
        return this.host.getTimezone();
    }

    protected FTPFileEntryParser getFileParser() throws IOException {
        try {
            if (!this.getTimezone().equals(this.tz)) {
                this.tz = this.getTimezone();
                log.info((Object)("Reset parser to timezone:" + this.tz));
                this.parser = null;
            }
            if (null == this.parser) {
                String ukey;
                String system = this.getClient().getSystemType();
                if (null == system) {
                    log.warn((Object)(this.host.getHostname() + " does not support the SYST command"));
                }
                this.parser = new FTPParserFactory().createFileEntryParser(system, this.tz);
                if (this.parser instanceof Configurable) {
                    ((Configurable)this.parser).configure(null);
                }
                if ((ukey = system.toUpperCase()).indexOf("WINDOWS") >= 0) {
                    this.setStatListSupportedEnabled(false);
                }
            }
            return this.parser;
        }
        catch (ParserInitializationException e) {
            IOException failure = new IOException(e.getMessage());
            failure.initCause(e);
            throw failure;
        }
    }

    private List<TimeZone> calculateTimezone() throws IOException {
        AttributedList list = this.workdir().children();
        if (list.isEmpty()) {
            log.warn((Object)"Cannot determine timezone with empty directory listing");
            return Collections.emptyList();
        }
        for (Path test : list) {
            String[] timezones;
            if (!test.attributes().isFile()) continue;
            long local = test.attributes().getModificationDate();
            if (-1L == local) {
                log.warn((Object)"No modification date in directory listing to calculate timezone");
                continue;
            }
            local -= local % 60000L;
            test.readTimestamp();
            long utc = test.attributes().getModificationDate();
            if (-1L == utc) {
                log.warn((Object)"No UTC support on server");
                continue;
            }
            utc -= utc % 60000L;
            long offset = local - utc;
            log.info((Object)("Calculated UTC offset is " + offset + "ms"));
            ArrayList<TimeZone> zones = new ArrayList<TimeZone>();
            if ((long)TimeZone.getTimeZone(Preferences.instance().getProperty("ftp.timezone.default")).getOffset(utc) == offset) {
                log.info((Object)"Offset equals local timezone offset.");
                zones.add(TimeZone.getTimeZone(Preferences.instance().getProperty("ftp.timezone.default")));
                return zones;
            }
            for (String timezone : timezones = TimeZone.getAvailableIDs((int)offset)) {
                log.info((Object)("Matching timezone identifier:" + timezone));
                TimeZone match = TimeZone.getTimeZone(timezone);
                log.info((Object)("Determined timezone:" + match));
                zones.add(match);
            }
            if (zones.isEmpty()) {
                log.warn((Object)("Failed to calculate timezone for offset:" + offset));
                continue;
            }
            return zones;
        }
        log.warn((Object)"No file in directory listing to calculate timezone");
        return Collections.emptyList();
    }

    protected boolean isPermissionSupported(FTPFileEntryParser p) {
        FTPFileEntryParser delegate;
        if (p instanceof CompositeFileEntryParser) {
            delegate = ((CompositeFileEntryParser)p).getCachedFtpFileEntryParser();
            if (null == delegate) {
                log.warn((Object)"Composite FTP parser has no cached delegate yet");
                return false;
            }
        } else {
            delegate = p;
        }
        if (null == this.parsers.get(delegate)) {
            this.parsers.put(delegate, delegate instanceof UnixFTPEntryParser || delegate instanceof LaxUnixFTPEntryParser || delegate instanceof NetwareFTPEntryParser || delegate instanceof RumpusFTPEntryParser);
        }
        return this.parsers.get(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        block8: {
            try {
                try {
                    if (this.isConnected()) {
                        this.fireConnectionWillCloseEvent();
                        this.getClient().logout();
                    }
                }
                catch (IOException e) {
                    log.error((Object)("IO Error: " + e.getMessage()));
                    Object var3_2 = null;
                    if (null != this.FTP) {
                        this.FTP.removeProtocolCommandListener(this.listener);
                    }
                    this.FTP = null;
                    this.fireConnectionDidCloseEvent();
                    return;
                }
                Object var3_1 = null;
                if (null == this.FTP) break block8;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (null != this.FTP) {
                    this.FTP.removeProtocolCommandListener(this.listener);
                }
                this.FTP = null;
                this.fireConnectionDidCloseEvent();
                throw throwable;
            }
            this.FTP.removeProtocolCommandListener(this.listener);
        }
        this.FTP = null;
        this.fireConnectionDidCloseEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void interrupt() {
        block7: {
            try {
                try {
                    this.fireConnectionWillCloseEvent();
                    this.getClient().disconnect();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                    Object var3_2 = null;
                    if (null != this.FTP) {
                        this.FTP.removeProtocolCommandListener(this.listener);
                    }
                    this.FTP = null;
                    this.fireConnectionDidCloseEvent();
                    return;
                }
                Object var3_1 = null;
                if (null == this.FTP) break block7;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (null != this.FTP) {
                    this.FTP.removeProtocolCommandListener(this.listener);
                }
                this.FTP = null;
                this.fireConnectionDidCloseEvent();
                throw throwable;
            }
            this.FTP.removeProtocolCommandListener(this.listener);
        }
        this.FTP = null;
        this.fireConnectionDidCloseEvent();
    }

    @Override
    public void check() throws IOException {
        try {
            super.check();
        }
        catch (FTPConnectionClosedException e) {
            log.warn((Object)e.getMessage());
            this.interrupt();
            this.connect();
        }
    }

    protected void configure(FTPClient client) throws IOException {
        client.setControlEncoding(this.getEncoding());
        client.removeProtocolCommandListener(this.listener);
        client.addProtocolCommandListener(this.listener);
        client.setConnectTimeout(this.timeout());
        client.setDefaultTimeout(this.timeout());
        client.setDataTimeout(this.timeout());
        client.setDefaultPort(Protocol.FTP.getDefaultPort());
        client.setParserFactory(new FTPParserFactory());
        client.setRemoteVerificationEnabled(true);
        if (this.getConnectMode().equals(FTPConnectMode.PASV)) {
            client.enterLocalPassiveMode();
        }
        if (this.getConnectMode().equals(FTPConnectMode.PORT)) {
            client.enterLocalActiveMode();
        }
        if (this.getHost().getProtocol().isSecure()) {
            ArrayList<String> protocols = new ArrayList<String>();
            for (String protocol : Preferences.instance().getProperty("connection.ssl.protocols").split(",")) {
                protocols.add(protocol.trim());
            }
            client.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
            client.setTrustManager(this.host.getProtocol().isSecure() ? this.getTrustManager() : null);
        }
    }

    private boolean isTLSSupported() throws IOException {
        return this.getClient().isFeatureSupported("AUTH TLS") && this.getClient().isFeatureSupported("PBSZ") && this.getClient().isFeatureSupported("PROT");
    }

    @Override
    protected void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        this.fireConnectionWillOpenEvent();
        try {
            this.FTP = new FTPClient();
        }
        catch (NoSuchAlgorithmException e) {
            IOException failure = new IOException(e.getMessage());
            failure.initCause(e);
            throw failure;
        }
        this.configure(this.getClient());
        this.getClient().connect(this.host.getHostname(true), this.host.getPort());
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        this.configure(this.getClient());
        this.login();
        if (this.getHost().getProtocol().isSecure()) {
            this.getClient().execPBSZ(0L);
            this.getClient().execPROT(Preferences.instance().getProperty("ftp.tls.datachannel"));
        }
        this.fireConnectionDidOpenEvent();
        if ("UTF-8".equals(this.getEncoding()) && this.getClient().isFeatureSupported("UTF8") && !FTPReply.isPositiveCompletion((int)this.getClient().sendCommand("OPTS UTF8 ON"))) {
            log.warn((Object)("Failed to negogiate UTF-8 charset:" + this.getClient().getReplyString()));
        }
    }

    protected FTPConnectMode getConnectMode() {
        if (null == this.host.getFTPConnectMode()) {
            if (ProxyFactory.instance().usePassiveFTP()) {
                return FTPConnectMode.PASV;
            }
            return FTPConnectMode.PORT;
        }
        return this.host.getFTPConnectMode();
    }

    public boolean isUnsecureswitch() {
        return this.unsecureswitch;
    }

    public void setUnsecureswitch(boolean unsecureswitch) {
        this.unsecureswitch = unsecureswitch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void warn(LoginController login, Credentials credentials) throws IOException {
        Host host = this.getHost();
        if (this.isUnsecureswitch() && !credentials.isAnonymousLogin() && !host.getProtocol().isSecure() && !Preferences.instance().getBoolean("connection.unsecure." + host.getHostname()) && this.isTLSSupported()) {
            try {
                try {
                    login.warn(MessageFormat.format(Locale.localizedString("Unsecured {0} connection", "Credentials"), host.getProtocol().getName()), MessageFormat.format(Locale.localizedString("The server supports encrypted connections. Do you want to switch to {0}?", "Credentials"), Protocol.FTP_TLS.getName()), Locale.localizedString("Continue", "Credentials"), Locale.localizedString("Change", "Credentials"), "connection.unsecure." + host.getHostname());
                }
                catch (LoginCanceledException e) {
                    host.setProtocol(Protocol.FTP_TLS);
                    if (BookmarkCollection.defaultCollection().contains(host)) {
                        BookmarkCollection.defaultCollection().collectionItemChanged(host);
                    }
                    this.configure(this.getClient());
                    this.getClient().execAUTH();
                    this.getClient().sslNegotiation();
                    Object var6_5 = null;
                    this.setUnsecureswitch(false);
                }
                Object var6_4 = null;
                this.setUnsecureswitch(false);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.setUnsecureswitch(false);
                throw throwable;
            }
        } else {
            super.warn(login, credentials);
        }
    }

    @Override
    protected void login(LoginController controller, Credentials credentials) throws IOException {
        FTPClient client = this.getClient();
        if (client.login(credentials.getUsername(), credentials.getPassword())) {
            this.message(Locale.localizedString("Login successful", "Credentials"));
        } else {
            this.message(Locale.localizedString("Login failed", "Credentials"));
            controller.fail(this.host.getProtocol(), credentials, client.getReplyString());
            this.login();
        }
    }

    @Override
    public Path workdir() throws ConnectionCanceledException {
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        if (null == this.workdir) {
            try {
                this.workdir = PathFactory.createPath((Session)this, this.getClient().printWorkingDirectory(), 2);
                if (this.workdir.isRoot()) {
                    this.workdir.attributes().setType(10);
                }
            }
            catch (IOException e) {
                this.error("Connection failed", e);
                throw new ConnectionCanceledException(e.getMessage());
            }
        }
        return this.workdir;
    }

    @Override
    protected void noop() throws IOException {
        if (this.isConnected()) {
            this.getClient().sendNoOp();
        }
    }

    @Override
    public boolean isSendCommandSupported() {
        return true;
    }

    @Override
    public void sendCommand(String command) throws IOException {
        if (this.isConnected()) {
            this.message(command);
            this.getClient().sendSiteCommand(command);
        }
    }

    @Override
    public boolean isDownloadResumable() {
        return true;
    }

    @Override
    public boolean isUploadResumable() {
        return true;
    }

    public void setStatListSupportedEnabled(boolean e) {
        this.statListSupportedEnabled = e;
    }

    public boolean isStatListSupportedEnabled() {
        return this.statListSupportedEnabled;
    }

    public void setMlsdListSupportedEnabled(boolean e) {
        this.mlsdListSupportedEnabled = e;
    }

    public boolean isMlsdListSupportedEnabled() {
        return this.mlsdListSupportedEnabled;
    }

    public void setExtendedListEnabled(boolean e) {
        this.extendedListEnabled = e;
    }

    public boolean isExtendedListEnabled() {
        return this.extendedListEnabled;
    }

    public boolean isUtimeSupported() {
        return this.utimeSupported;
    }

    public void setUtimeSupported(boolean utimeSupported) {
        this.utimeSupported = utimeSupported;
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new FTPSession(h);
        }
    }
}

