/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.ftp.FTPSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPCommand;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPClient
extends FTPSClient {
    private static Logger log = Logger.getLogger(FTPSession.class);
    private List<String> features = Collections.emptyList();
    private boolean featSupported = Preferences.instance().getBoolean("ftp.command.feat");
    private static final Map<Integer, String> commands = new HashMap<Integer, String>();
    public static final int MLST = 50;
    public static final int MLSD = 51;
    public static final int SIZE = 52;
    public static final int PRET = 53;
    private List<String> versions = Collections.emptyList();

    public FTPClient() throws NoSuchAlgorithmException {
        super("TLS", false);
    }

    public List<String> listFeatures() throws IOException {
        if (this.features.isEmpty() && this.featSupported) {
            if (FTPReply.isPositiveCompletion((int)this.feat())) {
                this.features = Arrays.asList(this.getReplyStrings());
            } else {
                this.featSupported = false;
            }
        }
        return this.features;
    }

    public boolean isFeatureSupported(int command) throws IOException {
        return this.isFeatureSupported(this.getCommand(command));
    }

    public boolean isFeatureSupported(String feature) throws IOException {
        for (String item : this.listFeatures()) {
            if (!item.trim().startsWith(feature)) continue;
            return true;
        }
        log.warn((Object)("No " + feature + " support"));
        return false;
    }

    public int sendCommand(int command, String args) throws IOException {
        return super.sendCommand(this.getCommand(command), args);
    }

    protected String getCommand(int command) {
        String value = commands.get(command);
        if (null == value) {
            return FTPCommand.getCommand((int)command);
        }
        return value;
    }

    protected Socket _openDataConnection_(int command, String arg) throws IOException {
        Socket socket = super._openDataConnection_(command, arg);
        if (null == socket) {
            throw new FTPException(this.getReplyString());
        }
        return socket;
    }

    public void setEnabledProtocols(String[] protocols) {
        this.versions = Arrays.asList(protocols);
        super.setEnabledProtocols(protocols);
    }

    protected void execAUTH() throws IOException {
        if (this.versions.isEmpty()) {
            log.debug((Object)"No trust manager configured");
            return;
        }
        super.execAUTH();
    }

    public void execPROT(String prot) throws SSLException, IOException {
        block2: {
            try {
                super.execPROT(prot);
            }
            catch (SSLException e) {
                if (!"P".equals(prot)) break block2;
                log.warn((Object)("No data channel security: " + e.getMessage()));
                this.setSocketFactory(null);
                this.setServerSocketFactory(null);
            }
        }
    }

    protected void sslNegotiation() throws IOException {
        if (this.versions.isEmpty()) {
            log.debug((Object)"No trust manager configured");
            return;
        }
        super.sslNegotiation();
    }

    public List<String> list(int command) throws IOException {
        return this.list(command, null);
    }

    public List<String> list(int command, String pathname) throws IOException {
        String line;
        this.pret(this.getCommand(command));
        Socket socket = this._openDataConnection_(command, pathname);
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), this.getControlEncoding()));
        ArrayList<String> results = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            this._commandSupport_.fireReplyReceived(-1, line);
            results.add(line);
        }
        reader.close();
        socket.close();
        if (this.completePendingCommand()) {
            return results;
        }
        return Collections.emptyList();
    }

    public boolean retrieveFile(String remote, OutputStream local) throws IOException {
        this.pret(this.getCommand(13));
        return super.retrieveFile(remote, local);
    }

    public InputStream retrieveFileStream(String remote) throws IOException {
        this.pret(this.getCommand(13));
        return super.retrieveFileStream(remote);
    }

    public boolean storeFile(String remote, InputStream local) throws IOException {
        this.pret(this.getCommand(14));
        return super.storeFile(remote, local);
    }

    public OutputStream storeFileStream(String remote) throws IOException {
        this.pret(this.getCommand(14));
        return super.storeFileStream(remote);
    }

    public boolean appendFile(String remote, InputStream local) throws IOException {
        this.pret(this.getCommand(16));
        return super.appendFile(remote, local);
    }

    public OutputStream appendFileStream(String remote) throws IOException {
        this.pret(this.getCommand(16));
        return super.appendFileStream(remote);
    }

    protected void pret(String file) throws IOException {
        if (this.isFeatureSupported(53) && !FTPReply.isPositiveCompletion((int)this.sendCommand(53, file))) {
            log.warn((Object)("PRET command failed:" + this.getReplyString()));
        }
    }

    public long getSize(String pathname) throws IOException {
        if (this.isFeatureSupported(52)) {
            if (!this.setFileType(2)) {
                throw new FTPException(this.getReplyString());
            }
            if (FTPReply.isPositiveCompletion((int)this.sendCommand(52, pathname))) {
                String status = StringUtils.chomp((String)this.getReplyString().substring(3).trim());
                Matcher matcher = Pattern.compile("\\d+").matcher(status);
                if (matcher.matches()) {
                    try {
                        return Long.parseLong(matcher.group());
                    }
                    catch (NumberFormatException ex) {
                        log.warn((Object)("Failed to parse reply:" + status));
                    }
                }
            }
        }
        return -1L;
    }

    static {
        commands.put(50, "MLST");
        commands.put(51, "MLSD");
        commands.put(52, "SIZE");
        commands.put(53, "PRET");
    }
}

