/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.eucalyptus;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.s3.S3Session;
import java.util.Collections;
import java.util.List;
import org.jets3t.service.Jets3tProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ECSession
extends S3Session {
    public static SessionFactory factory() {
        return new Factory();
    }

    public ECSession(Host h) {
        super(h);
    }

    @Override
    protected void configure(String hostname) {
        super.configure(hostname);
        Jets3tProperties configuration = this.getProperties();
        configuration.setProperty("s3service.s3-endpoint-virtual-path", Path.normalize("/services/Walrus"));
        configuration.setProperty("s3service.disable-dns-buckets", String.valueOf(true));
        configuration.setProperty("s3service.enable-storage-classes", String.valueOf(false));
    }

    @Override
    public List<String> getSupportedStorageClasses() {
        return Collections.emptyList();
    }

    @Override
    public boolean isCDNSupported() {
        return false;
    }

    @Override
    public boolean isLoggingSupported() {
        return false;
    }

    @Override
    public boolean isVersioningSupported() {
        return false;
    }

    @Override
    public boolean isBucketLocationSupported() {
        return false;
    }

    @Override
    public boolean isRequesterPaysSupported() {
        return false;
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new ECSession(h);
        }
    }
}

