/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathFactory;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.Status;
import ch.cyberduck.core.StreamListener;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.dropbox.client.ListEntryResponse;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.io.BandwidthThrottle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.log4j.Logger;
import org.soyatec.windows.azure.error.StorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropboxPath
extends Path {
    private static Logger log = Logger.getLogger(DropboxPath.class);
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
    private final DropboxSession session;

    public static PathFactory factory() {
        return new Factory();
    }

    protected DropboxPath(DropboxSession s, String parent, String name, int type) {
        super(parent, name, type);
        this.session = s;
    }

    protected DropboxPath(DropboxSession s, String path, int type) {
        super(path, type);
        this.session = s;
    }

    protected DropboxPath(DropboxSession s, String parent, Local file) {
        super(parent, file);
        this.session = s;
    }

    protected <T> DropboxPath(DropboxSession s, T dict) {
        super(dict);
        this.session = s;
    }

    @Override
    public DropboxSession getSession() {
        return this.session;
    }

    @Override
    public AttributedList<Path> list(AttributedList<Path> children) {
        block6: {
            if (this.attributes().isDirectory()) {
                try {
                    this.getSession().check();
                    this.getSession().message(MessageFormat.format(Locale.localizedString("Listing directory {0}", "Status"), this.getName()));
                    for (ListEntryResponse entry : this.getSession().getClient().list(this.getAbsolute()).getContents()) {
                        Path file = PathFactory.createPath((Session)this.getSession(), entry.getPath(), entry.isDirectory() ? 2 : 1);
                        file.setParent(this);
                        file.attributes().setSize(entry.getLength());
                        file.attributes().setChecksum(entry.getHash());
                        try {
                            file.attributes().setModificationDate(SIMPLE_DATE_FORMAT.parse(entry.getModified()).getTime());
                        }
                        catch (ParseException e) {
                            log.warn((Object)("Failed parsing modification date:" + e.getMessage()));
                        }
                        file.attributes().setRevision(entry.getRevision());
                        file.attributes().setChecksum(entry.getHash());
                        children.add(file);
                    }
                    this.getSession().setWorkdir(this);
                }
                catch (IOException e) {
                    log.warn((Object)("Listing directory failed:" + e.getMessage()));
                    children.attributes().setReadable(false);
                    if (!this.cache().isEmpty()) break block6;
                    this.error(e.getMessage(), e);
                }
            }
        }
        return children;
    }

    private ListEntryResponse readMetadata() throws IOException {
        return this.getSession().getClient().metadata(this.getAbsolute());
    }

    @Override
    public void readSize() {
        if (this.attributes().isFile()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Getting size of {0}", "Status"), this.getName()));
                ListEntryResponse response = this.readMetadata();
                this.attributes().setSize(response.getLength());
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    @Override
    public void readChecksum() {
        if (this.attributes().isFile()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Compute MD5 hash of {0}", "Status"), this.getName()));
                ListEntryResponse response = this.readMetadata();
                this.attributes().setChecksum(response.getHash());
            }
            catch (IOException e) {
                this.error("Cannot read file attributes", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void download(BandwidthThrottle throttle, StreamListener listener, boolean check) {
        if (!this.attributes().isFile()) return;
        OutputStream out = null;
        InputStream in = null;
        try {
            try {
                if (check) {
                    this.getSession().check();
                }
                in = this.getSession().getClient().get(this.getAbsolute(), this.attributes().getChecksum());
                out = this.getLocal().getOutputStream(this.status().isResume());
                this.download(in, out, throttle, listener);
            }
            catch (StorageException e) {
                this.error("Download failed", e);
                Object var8_7 = null;
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                return;
            }
            catch (IOException e) {
                this.error("Download failed", e);
                Object var8_8 = null;
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                return;
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void upload(final BandwidthThrottle throttle, final StreamListener listener, boolean check) {
        if (!this.attributes().isFile()) return;
        try {
            if (check) {
                this.getSession().check();
            }
            Status status = this.status();
            status.setResume(false);
            final Local local = this.getLocal();
            final InputStream in = local.getInputStream();
            try {
                try {
                    this.getSession().getClient().put(this.getParent().getAbsolute(), (ContentBody)new InputStreamBody(in, local.getMimeType(), this.getName()){

                        public void writeTo(OutputStream out) throws IOException {
                            DropboxPath.this.upload(out, in, throttle, listener);
                        }

                        public long getContentLength() {
                            return local.attributes().getSize();
                        }
                    });
                }
                catch (IOException e) {
                    this.status().setComplete(false);
                    throw e;
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            return;
        }
        catch (IOException e) {
            this.error("Upload failed", e);
        }
    }

    @Override
    public void mkdir() {
        if (this.attributes().isDirectory()) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Making directory {0}", "Status"), this.getName()));
                this.getSession().getClient().create(this.getAbsolute());
                this.cache().put(this.getReference(), AttributedList.emptyList());
                this.getParent().invalidate();
            }
            catch (IOException e) {
                this.error("Cannot create folder {0}", e);
            }
        }
    }

    @Override
    public void delete() {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Deleting {0}", "Status"), this.getName()));
            this.getSession().getClient().delete(this.getAbsolute());
            this.getParent().invalidate();
        }
        catch (IOException e) {
            this.error("Cannot delete {0}", e);
        }
    }

    @Override
    public void rename(AbstractPath renamed) {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Renaming {0} to {1}", "Status"), this.getName(), renamed));
            this.getSession().getClient().move(this.getAbsolute(), renamed.getAbsolute());
            renamed.getParent().invalidate();
            this.getParent().invalidate();
        }
        catch (IOException e) {
            this.error("Cannot rename {0}", e);
        }
    }

    @Override
    public void copy(AbstractPath copy) {
        if (((Path)copy).getSession().equals(this.getSession())) {
            try {
                this.getSession().check();
                this.getSession().message(MessageFormat.format(Locale.localizedString("Copying {0} to {1}", "Status"), this.getName(), copy));
                if (this.attributes().isFile()) {
                    this.getSession().getClient().copy(this.getAbsolute(), copy.getAbsolute());
                } else if (this.attributes().isDirectory()) {
                    for (AbstractPath i : this.children()) {
                        if (!this.getSession().isConnected()) break;
                        i.copy(PathFactory.createPath(this.getSession(), copy.getAbsolute(), i.getName(), i.attributes().getType()));
                    }
                }
                copy.getParent().invalidate();
            }
            catch (IOException e) {
                this.error("Cannot copy {0}");
            }
        } else {
            super.copy(copy);
        }
    }

    @Override
    public void writeTimestamp(long created, long modified, long accessed) {
    }

    @Override
    public void readTimestamp() {
        try {
            this.getSession().check();
            this.getSession().message(MessageFormat.format(Locale.localizedString("Getting timestamp of {0}", "Status"), this.getName()));
            ListEntryResponse response = this.readMetadata();
            try {
                this.attributes().setModificationDate(SIMPLE_DATE_FORMAT.parse(response.getModified()).getTime());
            }
            catch (ParseException e) {
                log.warn((Object)("Failed parsing modification date:" + e.getMessage()));
            }
        }
        catch (IOException e) {
            this.error("Cannot read file attributes", e);
        }
    }

    @Override
    public void writeUnixPermission(Permission perm, boolean recursive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readUnixPermission() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<AbstractPath.DescriptiveUrl> getHttpURLs() {
        return Collections.emptySet();
    }

    @Override
    protected String toHttpURL(String host) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory
    extends PathFactory<DropboxSession> {
        private Factory() {
        }

        @Override
        protected Path create(DropboxSession session, String path, int type) {
            return new DropboxPath(session, path, type);
        }

        @Override
        protected Path create(DropboxSession session, String parent, String name, int type) {
            return new DropboxPath(session, parent, name, type);
        }

        @Override
        protected Path create(DropboxSession session, String parent, Local file) {
            return new DropboxPath(session, parent, file);
        }

        @Override
        protected <T> Path create(DropboxSession session, T dict) {
            return new DropboxPath(session, dict);
        }
    }
}

