/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.ConnectionCanceledException;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginCanceledException;
import ch.cyberduck.core.LoginController;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Preferences;
import ch.cyberduck.core.Proxy;
import ch.cyberduck.core.ProxyFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionFactory;
import ch.cyberduck.core.dav.DAVResource;
import ch.cyberduck.core.http.HTTP3Session;
import ch.cyberduck.core.i18n.Locale;
import java.io.IOException;
import java.net.InetAddress;
import java.text.MessageFormat;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.BasicScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.httpclient.params.HostParams;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.webdav.lib.WebdavResource;

public class DAVSession
extends HTTP3Session {
    private static Logger log = Logger.getLogger(DAVSession.class);
    private DAVResource DAV;

    public static SessionFactory factory() {
        return new Factory();
    }

    public DAVSession(Host h) {
        super(h);
    }

    public void check() throws IOException {
        super.check();
        if (this.isConnected()) {
            this.getClient().clearHeaders();
        }
    }

    protected DAVResource getClient() throws ConnectionCanceledException {
        if (null == this.DAV) {
            throw new ConnectionCanceledException();
        }
        return this.DAV;
    }

    protected void configure() throws IOException {
        HttpClient client = this.getClient().getSessionInstance(this.getClient().getHttpURL(), false);
        HostConfiguration configuration = this.getHostConfiguration();
        HostParams parameters = configuration.getParams();
        parameters.setParameter("http.protocol.expect-continue", (Object)Boolean.TRUE);
        client.setHostConfiguration(configuration);
        if (Preferences.instance().getBoolean("connection.proxy.enable")) {
            Proxy proxy = ProxyFactory.instance();
            if (this.host.getProtocol().isSecure()) {
                if (proxy.isHTTPSProxyEnabled(this.host)) {
                    this.getClient().setProxy(proxy.getHTTPSProxyHost(this.host), proxy.getHTTPSProxyPort(this.host));
                } else {
                    this.getClient().setProxy(null, -1);
                    this.getClient().setProxyCredentials(null);
                }
            } else if (proxy.isHTTPProxyEnabled(this.host)) {
                this.getClient().setProxy(proxy.getHTTPProxyHost(this.host), proxy.getHTTPProxyPort(this.host));
            } else {
                this.getClient().setProxy(null, -1);
                this.getClient().setProxyCredentials(null);
            }
        }
        this.getClient().setFollowRedirects(Preferences.instance().getBoolean("webdav.followRedirects"));
        this.getClient().setOverwrite(true);
    }

    protected void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        this.fireConnectionWillOpenEvent();
        WebdavResource.setDefaultAction((int)1);
        this.DAV = new DAVResource(this.host);
        String workdir = this.host.getDefaultPath();
        if (StringUtils.isNotBlank((String)workdir)) {
            this.getClient().setPath(workdir.startsWith(String.valueOf('/')) ? workdir : String.valueOf('/') + workdir);
        }
        this.configure();
        this.login();
        WebdavResource.setDefaultAction((int)3);
        this.fireConnectionDidOpenEvent();
    }

    protected void prompt(LoginController login) throws LoginCanceledException {
    }

    protected void warn(LoginController login, Credentials credentials) throws IOException {
    }

    protected void login(final LoginController controller, final Credentials credentials) throws IOException {
        try {
            HttpClient client = this.getClient().getSessionInstance(this.getClient().getHttpURL(), false);
            if (credentials.validate(this.host.getProtocol())) {
                this.getClient().setCredentials((org.apache.commons.httpclient.Credentials)new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword()));
            }
            client.getParams().setParameter("http.authentication.preemptive", (Object)true);
            client.getParams().setParameter("http.authentication.credential-provider", (Object)new CredentialsProvider(){
                int retry = 0;

                public org.apache.commons.httpclient.Credentials getCredentials(AuthScheme authscheme, String hostname, int port, boolean proxy) throws CredentialsNotAvailableException {
                    if (null == authscheme) {
                        return null;
                    }
                    try {
                        StringBuilder realm = new StringBuilder(hostname);
                        realm.append(":").append(port).append(".");
                        if (StringUtils.isNotBlank((String)authscheme.getRealm())) {
                            realm.append(" ").append(authscheme.getRealm());
                        }
                        if (0 == this.retry) {
                            controller.check(DAVSession.this.host, Locale.localizedString("Login with username and password", "Credentials"), realm.toString());
                        } else {
                            controller.fail(DAVSession.this.host.getProtocol(), credentials, realm.toString());
                        }
                        DAVSession.this.message(MessageFormat.format(Locale.localizedString("Authenticating as {0}", "Status"), credentials.getUsername()));
                        ++this.retry;
                        if (authscheme instanceof RFC2617Scheme) {
                            if (authscheme instanceof BasicScheme) {
                                DAVSession.super.warn(controller, credentials);
                            }
                            return new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword());
                        }
                        if (authscheme instanceof NTLMScheme) {
                            return new NTCredentials(credentials.getUsername(), credentials.getPassword(), InetAddress.getLocalHost().getHostName(), Preferences.instance().getProperty("webdav.ntlm.domain"));
                        }
                        throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
                    }
                    catch (LoginCanceledException e) {
                        throw new CredentialsNotAvailableException(e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new CredentialsNotAvailableException(e.getMessage(), (Throwable)e);
                    }
                }
            });
            this.getClient().setProperties(3, 0);
            this.message(Locale.localizedString("Login successful", "Credentials"));
        }
        catch (HttpException e) {
            if (e.getReasonCode() == 401) {
                throw new LoginCanceledException();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        try {
            block4: {
                try {
                    if (!this.isConnected()) break block4;
                    this.fireConnectionWillCloseEvent();
                    this.getClient().close();
                }
                catch (IOException e) {
                    log.error((Object)("IO Error: " + e.getMessage()));
                    Object var3_2 = null;
                    this.DAV = null;
                    this.fireConnectionDidCloseEvent();
                    return;
                }
            }
            Object var3_1 = null;
            this.DAV = null;
            this.fireConnectionDidCloseEvent();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.DAV = null;
            this.fireConnectionDidCloseEvent();
            throw throwable;
        }
    }

    public void setWorkdir(Path workdir) throws IOException {
        if (!this.isConnected()) {
            throw new ConnectionCanceledException();
        }
        this.getClient().setPath(workdir.isRoot() ? String.valueOf('/') : workdir.getAbsolute() + String.valueOf('/'));
        super.setWorkdir(workdir);
    }

    public boolean isUnixPermissionsSupported() {
        return false;
    }

    public boolean isTimestampSupported() {
        return false;
    }

    public void error(Path path, String message, Throwable e) {
        if (e instanceof HttpException) {
            String status = HttpStatus.getStatusText((int)((HttpException)e).getReasonCode());
            if (StringUtils.isNotBlank((String)status)) {
                super.error(path, message, new HttpException(status));
            } else {
                super.error(path, message, e);
            }
        } else {
            super.error(path, message, e);
        }
    }

    private static class Factory
    extends SessionFactory {
        private Factory() {
        }

        protected Session create(Host h) {
            return new DAVSession(h);
        }
    }
}

